/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.list;

import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.core.VersionedSet;
import java.util.Objects;

public class SelectionModel
extends VersionedSet<Integer> {
    private SelectionMode mode = SelectionMode.Single;
    private Integer lastAdd;
    private VersionedHolder<Integer> selected = new VersionedHolder(null);

    public VersionedReference<Integer> createSelectionReference() {
        return this.selected.createReference();
    }

    public void setSelectionMode(SelectionMode mode) {
        if (this.mode == mode) {
            return;
        }
        if (mode == SelectionMode.Contiguous) {
            throw new UnsupportedOperationException("Contiguous selection mode not yet implemented.");
        }
        this.mode = mode;
        if (mode == SelectionMode.Single && this.size() > 1) {
            if (this.contains(this.lastAdd)) {
                this.clear();
                this.add(this.lastAdd);
            } else {
                Integer temp = (Integer)this.iterator().next();
                this.clear();
                this.add(temp);
            }
        }
    }

    public SelectionMode getSelectionMode() {
        return this.mode;
    }

    public Integer getSelection() {
        if (this.size() != 1) {
            return null;
        }
        return this.lastAdd;
    }

    public void setSelection(Integer selection) {
        if (Objects.equals(selection, this.lastAdd) && this.size() == 1) {
            return;
        }
        this.clear();
        if (selection >= 0) {
            this.add(selection);
        }
    }

    @Override
    public boolean add(Integer selection) {
        if (this.mode == SelectionMode.Single) {
            if (Objects.equals(selection, this.lastAdd) && this.size() == 1) {
                return false;
            }
            this.clear();
        }
        this.lastAdd = selection;
        return super.add(selection);
    }

    @Override
    protected void incrementVersion() {
        super.incrementVersion();
        this.updateSelected();
    }

    protected void updateSelected() {
        Integer i = this.getSelection();
        if (Objects.equals(i, this.selected.getObject())) {
            return;
        }
        this.selected.setObject((Object)i);
    }

    public static enum SelectionMode {
        Single,
        Contiguous,
        Multi;

    }
}

