/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.World;
import com.simsilica.mworld.net.client.WorldClientService;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Iterator;
import java.util.Objects;
import mythruna.client.view.AvatarState;
import mythruna.client.view.BlockTypeSelectionState;
import mythruna.client.view.ClaimViewState;
import mythruna.client.view.ManipulatorType;
import mythruna.client.view.WorldMarkerState;
import mythruna.es.ClaimPermissions;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiggerManipulator
implements ManipulatorType {
    static Logger log = LoggerFactory.getLogger(DiggerManipulator.class);
    private WorldClientService world;
    private WorldMarkerState markers;
    private GameSession session;
    private AvatarState avatar;
    private EntityId target;
    private float timer = 0.0f;
    private float timeout = 0.1f;
    private boolean valid = false;
    private Vec3d lastViewPos = new Vec3d();
    private BlockType hitType;
    private Vec3i hitLoc;
    private Vec3d hitNormal;

    public DiggerManipulator(World world, WorldMarkerState markers, GameSession session, AvatarState avatar) {
        this.world = (WorldClientService)world;
        this.markers = markers;
        this.session = session;
        this.avatar = avatar;
    }

    @Override
    public void setTarget(EntityId target) {
        this.target = target;
        if (target == null) {
            this.setHit(null, null, null);
        }
    }

    @Override
    public void update(float tpf) {
        if (!this.valid) {
            this.timer += tpf;
            if (this.timer > this.timeout) {
                this.validate(false);
            }
        }
    }

    protected void setHit(Vec3i loc, BlockType type, Vec3d normal) {
        if (Objects.equals(this.hitLoc, loc) && this.hitType == type && Objects.equals(this.hitNormal, normal)) {
            return;
        }
        if (this.hitLoc != null) {
            this.markers.removeBlockMarker(this.hitLoc);
        }
        this.hitLoc = loc;
        this.hitType = type;
        this.hitNormal = normal;
        if (this.hitLoc != null) {
            this.markers.addBlockMarker(this.hitLoc, this.hitType, this.hitNormal);
        }
    }

    protected void invalidate() {
        this.valid = false;
        this.timer = 0.0f;
    }

    protected void validate(boolean now) {
        if (this.valid) {
            return;
        }
        this.valid = true;
        Rayd view = this.avatar.getViewRay();
        QueryBlockHit query = new QueryBlockHit(view);
        if (now) {
            query.runOnWorker();
            query.runOnUpdate();
        } else {
            ((JobState)this.avatar.getState(JobState.class, true)).execute((Job)query, 0);
        }
    }

    @Override
    public void viewChanged(Vec3d pos, Quatd facing) {
        this.invalidate();
        if (this.lastViewPos.distanceSq(pos) > 1.0) {
            this.lastViewPos.set(pos);
            this.setHit(null, null, null);
        }
    }

    @Override
    public void activate(boolean pressed) {
        this.validate(true);
        if (this.hitLoc == null) {
            return;
        }
        if (pressed) {
            this.session.runAction(this.target, "startDigging", new Object[]{this.hitLoc});
            this.startDigging(this.hitLoc);
        } else {
            long start = System.nanoTime();
            this.session.runAction(this.target, "stopDigging", new Object[]{this.hitLoc});
            long end = System.nanoTime();
            log.info("Ran action stopDigging in:" + (double)(end - start) / 1000000.0 + " ms");
            start = System.nanoTime();
            this.stopDigging(this.hitLoc);
            end = System.nanoTime();
            log.info("Ran method stopDigging in:" + (double)(end - start) / 1000000.0 + " ms");
            this.invalidate();
        }
    }

    @Override
    public void altActivate(boolean pressed) {
        BlockType existingType;
        this.validate(true);
        if (this.hitLoc == null) {
            return;
        }
        int type = ((BlockTypeSelectionState)this.avatar.getState(BlockTypeSelectionState.class)).getSelectedType();
        if (type <= 0) {
            return;
        }
        log.info("pressed:" + pressed + " hit:" + this.hitLoc + "  type:" + this.hitType + "  normal:" + this.hitNormal);
        Vec3d pos = this.hitLoc.toVec3d().addLocal(this.hitNormal);
        int existing = MaskUtils.getType((int)this.world.getWorldCell(pos));
        if (existing != 0 && (existingType = BlockTypeIndex.get((int)existing)) != null && existingType.getColliderType() != null) {
            log.info("already a solid block there");
            return;
        }
        Vec3i loc = pos.floor();
        log.info("adjusted hit:" + loc + "  existing value:" + existing);
        if (pressed) {
            this.session.runAction(this.target, "startFilling", new Object[]{loc, type});
            this.startFilling(loc, type);
        } else {
            long start = System.nanoTime();
            this.session.runAction(this.target, "stopFilling", new Object[]{loc, type});
            long end = System.nanoTime();
            log.info("Ran action stopFilling in:" + (double)(end - start) / 1000000.0 + " ms");
            start = System.nanoTime();
            this.stopFilling(loc, type);
            end = System.nanoTime();
            log.info("Ran method stopFilling in:" + (double)(end - start) / 1000000.0 + " ms");
            this.invalidate();
        }
    }

    @Override
    public void change(int delta) {
        this.session.runAction(this.target, "rotate", new Object[]{delta});
    }

    protected void startDigging(Vec3i loc) {
    }

    protected void stopDigging(Vec3i loc) {
        log.info("hit:" + this.hitLoc + "  type:" + this.hitType);
        ClaimPermissions perms = this.getPerms(loc);
        if (!perms.canRemoveBlock()) {
            log.info("Not allowed to remove");
            return;
        }
        log.info("Removing block from:" + loc);
        long start = System.nanoTime();
        boolean result = this.world.setLocalWorldCell(loc, 0);
        long end = System.nanoTime();
        log.info("set local world cell result:" + result + "  in:" + (double)(end - start) / 1000000.0 + " ms");
    }

    protected void startFilling(Vec3i loc, int type) {
    }

    protected void stopFilling(Vec3i loc, int type) {
        ClaimPermissions perms = this.getPerms(loc);
        if (!perms.canAddBlock()) {
            log.info("Not allowed to remove");
            return;
        }
        log.info("Setting block:" + loc + "  to:" + type);
        long start = System.nanoTime();
        boolean result = this.world.setLocalWorldCell(loc, type);
        long end = System.nanoTime();
        log.info("set local world cell result:" + result + "  in:" + (double)(end - start) / 1000000.0 + " ms");
    }

    protected ClaimPermissions getPerms(Vec3i loc) {
        return ((ClaimViewState)this.avatar.getState(ClaimViewState.class)).getPerms(loc);
    }

    private class QueryBlockHit
    implements Job {
        private Rayd ray;
        private BlockIterator.Intersection hit;

        public QueryBlockHit(Rayd ray) {
            this.ray = ray;
        }

        public void runOnWorker() {
            Iterator<BlockIterator.Intersection> it = DiggerManipulator.this.avatar.pick(this.ray, 10);
            if (it.hasNext()) {
                this.hit = it.next();
                if (log.isDebugEnabled()) {
                    log.debug("hit:" + this.hit);
                }
            } else {
                this.hit = null;
            }
        }

        public double runOnUpdate() {
            if (this.hit != null) {
                DiggerManipulator.this.setHit(this.hit.getBlock(), BlockTypeIndex.get((int)this.hit.getType()), this.hit.getNormal());
            } else {
                DiggerManipulator.this.setHit(null, null, null);
            }
            return 0.0;
        }
    }
}

