/*
 * $Id$
 * 
 * Copyright (c) 2023, Simsilica, LLC
 * All rights reserved.
 */

def markObjectTypeName = "!mark"
def markObjectType = ObjectTypeInfo.create(markObjectTypeName, entityData);
def markFilter = Filters.fieldEquals(ObjectTypeInfo.class, "typeId", markObjectType.typeId); 
 

getMarks = {
    return findEntities(markFilter, Name.class, ObjectTypeInfo.class, SpawnPosition.class);
}

setMark = { String name, SpawnPosition pos ->
    log.info("setMark(" + name+ ", " + pos + ")");
    // See if there already is an entity with this name
    def mark = getMark(name);
    if( mark ) {
        mark << pos 
    } else {
        mark = createEntity(
            new Name(name),
            markObjectType,
            pos
        );
    }
    return mark;
}

getMark = { String name ->
    for( def mark : getMarks() ) {
        if( name == mark.name ) {
            return mark;
        }
    }
    return null;
}

removeMark = { String name ->
    def mark = getMark(name);
    if( mark ) {
        entityData.removeEntity(mark);
        return mark;
    } else {
        return null;
    } 
}
