/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.base;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.DataType;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.transaction.WorldEdits;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldCellData
implements CellData {
    static Logger log = LoggerFactory.getLogger(WorldCellData.class);
    private World world;
    private LeafData center;
    private Map<LeafId, LeafData> neighbors = new HashMap<LeafId, LeafData>();
    private Set<LeafData> modified = new HashSet<LeafData>();
    private Map<Vec3i, CellChangeEvent> changes = new LinkedHashMap<Vec3i, CellChangeEvent>();
    private WorldEdits worldEdits = new WorldEdits();

    public WorldCellData(LeafData center, World world) {
        this.world = world;
        this.center = center;
    }

    public Set<LeafData> getModified() {
        return this.modified;
    }

    public Collection<CellChangeEvent> getChanges() {
        return this.worldEdits.createCellChangeEvents();
    }

    private LeafData getLeaf(int x, int y, int z) {
        if (y < 0) {
            return null;
        }
        if (this.center.containsCell(x, y, z)) {
            return this.center;
        }
        LeafId leafId = LeafId.fromWorld(x, y, z);
        LeafData neighbor = this.neighbors.get(leafId);
        if (neighbor == null) {
            neighbor = this.world.getLeaf(leafId);
            this.neighbors.put(leafId, neighbor);
        }
        return neighbor;
    }

    public int getCell(int x, int y, int z) {
        return this.getCell(x, y, z, -1);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        LeafData leaf = this.getLeaf(x, y, z);
        if (leaf == null) {
            return defaultValue;
        }
        Vec3i leafWorld = leaf.getInfo().location;
        int xCell = x - leafWorld.x;
        int yCell = y - leafWorld.y;
        int zCell = z - leafWorld.z;
        return leaf.getCell(xCell, yCell, zCell, defaultValue);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        if (y == 0 && dir == Direction.Down) {
            return defaultValue;
        }
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    public void setCell(int x, int y, int z, int value) {
        LeafData leaf = this.getLeaf(x, y, z);
        if (leaf == null) {
            return;
        }
        Vec3i leafWorld = leaf.getInfo().location;
        int xCell = x - leafWorld.x;
        int yCell = y - leafWorld.y;
        int zCell = z - leafWorld.z;
        int oldValue = leaf.getCell(xCell, yCell, zCell);
        leaf.setCell(xCell, yCell, zCell, value);
        if (oldValue != value) {
            this.modified.add(leaf);
            this.worldEdits.cellChanged(null, leaf.getInfo().leafId, DataType.Block, xCell, yCell, zCell, value, oldValue);
        }
    }
}

