/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.fractal.PerlinNoise;
import com.simsilica.fractal.Sampler;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.util.Random;
import mythruna.world.BioInfo;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import mythruna.world.tree.ChristmasTreeType;
import mythruna.world.tree.PineTreeType;
import mythruna.world.tree.ScrubTreeType;
import mythruna.world.tree.SimpleTreeType;
import mythruna.world.tree.SmallScrubTreeType;
import mythruna.world.tree.UmbrellaTreeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeGenerator
implements TileFunction,
AutoCloseable {
    static Logger log = LoggerFactory.getLogger(TreeGenerator.class);
    private TreeTypeIndex treeTypes;
    private static final double VEG1 = 0.2;
    private static final double VEG2 = 0.25;
    private static final double VEG3 = 0.4;
    private static final double VEG4 = 0.5;
    private static final double VEG5 = 0.75;
    private static final double VEG6 = 1.0;
    private static final double PROB1 = 0.001;
    private static final double PROB2 = 0.003;
    private static final double PROB3 = 0.01;
    private static final double PROB4 = 0.1;
    private static final double PROB5 = 0.75;
    private static final double PROB6 = 1.0;
    private String atlasName = "Textures/tree-atlas.png";
    private TreeType simple = new SimpleTreeType("simple", new AtlasCell(this.atlasName, 0));
    private TreeType simple2 = new SimpleTreeType("simple2", new AtlasCell(this.atlasName, 0), true);
    private TreeType umbrella = new UmbrellaTreeType("umbrella", new AtlasCell(this.atlasName, 2));
    private TreeType scrub = new ScrubTreeType("scrub", new AtlasCell(this.atlasName, 3));
    private TreeType smallScrub = new SmallScrubTreeType("smallScrub", new AtlasCell(this.atlasName, 0));
    private TreeType pine = new PineTreeType("pine1", new AtlasCell(this.atlasName, 4));
    private TreeType smallPine = new PineTreeType("pine2", new AtlasCell(this.atlasName, 4), 0, 3, 4, 3);
    private TreeType scrubPine = new PineTreeType("pine3", new AtlasCell(this.atlasName, 4), 4, 3, 3, 6);
    private TreeType fir = new PineTreeType("pine4", new AtlasCell(this.atlasName, 4), 1, 3, 8, 7);
    private TreeType densePine = new PineTreeType("pine5", new AtlasCell(this.atlasName, 4), 2, 4, 3, 12);
    private TreeType xmas = new ChristmasTreeType("xmas", new AtlasCell(this.atlasName, 4), 4, 3, 3, 6);
    private static int DENSITY_LOW = 0;
    private static int DENSITY_MEDIUM = 1;
    private static int DENSITY_HIGH = 2;
    private static int TEMPERATURE_ZONES = 7;
    private TreeType[][][] treeZones = new TreeType[][][]{{{this.pine, this.fir, this.smallPine}, {this.pine, this.fir, this.smallPine, this.scrubPine, this.scrubPine}, {this.pine, this.smallPine, this.smallPine, this.densePine, this.densePine, this.densePine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine}}, {{this.pine, this.fir, this.smallPine, this.simple2}, {this.pine, this.fir, this.smallPine, this.scrubPine, this.scrubPine, this.simple2}, {this.pine, this.smallPine, this.smallPine, this.densePine, this.densePine, this.densePine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine}}, {{this.pine, this.fir, this.smallPine, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub}, {this.pine, this.fir, this.smallPine, this.scrubPine, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub}, {this.smallPine, this.scrubPine, this.densePine, this.fir, this.smallPine, this.scrubPine, this.densePine, this.fir, this.scrubPine, this.densePine, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub}}, {{this.pine, this.fir, this.smallPine, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub}, {this.pine, this.fir, this.smallPine, this.scrubPine, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub}, {this.smallPine, this.scrubPine, this.densePine, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.smallScrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub, this.scrubPine, this.scrubPine, this.scrub, this.scrub, this.scrub, this.scrub}}, {{this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.smallScrub, this.smallScrub, this.smallScrub}, {this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrub, this.scrub, this.scrub, this.scrub, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrub, this.scrub, this.scrub, this.scrub}, {this.simple, this.simple2, this.umbrella, this.smallScrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub}}, {{this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.smallScrub, this.smallScrub, this.smallScrub}, {this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrub, this.scrub, this.scrub, this.scrub, this.simple, this.simple2, this.umbrella, this.scrub, this.smallScrub, this.scrub, this.scrub, this.scrub, this.scrub}, {this.simple, this.simple2, this.umbrella, this.smallScrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub, this.scrub}}, {{this.smallScrub, this.smallScrub, this.smallScrub, this.smallScrub, this.simple2}, {this.smallScrub, this.smallScrub, this.simple2}, {this.smallScrub, this.smallScrub, this.simple2}}};
    private WorldFractal fractal;
    private Sampler forest;
    private Sampler noise1 = new PerlinNoise(123L);
    private double snowLine;
    private double treeLine = this.snowLine = 618.0;
    private double deepWater = 28.0;

    public TreeGenerator(WorldFractal fractal) {
        this(fractal, TreeTypeIndex.getInstance());
    }

    public TreeGenerator(WorldFractal fractal, TreeTypeIndex treeTypes) {
        this.fractal = fractal;
        this.treeTypes = treeTypes;
        treeTypes.registerType(this.simple);
        treeTypes.registerType(this.umbrella);
        treeTypes.registerType(this.scrub);
        treeTypes.registerType(this.pine);
        treeTypes.registerType(this.smallPine);
        treeTypes.registerType(this.scrubPine);
        treeTypes.registerType(this.xmas);
        treeTypes.registerType(this.smallScrub);
        treeTypes.registerType(this.simple2);
        treeTypes.registerType(this.fir);
        treeTypes.registerType(this.densePine);
        treeTypes.initialize();
    }

    @Override
    public void close() {
        this.treeTypes.terminate();
    }

    public void accept(Tile tile) {
        TreeLayer trees = (TreeLayer)tile.get(TreeLayer.class);
        if (trees.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        log.info("Generating trees for tile:" + tile);
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        TileId id = tile.getTileId();
        Vec3i world = id.getWorld(null);
        double xCorner = world.x;
        double zCorner = world.z;
        long mapId = id.getId();
        Random rand = new Random(mapId);
        int seaLevel = 128;
        int treeLine = seaLevel + 490;
        int spacing = 1;
        BioInfo info = new BioInfo();
        boolean[][] used = new boolean[1024][1024];
        for (int x = 1; x < 1023; x += spacing) {
            for (int z = 1; z < 1023; z += spacing) {
                Tree tree;
                double r;
                if (used[x][z]) continue;
                double xp = xCorner + (double)x;
                double zp = zCorner + (double)z;
                byte type = terrain.getType(x, z);
                int baseType = TerrainTypes.getBaseType(type);
                if (baseType != 1 && baseType != 0) continue;
                short y = terrain.getElevation(x, z);
                double yp = y;
                if (y < fluid.getElevation(x, z)) continue;
                int wetnessLevel = (type & 0x60) >> 5;
                int frozen = type & 0x80;
                this.fractal.getBioInfo(xp, yp, zp, info);
                boolean test = false;
                double t = 0.0;
                int density = DENSITY_LOW;
                double veg = 0.0;
                if (baseType == 0) {
                    t = info.vegetationLevel * 0.001;
                } else {
                    veg = info.vegetationLevel;
                    if (veg < 0.2) {
                        t = veg / 0.2;
                        t *= 0.001;
                        density = DENSITY_LOW;
                    } else if (veg < 0.25) {
                        t = (veg - 0.2) / 0.04999999999999999;
                        t = 0.001 + t * 0.002;
                        density = DENSITY_LOW;
                    } else if (veg < 0.4) {
                        t = (veg - 0.25) / 0.15000000000000002;
                        t = 0.003 + t * 0.007;
                        density = DENSITY_MEDIUM;
                    } else if (veg < 0.5) {
                        t = (veg - 0.4) / 0.09999999999999998;
                        t = 0.01 + t * 0.09000000000000001;
                        density = DENSITY_MEDIUM;
                    } else if (veg < 0.75) {
                        t = (veg - 0.5) / 0.25;
                        t = 0.1 + t * 0.65;
                        density = DENSITY_HIGH;
                    } else if (veg < 1.0) {
                        t = (veg - 0.75) / 0.25;
                        t = 0.75 + t * 0.25;
                        density = DENSITY_HIGH;
                    } else {
                        t = 1.0;
                        density = DENSITY_HIGH;
                    }
                }
                if (t == 0.0) continue;
                if (y > treeLine) {
                    t = 1.0E-4 * info.soilQuality;
                }
                if ((r = rand.nextDouble()) >= t) continue;
                int zone = (int)((double)TEMPERATURE_ZONES * info.temperature);
                TreeType[] types = this.treeZones[zone][density];
                int index = rand.nextInt(types.length);
                TreeType treeType = types[index];
                int rootBlocks = 0;
                for (int i = -1; i <= 1; ++i) {
                    for (int k = -1; k <= 1; ++k) {
                        byte nType;
                        int nBaseType;
                        short ny;
                        if (i == 0 && k == 0 || (ny = terrain.getElevation(x + i, z + k)) < y - 1 || (nBaseType = TerrainTypes.getBaseType(nType = terrain.getType(x + i, z + k))) != 1 && nBaseType != 0) continue;
                        if (i == 0 || k == 0) {
                            rootBlocks += 2;
                            continue;
                        }
                        ++rootBlocks;
                    }
                }
                if (rootBlocks < 6 || (tree = treeType.createTree((short)x, y, (short)z, terrain, rand)) == null || x - tree.radius < 0 || z - tree.radius < 0 || x + tree.radius > 1023 || z + tree.radius > 1023) continue;
                trees.addTree(tree);
                tree.type.markTree(tree, used);
            }
        }
    }
}

