/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig;

import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.RigListener;
import com.simsilica.crig.RigType;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.DynArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RigShape
extends MBlockShape
implements CharacterRig {
    static Logger log = LoggerFactory.getLogger(RigShape.class);
    private DynArray<RigListener> listeners = new DynArray(RigListener.class);

    protected RigShape(Part part) {
        super(part);
    }

    public void addRigListener(RigListener l) {
        this.listeners.add((Object)l);
    }

    public void removeRigListener(RigListener l) {
        this.listeners.remove((Object)l);
    }

    public abstract RigType getRigType();

    public abstract void update();

    protected void fireMixChanged(String blendId, double value) {
        for (RigListener l : (RigListener[])this.listeners.getArray()) {
            l.mixChanged(blendId, value);
        }
    }

    protected void fireLayerActionChanged(String layer, String action) {
        for (RigListener l : (RigListener[])this.listeners.getArray()) {
            l.layerActionChanged(layer, action);
        }
    }
}

