/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.io;

import com.simsilica.mblock.io.DataUpdater;
import com.simsilica.mblock.io.UpdateableData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedDataUpdater<T extends UpdateableData<T>>
extends DataUpdater<T> {
    static Logger log = LoggerFactory.getLogger(SerializedDataUpdater.class);

    public SerializedDataUpdater(File target) {
        super(target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(InputStream rawIn) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(rawIn);){
            UpdateableData updateableData = (UpdateableData)in.readObject();
            return (T)updateableData;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error resolving types", e);
        }
    }

    @Override
    public void write(T data, OutputStream rawOut) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(rawOut);){
            out.writeObject(data);
        }
    }
}

