/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import java.util.Arrays;

public class DefaultEntity
implements Entity {
    private EntityData ed;
    private EntityId id;
    private EntityComponent[] components;
    private Class[] types;

    public DefaultEntity(EntityData ed, EntityId id, EntityComponent[] components, Class[] types) {
        this.ed = ed;
        this.id = id;
        this.components = components;
        this.types = types;
        this.validate();
    }

    protected void validate() {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.components[i] == null || this.components[i].getClass() == this.types[i]) continue;
            throw new RuntimeException("Validation error.  components[" + i + "]:" + this.components[i] + " is not of type:" + this.types[i]);
        }
    }

    @Override
    public EntityId getId() {
        return this.id;
    }

    @Override
    public EntityComponent[] getComponents() {
        return this.components;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.id.equals(((DefaultEntity)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public <T extends EntityComponent> T get(Class<T> type) {
        for (EntityComponent c : this.components) {
            if (c == null || c.getClass() != type) continue;
            return (T)((EntityComponent)type.cast(c));
        }
        return null;
    }

    @Override
    public void set(EntityComponent c) {
        for (int i = 0; i < this.components.length; ++i) {
            if (!this.components[i].getClass().isInstance(c)) continue;
            this.ed.setComponent(this.getId(), c);
            this.components[i] = c;
            return;
        }
        this.ed.setComponent(this.id, c);
    }

    @Override
    public boolean isComplete() {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Entity[" + this.id + ", values=" + Arrays.asList(this.components) + "]";
    }
}

