/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeSceneState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CubeSceneState.class);
    private Node scene = new Node("Cube Scene");
    private ColorRGBA color;
    private boolean includeLights;
    private DirectionalLight light;
    private AmbientLight ambient;
    private PointLight pointLight;
    private SpotLight spotLight;

    public CubeSceneState() {
        this(ColorRGBA.Blue, true);
    }

    public CubeSceneState(ColorRGBA color, boolean includeLights) {
        this.color = color;
        this.includeLights = includeLights;
        if (includeLights) {
            this.light = new DirectionalLight();
            this.light.setDirection(new Vector3f(-0.2f, -1.0f, -0.3f).normalizeLocal());
            this.ambient = new AmbientLight();
            this.ambient.setColor(new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f));
            this.pointLight = new PointLight(new Vector3f(-2.0f, 0.0f, -2.0f), 4.0f);
            this.spotLight = new SpotLight(new Vector3f(3.0f, 3.0f, -3.0f), new Vector3f(-1.0f, -1.0f, 1.0f).normalizeLocal(), 10.0f, ColorRGBA.White.mult(2.0f));
            this.spotLight.setSpotOuterAngle(0.2617994f);
            this.spotLight.setSpotInnerAngle(0.17453292f);
        }
    }

    public Node getScene() {
        return this.scene;
    }

    public boolean getIncludeLights() {
        return this.includeLights;
    }

    public DirectionalLight getLight() {
        return this.light;
    }

    public AmbientLight getAmbient() {
        return this.ambient;
    }

    public PointLight getPointLight() {
        return this.pointLight;
    }

    public SpotLight getSpotLight() {
        return this.spotLight;
    }

    public Geometry createCube(float xExtent, float yExtent, float zExtent, ColorRGBA color) {
        Box b = new Box(xExtent, yExtent, zExtent);
        Geometry geom = new Geometry("Box", (Mesh)b);
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Light/Lighting.j3md");
        mat.setColor("Diffuse", color);
        mat.setColor("Ambient", color);
        mat.setBoolean("UseMaterialColors", true);
        geom.setMaterial(mat);
        return geom;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        Geometry geom = this.createCube(1.0f, 1.0f, 1.0f, this.color);
        geom.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.scene.attachChild((Spatial)geom);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        Node rootNode = this.getRoot();
        rootNode.attachChild((Spatial)this.scene);
        if (this.includeLights) {
            rootNode.addLight((Light)this.light);
            rootNode.addLight((Light)this.ambient);
            rootNode.addLight((Light)this.pointLight);
            rootNode.addLight((Light)this.spotLight);
        }
    }

    protected void onDisable() {
        this.scene.removeFromParent();
        if (this.includeLights) {
            Node rootNode = this.getRoot();
            rootNode.removeLight((Light)this.light);
            rootNode.removeLight((Light)this.ambient);
            rootNode.removeLight((Light)this.pointLight);
            rootNode.removeLight((Light)this.spotLight);
        }
    }
}

