/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.tile.pc.PointIndex;
import com.simsilica.mworld.tile.pc.PointIndexFunction;
import com.simsilica.mworld.tile.pc.PointType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointTypeMapping
implements PointIndexFunction {
    static Logger log = LoggerFactory.getLogger(PointTypeMapping.class);
    private final int TERRAIN_BITS = CellGenType.Terrain.getBits();
    private final int FLORA_BITS = CellGenType.Flora.getBits();
    private PointType defaultType = new PointType(0);
    private Set<Integer> groundTypes = new HashSet<Integer>();
    private Set<Integer> skipTypes = new HashSet<Integer>();
    private Map<Integer, Integer> typeMap = new HashMap<Integer, Integer>();

    public PointTypeMapping() {
        int brown = 8;
        int tan = 36;
        int slate = 40;
        int grayTan = 39;
        int yellow = 37;
        BlockType[] types = BlockTypeIndex.getTypes();
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null) continue;
            String base = type.getName().getBase();
            if ("wood".equals(base)) {
                this.typeMap.put(i, brown);
                continue;
            }
            if ("W&D".equals(base)) {
                this.typeMap.put(i, tan);
                continue;
            }
            if ("mud-stone".equals(base)) {
                this.typeMap.put(i, slate);
                continue;
            }
            if ("shingles".equals(base)) {
                this.typeMap.put(i, grayTan);
                continue;
            }
            if ("thatch".equals(base)) {
                this.typeMap.put(i, yellow);
                continue;
            }
            if ("sand".equals(base)) {
                this.typeMap.put(i, 2);
                continue;
            }
            if ("dirt".equals(base)) {
                this.typeMap.put(i, brown);
                continue;
            }
            if ("grass".equals(base)) {
                this.typeMap.put(i, 32);
                continue;
            }
            if ("stone".equals(base)) {
                this.typeMap.put(i, 59);
                continue;
            }
            if ("leaves".equals(base)) {
                this.typeMap.put(i, 29);
                continue;
            }
            if ("leaves2".equals(base)) {
                this.typeMap.put(i, 31);
                continue;
            }
            if ("shrub".equals(base)) {
                this.typeMap.put(i, 32);
                continue;
            }
            if ("trunk".equals(base)) {
                this.typeMap.put(i, 38);
                continue;
            }
            if ("pine".equals(base)) {
                this.typeMap.put(i, 32);
                continue;
            }
            if ("cobble".equals(base)) {
                this.typeMap.put(i, 58);
                continue;
            }
            if ("bmarble".equals(base)) {
                this.typeMap.put(i, 50);
                continue;
            }
            if ("wmarble".equals(base)) {
                this.typeMap.put(i, 42);
                continue;
            }
            if ("snow".equals(base)) {
                this.typeMap.put(i, 41);
                continue;
            }
            if ("rock".equals(base)) {
                this.typeMap.put(i, 51);
                continue;
            }
            if ("rock-capped".equals(base)) {
                this.typeMap.put(i, 51);
                continue;
            }
            if ("steel".equals(base)) {
                this.typeMap.put(i, 43);
                continue;
            }
            if ("steel-black".equals(base)) {
                this.typeMap.put(i, 49);
                continue;
            }
            if ("steel-light".equals(base)) {
                this.typeMap.put(i, 42);
                continue;
            }
            if ("corn".equals(base)) {
                this.typeMap.put(i, 64);
                continue;
            }
            if ("flora".equals(base)) {
                this.typeMap.put(i, 64);
                continue;
            }
            if ("iron".equals(base)) {
                this.typeMap.put(i, 50);
                continue;
            }
            if (!"glass".equals(base)) continue;
            this.typeMap.put(i, 0);
        }
    }

    public PointIndex getPointIndex(int rawType, int type, PointIndex target) {
        int typeBits = CellGenType.getTypeBits((int)rawType);
        if (typeBits == this.TERRAIN_BITS) {
            return null;
        }
        if (target == null) {
            target = new PointIndex();
        }
        if (typeBits == this.FLORA_BITS) {
            target.set(null, (byte)0);
            return target;
        }
        Integer remap = this.typeMap.get(type);
        if (remap != null) {
            type = remap;
        }
        target.set(this.defaultType, (byte)type);
        return target;
    }
}

