/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.path;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.simsilica.mathd.Vec3i;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import mythruna.world.path.NodeVisitor;
import mythruna.world.path.NodeVisitors;
import mythruna.world.path.Path;
import mythruna.world.path.PathNode;
import mythruna.world.path.TraversalDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathGraph {
    static Logger log = LoggerFactory.getLogger(PathGraph.class);
    private Set<PathNode> nodes = new HashSet<PathNode>();
    private SetMultimap<PathNode, Path> outEdges = MultimapBuilder.hashKeys().hashSetValues().build();
    private SetMultimap<PathNode, Path> inEdges = MultimapBuilder.hashKeys().hashSetValues().build();
    private Map<Vec3i, PathNode> locationIndex = new HashMap<Vec3i, PathNode>();

    public void clear() {
        this.nodes.clear();
        this.outEdges.clear();
        this.inEdges.clear();
        this.locationIndex.clear();
    }

    public Set<PathNode> nodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public PathNode findNode(Vec3i loc) {
        return this.locationIndex.get(loc);
    }

    public boolean addNode(PathNode node) {
        if (!this.nodes.add(node)) {
            return false;
        }
        Vec3i loc = node.getLocation();
        if (this.locationIndex.containsKey(loc)) {
            this.nodes.remove(node);
            throw new IllegalArgumentException("A node already exists at location:" + loc);
        }
        this.locationIndex.put(loc, node);
        return true;
    }

    public boolean removeNode(PathNode node) {
        HashSet<Path> toRemove = new HashSet<Path>();
        for (Path p : this.outEdges.get((Object)node)) {
            toRemove.add(p);
        }
        for (Path p : this.inEdges.get((Object)node)) {
            toRemove.add(p);
        }
        for (Path p : toRemove) {
            this.removePath(p);
        }
        this.locationIndex.remove(node.getLocation());
        return this.nodes.remove(node);
    }

    public boolean isConnected(PathNode from, PathNode to) {
        return this.getPath(from, to) != null;
    }

    public Path getPath(PathNode from, PathNode to) {
        for (Path p : this.outPaths(from)) {
            if (!Objects.equals(p.getTo(), to)) continue;
            return p;
        }
        return null;
    }

    public Path connect(PathNode from, PathNode to) {
        Path existing = this.getPath(from, to);
        if (existing != null) {
            return existing;
        }
        this.addNode(from);
        this.addNode(to);
        Path path = new Path(from, to);
        this.outEdges.put((Object)from, (Object)path);
        this.inEdges.put((Object)to, (Object)path);
        return path;
    }

    public boolean removePath(Path path) {
        boolean b1 = this.outEdges.remove((Object)path.getFrom(), (Object)path);
        boolean b2 = this.inEdges.remove((Object)path.getTo(), (Object)path);
        return b1 | b2;
    }

    public Collection<Path> paths() {
        return this.outEdges.values();
    }

    public boolean containsPath(Path path) {
        if (this.outPaths(path.getFrom()).contains(path)) {
            return true;
        }
        return this.inPaths(path.getTo()).contains(path);
    }

    public Set<Path> outPaths(PathNode node) {
        return this.outEdges.get((Object)node);
    }

    public Set<Path> inPaths(PathNode node) {
        return this.inEdges.get((Object)node);
    }

    public Set<Path> incident(PathNode node) {
        Set<Path> set1 = this.outPaths(node);
        Set<Path> set2 = this.inPaths(node);
        if (set1.size() < set2.size()) {
            return Sets.union(set1, set2);
        }
        return Sets.union(set2, set1);
    }

    protected Iterator<Path> createPathIterator(PathNode node, TraversalDirection dir) {
        switch (dir) {
            case In: {
                return this.inPaths(node).iterator();
            }
            case Out: {
                return this.outPaths(node).iterator();
            }
            case InOrOut: {
                return this.incident(node).iterator();
            }
        }
        throw new UnsupportedOperationException((Object)((Object)dir) + " not supported");
    }

    public void depthFirst(PathNode start, TraversalDirection direction, NodeVisitor visitor) {
        HashSet<PathNode> visited = new HashSet<PathNode>();
        LinkedList pending = new LinkedList();
        TraversalStep current = new TraversalStep(start, null, null);
        while (current != null) {
            if (current.pathIterator == null) {
                if (!visited.add(current.node)) {
                    current = current.previous;
                    continue;
                }
                if (!visitor.preVisit(current.traversed, current.node)) {
                    current = current.previous;
                    continue;
                }
                current.pathIterator = this.createPathIterator(current.node, direction);
            }
            if (current.pathIterator.hasNext()) {
                Path nextPath = current.pathIterator.next();
                PathNode next = nextPath.adjacent(current.node);
                current = new TraversalStep(next, nextPath, current);
                continue;
            }
            visitor.postVisit(current.traversed, current.node);
            current = current.previous;
        }
    }

    public void upDepthFirst(PathNode start, Consumer<PathNode> visitor) {
        this.depthFirst(start, TraversalDirection.In, NodeVisitors.postOrder(visitor));
    }

    public void downDepthFirst(PathNode start, Consumer<PathNode> visitor) {
        this.depthFirst(start, TraversalDirection.Out, NodeVisitors.postOrder(visitor));
    }

    private class TraversalStep {
        PathNode node;
        Path traversed;
        Iterator<Path> pathIterator;
        TraversalStep previous;

        public TraversalStep(PathNode node, Path traversed, TraversalStep previous) {
            this.node = node;
            this.traversed = traversed;
            this.previous = previous;
        }
    }
}

