/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalUtils {
    static Logger log = LoggerFactory.getLogger(FractalUtils.class);

    public static double normalize(double val, double min, double max) {
        return (val -= min) / (max - min);
    }

    public static double clamp(double val, double min, double max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static double reslope(double val, double exp, double min, double max) {
        if (val <= min) {
            return val;
        }
        if (val >= max) {
            return val;
        }
        double range = max - min;
        double v = (val - min) / range;
        v = Math.pow(v, exp);
        return min + v * range;
    }

    public static double mix(double value1, double value2, double mix) {
        return value1 * (1.0 - mix) + value2 * mix;
    }

    public static double step(double edge, double val) {
        return val < edge ? 0.0 : 1.0;
    }

    public static double smoothStep(double edge1, double edge2, double val) {
        if ((val = (val - edge1) / (edge2 - edge1)) < 0.0) {
            val = 0.0;
        } else if (val > 1.0) {
            val = 1.0;
        }
        return val * val * (3.0 - 2.0 * val);
    }
}

