/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.asset.AssetInfo;
import com.jme3.scene.plugins.gltf.GltfLoader;
import com.jme3.util.LittleEndien;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class GlbLoader
extends GltfLoader {
    private static final int GLTF_MAGIC = 1179937895;
    private static final int JSON_TYPE = 1313821514;
    private static final int BIN_TYPE = 5130562;
    private ArrayList<byte[]> data = new ArrayList();

    @Override
    public Object load(AssetInfo assetInfo) throws IOException {
        this.data.clear();
        LittleEndien stream = new LittleEndien((InputStream)new DataInputStream(assetInfo.openStream()));
        int magic = stream.readInt();
        int version = stream.readInt();
        int length = stream.readInt();
        byte[] json = null;
        length -= 12;
        while (length > 0) {
            int chunkLength = stream.readInt();
            int chunkType = stream.readInt();
            if (chunkType == 1313821514) {
                json = new byte[chunkLength];
                stream.read(json);
            } else {
                byte[] bin = new byte[chunkLength];
                stream.read(bin);
                this.data.add(bin);
            }
            length -= chunkLength + 8;
        }
        return this.loadFromStream(assetInfo, new ByteArrayInputStream(json));
    }

    @Override
    protected byte[] getBytes(int bufferIndex, String uri, Integer bufferLength) throws IOException {
        return this.data.get(bufferIndex);
    }
}

