/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.jme3.util.SafeArrayList;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.view.FarTerrainState;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.net.ConnectionState;
import mythruna.client.ui.MapComponent;
import mythruna.client.ui.MapLayer;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.view.AvatarState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MapViewState.class);
    public static final String SUBMENU = "Map";
    public static final String GROUP_MAP = "Map";
    public static final FunctionId FUNC_ZOOM = new FunctionId("Map", "Map Zoom");
    public static final double MIN_RADIUS = 512.0;
    public static final double MAX_RADIUS = 7168.0;
    private EntityData ed;
    private Container mapContainer;
    private Container left;
    private Container right;
    private Label map;
    private MapComponent mapComponentNear;
    private MapComponent mapComponentFar;
    private Node playerMarker;
    private VersionedReference<Vec3d> posRef;
    private VersionedReference<Quatd> orientRef;
    private double minRadius = 512.0;
    private double maxRadius = 7168.0;
    private double radiusUp = 1.1111;
    private double radiusDown = 0.9;
    private VersionedHolder<Double> worldRadius = new VersionedHolder((Object)this.maxRadius);
    private SafeArrayList<MapLayer> layers = new SafeArrayList(MapLayer.class);

    public MapViewState() {
        this.setEnabled(false);
    }

    public Container getMap() {
        return this.mapContainer;
    }

    public void addLayer(MapLayer layer) {
        this.layers.add((Object)layer);
        if (this.map != null && layer instanceof GuiComponent) {
            ((GuiControl)this.map.getControl(GuiControl.class)).addComponent((GuiComponent)layer);
        }
    }

    public void addLeftPanel(Panel panel) {
        this.left.addChild((Node)panel, new Object[0]);
    }

    public void removeLeftPanel(Panel panel) {
        this.left.removeChild((Node)panel);
    }

    public void addRightPanel(Panel panel) {
        this.right.addChild((Node)panel, new Object[0]);
    }

    public void removeRightPanel(Panel panel) {
        this.right.removeChild((Node)panel);
    }

    protected void initialize(Application app) {
        float sizeDelta;
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Map", (AppState)this);
        this.mapContainer = new Container((GuiLayout)new BorderLayout(), new ElementId("popup"));
        this.left = (Container)this.mapContainer.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)), new Object[]{BorderLayout.Position.West});
        this.right = (Container)this.mapContainer.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)), new Object[]{BorderLayout.Position.East});
        Texture terrainFar = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getFarTerrainTexture();
        Texture fluidFar = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getFarFluidTexture();
        Texture terrainNear = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getNearTerrainTexture();
        Texture fluidNear = ((FarTerrainState)this.getState(FarTerrainState.class, true)).getNearFluidTexture();
        this.map = (Label)this.mapContainer.addChild((Node)new Label(""), new Object[]{BorderLayout.Position.Center});
        Texture paper = app.getAssetManager().loadTexture("Textures/sand.jpg");
        this.map.setBackground((GuiComponent)new QuadBackgroundComponent(paper));
        this.mapComponentNear = new MapComponent(app.getAssetManager(), terrainNear, fluidNear, 0.125);
        this.mapComponentFar = new MapComponent(app.getAssetManager(), terrainFar, fluidFar, 0.0625);
        this.layers.add(0, (Object)this.mapComponentFar);
        this.layers.add(1, (Object)this.mapComponentNear);
        for (MapLayer layer : this.layers) {
            if (!(layer instanceof GuiComponent)) continue;
            ((GuiControl)this.map.getControl(GuiControl.class)).addComponent((GuiComponent)layer);
        }
        String name = ((GameSessionState)this.getState(GameSessionState.class)).getWorldName();
        this.left.addChild((Node)new Label("TBD"), new Object[0]);
        this.right.addChild((Node)new Label("World:" + name), new Object[0]);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.orientRef = ((AvatarState)this.getState(AvatarState.class)).createOrientationReference();
        this.playerMarker = new Node();
        Quad quad = new Quad(64.0f, 64.0f);
        Geometry geom = new Geometry("marker", (Mesh)quad);
        geom.setLocalScale(0.4f);
        Texture arrow = app.getAssetManager().loadTexture("Interface/arrow-right.png");
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(arrow, false).getMaterial());
        geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.getMaterial().setColor("Color", new ColorRGBA(0.75f, 0.1f, 0.1f, 0.75f));
        geom.center();
        this.playerMarker.attachChild((Spatial)geom);
        this.playerMarker.setLocalTranslation(100.0f, -100.0f, 10.0f);
        this.map.attachChild((Spatial)this.playerMarker);
        Vector2f guiSize = ((GuiState)this.getState(GuiState.class)).getGuiSize();
        float scale = 1.0f;
        this.mapContainer.setLocalScale(scale);
        float mapSize = guiSize.y * 0.9f / scale;
        this.map.setPreferredSize(new Vector3f(mapSize, mapSize, 1.0f));
        float w = guiSize.x;
        float h = guiSize.y;
        float maxWidth = guiSize.x * 0.8f;
        float maxHeight = guiSize.y * 0.9f;
        float minWidth = guiSize.x * 0.7f;
        float minHeight = guiSize.y * 0.9f;
        Vector3f pref = this.mapContainer.getPreferredSize();
        pref = pref.mult(scale);
        float xDelta = 0.0f;
        float yDelta = 0.0f;
        if (pref.x > maxWidth) {
            xDelta = pref.x - maxWidth;
        }
        if (pref.y > maxHeight) {
            yDelta = pref.y - maxHeight;
        }
        if ((sizeDelta = Math.max(xDelta, yDelta)) > 0.0f) {
            this.map.setPreferredSize(new Vector3f(mapSize -= sizeDelta / scale, mapSize, 1.0f));
        }
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(FUNC_ZOOM, (Object)this, "changeZoom", true);
        inputMapper.map(FUNC_ZOOM, com.simsilica.lemur.input.Axis.MOUSE_WHEEL, new Object[0]);
    }

    protected void cleanup(Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(FUNC_ZOOM, (Object)this, "changeZoom");
    }

    protected void onEnable() {
        log.info("onEnable()");
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.mapContainer);
        this.mapContainer.move(0.0f, 0.0f, 10.0f);
        ((GuiState)this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.mapContainer);
        GuiGlobals.getInstance().getInputMapper().activateGroup("Map");
        this.resetZoom();
        if (this.posRef.update()) {
            this.updateWorldCenter((Vec3d)this.posRef.get());
        }
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.mapContainer.removeFromParent();
        GuiGlobals.getInstance().getInputMapper().deactivateGroup("Map");
    }

    public VersionedReference<Double> getWorldRadiusRef() {
        return this.worldRadius.createReference();
    }

    public void changeZoom(InputState value) {
        double radius = (Double)this.worldRadius.getObject();
        switch (value) {
            case Positive: {
                radius *= this.radiusDown;
                break;
            }
            case Negative: {
                radius *= this.radiusUp;
                break;
            }
            default: {
                return;
            }
        }
        if (radius > this.maxRadius) {
            radius = this.maxRadius;
        } else if (radius < this.minRadius) {
            radius = this.minRadius;
        }
        log.info("Zoom:" + value + "  worldRadius:" + radius);
        if (this.worldRadius.updateObject((Object)radius)) {
            this.resetZoom();
        }
    }

    protected void resetZoom() {
        double radius = (Double)this.worldRadius.getObject();
        for (MapLayer layer : (MapLayer[])this.layers.getArray()) {
            layer.setWorldRadius(radius);
        }
        if (radius <= 3072.0) {
            this.mapComponentNear.setAlpha(1.0f);
            this.mapComponentFar.setAlpha(0.0f);
        } else {
            this.mapComponentNear.setAlpha(0.0f);
            this.mapComponentFar.setAlpha(1.0f);
        }
    }

    public void update(float tpf) {
        if (this.orientRef.update()) {
            this.updatePlayerMarker();
        }
        if (this.posRef.update()) {
            this.updateWorldCenter((Vec3d)this.posRef.get());
        }
    }

    protected void updateWorldCenter(Vec3d pos) {
        for (MapLayer layer : (MapLayer[])this.layers.getArray()) {
            layer.setWorldCenter(pos);
        }
    }

    protected void updatePlayerMarker() {
        Vector3f size = this.map.getSize();
        if (size.y > 0.0f) {
            float center = size.y * 0.5f;
            this.playerMarker.setLocalTranslation(center, -center, 20.0f);
        }
        Quatd orient = (Quatd)this.orientRef.get();
        Vec3d dir = orient.mult(Vec3d.UNIT_Z);
        double rads = Math.atan2(-dir.z, dir.x);
        this.playerMarker.setLocalRotation(new Quaternion().fromAngles(0.0f, 0.0f, (float)rads));
    }
}

