/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.jme.AttachmentControl;
import com.simsilica.crig.jme.SpatialRigType;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.trans.TransitionBuffer;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.geom.ColliderlessMesh;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.DynArray;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.transaction.CellEdit;
import com.simsilica.state.DebugHudState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.Model;
import mythruna.client.view.ModelInfo;
import mythruna.client.view.ModelViewListener;
import mythruna.client.view.PickedObject;
import mythruna.client.view.SpatialFactory;
import mythruna.client.view.WorldViewState;
import mythruna.es.ObjectName;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ModelViewState.class);
    private static final long VIS_DELAY = 100000000L;
    private static final ColorRGBA NAME_LABEL_COLOR = ColorRGBA.Cyan;
    private static final ColorRGBA NAME_SHADOW_COLOR = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    private WorldViewState worldState;
    private EntityData ed;
    private VersionedReference<Vec3d> posRef;
    private JobState workers;
    private JobState lowWorkers;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private ShapeFactoryRegistry<MBlockShape> shapeFactory;
    private SpatialFactory modelFactory;
    private GeometryFactory geomFactory;
    private ObjectRootNode objectRoot;
    private WorldListener worldListener = new WorldListener();
    private Set<Vec3i> lightingChanges = new HashSet<Vec3i>();
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private TimeSource timeSource;
    private MobContainer mobs;
    private ModelContainer models;
    private LargeModelContainer largeModels;
    private NameContainer names;
    private DynArray<ModelImpl> standIns = new DynArray(ModelImpl.class);
    private LinkedList<MarkVisible> markerQueue = new LinkedList();
    private Vec3i modelCenter = new Vec3i();
    private Vec3i largeModelCenter = new Vec3i();
    private int modelGridRadius = 1;
    private int nameGridRadius = 1;
    private int lobGridRadius = 1;
    private ComponentFilter[][] gridFilters;
    private ComponentFilter[][] largeGridFilters;
    private Map<EntityId, ModelImpl> modelIndex = new HashMap<EntityId, ModelImpl>();
    private List<ModelViewListener> listeners = new CopyOnWriteArrayList<ModelViewListener>();
    private VersionedHolder<String> mobCount;
    private VersionedHolder<String> modelCount;
    private VersionedHolder<String> largeModelCount;
    private VersionedHolder<String> spatialCount;
    private Set<EntityId> testEntities = new HashSet<EntityId>(Arrays.asList(new EntityId[0]));
    private static final int UNSET_LIGHTING = LightUtils.toLight((int)0, (int)15, (int)0, (int)0) | Integer.MIN_VALUE;

    public Model getStandIn(EntityId entityId, boolean create) {
        ModelImpl model = this.modelIndex.get(entityId);
        if (model == null && create) {
            model = this.getModel(entityId, create);
            model.markVisible();
            this.standIns.add((Object)model);
        }
        return model;
    }

    public Model releaseStandIn(EntityId entityId) {
        ModelImpl model = this.releaseModel(entityId);
        if (model != null && model.useCount <= 0) {
            this.standIns.remove((Object)model);
        }
        return model;
    }

    public Spatial getModel(EntityId entityId) {
        ModelImpl model = this.modelIndex.get(entityId);
        return model == null ? null : ((ModelImpl)model).info.spatial;
    }

    public void createSpatial(final EntityId entityId, final Consumer<Spatial> callback) {
        Spatial model = this.getModel(entityId);
        if (model != null) {
            callback.accept(model);
            return;
        }
        this.workers.execute(new Job(){
            private ModelInfo info;

            public void runOnWorker() {
                ShapeInfo shape = (ShapeInfo)ModelViewState.this.ed.getComponent(entityId, ShapeInfo.class);
                if (shape == null) {
                    return;
                }
                this.info = new ModelInfo(entityId);
                this.info.updateShapeInfo(shape, ModelViewState.this.ed);
                String shapeName = this.info.shapeInfo.getShapeName(ModelViewState.this.ed);
                Mass mass = null;
                this.info.shape = (MBlockShape)ModelViewState.this.shapeFactory.createShape(shapeName, shape.getScale(), mass);
                this.info.spatial = ModelViewState.this.createModel(this.info);
                ModelViewState.this.fireModelCreated(this.info);
            }

            public double runOnUpdate() {
                callback.accept(this.info.spatial);
                return 0.0;
            }
        }, -1);
    }

    public Vec3d getModelPosition(EntityId entityId) {
        ModelImpl model = this.modelIndex.get(entityId);
        return model == null ? null : model.worldPos;
    }

    public Quatd getModelRotation(EntityId entityId) {
        ModelImpl model = this.modelIndex.get(entityId);
        return model == null ? null : model.worldRot;
    }

    protected String getObjectName(EntityId entityId, String defaultValue) {
        ObjectName on = (ObjectName)this.ed.getComponent(entityId, ObjectName.class);
        if (on != null) {
            return on.getName(this.ed);
        }
        Name name = (Name)this.ed.getComponent(entityId, Name.class);
        if (name != null) {
            return name.getName();
        }
        return defaultValue;
    }

    protected Spatial findPickedSpatial(Spatial spatial) {
        Long oid = (Long)spatial.getUserData("oid");
        if (oid != null) {
            return spatial;
        }
        if (spatial.getParent() != null) {
            return this.findPickedSpatial((Spatial)spatial.getParent());
        }
        return null;
    }

    public PickedObject pickObject(EntityId skip, Vec3d dir, double limit) {
        return this.pickObject(skip, this.centerWorld.toVec3d(), limit);
    }

    public PickedObject pickObject(EntityId skip, Vec3d world, Vec3d dir, double limit) {
        log.info("pickObject(" + skip + ", " + world + ", " + dir + ", " + limit + ")");
        log.info("centerCell:" + this.centerCell + "  centerWorld:" + this.centerWorld + "  modelCenter:" + this.modelCenter);
        Vec3d start = world.subtract(this.centerWorld.toVec3d());
        log.info("start:" + start);
        Ray ray = new Ray(start.toVector3f(), dir.toVector3f());
        ray.setLimit((float)limit);
        CollisionResults crs = new CollisionResults();
        int count = this.objectRoot.pick((Collidable)ray, crs);
        for (CollisionResult cr : crs) {
            Long oid;
            EntityId entityId;
            log.info("pickObject() cr:" + cr);
            Spatial picked = this.findPickedSpatial((Spatial)cr.getGeometry());
            log.info("pickObject()  picked:" + picked);
            if (picked == null || Objects.equals(skip, entityId = new EntityId((oid = (Long)picked.getUserData("oid")).longValue()))) continue;
            Vector3f cp = cr.getContactPoint();
            log.info("pickObject() cp:" + cp + "  id:" + entityId);
            Vec3d pos = new Vec3d(cp).add(this.centerWorld);
            Vec3d normal = new Vec3d(cr.getContactNormal());
            double dist = cr.getDistance();
            return new PickedObject(entityId, pos, normal, dist);
        }
        return null;
    }

    public void addModelViewListener(ModelViewListener l) {
        this.listeners.add(l);
    }

    public void removeModelViewListener(ModelViewListener l) {
        this.listeners.remove(l);
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected Node getObjectRoot() {
        return this.objectRoot;
    }

    protected void initialize(Application app) {
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
        this.modelFactory = new SpatialFactory(this.geomFactory, ((GameSessionState)this.getState(GameSessionState.class)).getCarveIncludes());
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.timeSource = ((GameSessionState)this.getState(GameSessionState.class)).getTimeSource();
        this.objectRoot = new ObjectRootNode("objectRoot");
        this.worldState = (WorldViewState)this.getState(WorldViewState.class, true);
        this.worldState.addCellChangeListener(this.worldListener);
        this.workers = (JobState)this.getState("priorityWorkers", JobState.class, true);
        this.lowWorkers = (JobState)this.getState("backgroundWorkers", JobState.class, true);
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            this.mobCount = debug.createDebugValue("Mobs", DebugHudState.Location.Right);
            this.modelCount = debug.createDebugValue("Statics", DebugHudState.Location.Right);
            this.largeModelCount = debug.createDebugValue("Lobs", DebugHudState.Location.Right);
            this.spatialCount = debug.createDebugValue("Spatials", DebugHudState.Location.Right);
        }
        this.shapeFactory = ((GameSessionState)this.getState(GameSessionState.class)).getShapeFactory();
        this.mobs = new MobContainer(this.ed);
        this.models = new ModelContainer(this.ed);
        this.names = new NameContainer(this.ed);
        this.largeModels = new LargeModelContainer(this.ed);
        this.resetModelFilter();
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
    }

    protected void cleanup(Application app) {
        this.worldState.removeCellChangeListener(this.worldListener);
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            debug.removeDebugValue("Mobs");
            debug.removeDebugValue("Statics");
            debug.removeDebugValue("Spatials");
        }
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.objectRoot);
        this.mobs.start();
        this.models.start();
        this.names.start();
        this.largeModels.start();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.mobs.update();
        this.models.update();
        this.names.update();
        this.largeModels.update();
        long time = this.timeSource.getTime();
        for (Mob mob : this.mobs.getArray()) {
            mob.update(time);
        }
        while (!this.markerQueue.isEmpty()) {
            MarkVisible marker = this.markerQueue.peek();
            if (marker.visibleTime > time) break;
            marker = this.markerQueue.poll();
            marker.update();
        }
        if (!this.lightingChanges.isEmpty()) {
            for (ModelImpl model : this.models.getArray()) {
                model.updateLighting(this.lightingChanges);
            }
            this.lightingChanges.clear();
        }
        if (this.mobCount != null) {
            this.mobCount.setObject((Object)String.valueOf(this.mobs.size()));
            this.modelCount.setObject((Object)String.valueOf(this.models.size()));
            this.largeModelCount.setObject((Object)String.valueOf(this.largeModels.size()));
            this.spatialCount.setObject((Object)String.valueOf(this.modelIndex.size()));
        }
    }

    protected void onDisable() {
        log.info("shutting down");
        this.objectRoot.removeFromParent();
        this.mobs.stop();
        this.models.stop();
        this.names.stop();
        this.largeModels.stop();
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        log.info("centerWorld:" + this.centerWorld);
        this.resetRelativeCoordinates();
        if (this.modelCenter.x != this.centerCell.x || this.modelCenter.z != this.centerCell.z) {
            this.modelCenter.x = this.centerCell.x;
            this.modelCenter.z = this.centerCell.z;
            this.resetModelFilter();
            this.resetNameFilter();
        }
        Vec3i largeCenter = GameConstants.LARGE_OBJECT_GRID.worldToCell(this.centerWorld.toVec3d());
        if (this.largeModelCenter.x != largeCenter.x || this.largeModelCenter.z != largeCenter.z) {
            this.largeModelCenter.x = largeCenter.x;
            this.largeModelCenter.z = largeCenter.z;
            this.resetLargeModelFilter();
        }
    }

    protected void resetRelativeCoordinates() {
        for (ModelImpl m : this.models.getArray()) {
            m.updateRelativePosition();
        }
        for (ModelImpl m : this.largeModels.getArray()) {
            m.updateRelativePosition();
        }
        for (ModelImpl m : (ModelImpl[])this.standIns.getArray()) {
            m.updateRelativePosition();
        }
    }

    protected void resetModelFilter() {
        int size = this.modelGridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.modelCenter.x - this.modelGridRadius;
        int zOffset = this.modelCenter.z - this.modelGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.models.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
    }

    protected void resetNameFilter() {
        int size = this.nameGridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.modelCenter.x - this.nameGridRadius;
        int zOffset = this.modelCenter.z - this.nameGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.models.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
    }

    protected void resetLargeModelFilter() {
        int size = this.lobGridRadius * 2 + 1;
        this.largeGridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.largeModelCenter.x - this.lobGridRadius;
        int zOffset = this.largeModelCenter.z - this.lobGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = GameConstants.LARGE_OBJECT_GRID.cellToId(xOffset + x, 0, zOffset + z);
                this.largeGridFilters[x][z] = filter = Filters.fieldEquals(LargeGridCell.class, (String)"cellId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.largeModels.setFilter(Filters.or(LargeGridCell.class, (ComponentFilter[])filters));
    }

    protected void fireModelCreated(ModelInfo info) {
        for (ModelViewListener l : this.listeners) {
            l.modelCreated(info);
        }
    }

    protected void fireModelUpdated(ModelInfo info) {
        for (ModelViewListener l : this.listeners) {
            l.modelCreated(info);
        }
    }

    protected void fireModelReleased(ModelInfo info) {
        for (ModelViewListener l : this.listeners) {
            l.modelReleased(info);
        }
    }

    protected Spatial createModel(ModelInfo info) {
        Spatial result;
        if (info.shape instanceof RigShape) {
            String assetName = info.shapeName.getFullName();
            assetName = assetName + ".j3o";
            result = this.getApplication().getAssetManager().loadModel(assetName);
            result.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
            result.setUserData("oid", (Object)info.entityId.getId());
            info.spatial = result;
            ((SpatialRigType)((RigShape)info.shape).getRigType()).configureSpatial(result);
        } else {
            result = this.modelFactory.createModel(info);
        }
        result.setUserData("objectName", (Object)this.getObjectName(info.entityId, info.shapeName.toCompositeString() + ":" + info.entityId));
        return result;
    }

    protected ModelImpl getModel(EntityId entityId, boolean create) {
        ModelImpl result;
        if (log.isTraceEnabled()) {
            log.trace("getModel(" + entityId + ")");
        }
        if ((result = this.modelIndex.get(entityId)) == null && create) {
            result = new ModelImpl(entityId);
            this.modelIndex.put(entityId, result);
        }
        result.acquire();
        return result;
    }

    protected ModelImpl releaseModel(EntityId entityId) {
        ModelImpl result;
        if (log.isTraceEnabled()) {
            log.trace("releaseModel(" + entityId + ")");
        }
        if ((result = this.modelIndex.get(entityId)) == null) {
            log.warn("Releasing model that has not been acquired:" + entityId);
        } else if (result.release()) {
            this.modelIndex.remove(entityId);
            this.fireModelReleased(result.info);
        }
        return result;
    }

    public static float getOffset(BoundingVolume bv) {
        if (bv instanceof BoundingBox) {
            return ((BoundingBox)bv).getYExtent();
        }
        if (bv instanceof BoundingSphere) {
            return ((BoundingSphere)bv).getRadius();
        }
        return 0.0f;
    }

    protected void lightingChanged(Vec3i world, CellEdit[] changes) {
        for (CellEdit edit : changes) {
            this.lightingChanges.add(world.add(edit.getCellLocation()));
        }
    }

    static /* synthetic */ int access$1000() {
        return UNSET_LIGHTING;
    }

    private class WorldListener
    implements CellChangeListener {
        private WorldListener() {
        }

        public void cellChanged(CellChangeEvent event) {
            CellEdit[] changes = event.getLightChanges();
            if (changes == null) {
                return;
            }
            ModelViewState.this.getApplication().enqueue(() -> ModelViewState.this.lightingChanged(event.getLeafWorld(), changes));
        }
    }

    private class ModelImpl
    implements Model,
    Job {
        private ModelInfo info;
        private volatile Spatial backgroundSpatial;
        private volatile boolean addOnsUpdated;
        private ShapeName lastShapeName;
        private int useCount;
        private boolean dynamic;
        private boolean largeObject;
        private SpawnPosition pos;
        private int visibleCount;
        private Vec3d worldPos;
        private Quatd worldRot;
        private Vec3i worldCell;
        private int lighting = ModelViewState.access$1000();
        private Node nameNode;
        private String name;
        private Label nameLabel;
        private AttachmentPoint head;
        private AttachmentPoint centerOfMass;
        private ModelImpl parentModel;
        private ColorRGBA localLighting = new ColorRGBA();
        private LightingUpdater lightingUpdater = new LightingUpdater(this);

        public ModelImpl(EntityId entityId) {
            this.info = new ModelInfo(entityId);
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: new ModelImpl(" + this.info.entityId + ")");
            }
        }

        protected void setParent(ModelImpl parent) {
            log.info("setParent(" + parent + ")");
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " setParent(" + parent + ")");
            }
            this.parentModel = parent;
            if (this.parentModel != null) {
                this.setLighting(this.parentModel.lighting);
            } else {
                this.checkLighting();
            }
        }

        public void setLargeObject(boolean flag) {
            this.largeObject = flag;
        }

        @Override
        public EntityId getEntityId() {
            return this.info.entityId;
        }

        public void setName(String name) {
            if (Objects.equals(this.name, name)) {
                return;
            }
            if (this.nameNode == null && name == null) {
                return;
            }
            if (name == null) {
                this.nameNode.removeFromParent();
                this.nameNode = null;
                return;
            }
            float nameScale = 0.01f;
            this.name = name;
            if (this.nameNode == null) {
                this.nameLabel = new Label(name, new ElementId("object.label"));
                this.nameLabel.setLocalScale(nameScale);
                this.nameLabel.setColor(NAME_LABEL_COLOR);
                this.nameLabel.setShadowColor(NAME_SHADOW_COLOR);
                this.nameLabel.setQueueBucket(RenderQueue.Bucket.Translucent);
                this.nameNode = new Node("name:" + this.info.entityId);
                this.nameNode.attachChild((Spatial)this.nameLabel);
                this.nameNode.addControl((Control)new BillboardControl());
                ModelViewState.this.getObjectRoot().attachChild((Spatial)this.nameNode);
            } else {
                this.nameLabel.setText(name);
            }
            Vector3f pref = this.nameLabel.getPreferredSize();
            this.nameLabel.setLocalTranslation(-pref.x * 0.5f * nameScale, pref.y * nameScale, 0.0f);
            this.updateLabelLocation();
        }

        public void acquire() {
            ++this.useCount;
        }

        public boolean release() {
            --this.useCount;
            if (this.useCount <= 0) {
                if (this.info.spatial != null) {
                    this.info.spatial.removeFromParent();
                }
                return true;
            }
            return false;
        }

        @Override
        public void setShape(ShapeInfo shapeInfo) {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " setShape(" + shapeInfo + ")");
            }
            if (!this.info.updateShapeInfo(shapeInfo, ModelViewState.this.ed)) {
                return;
            }
            ModelViewState.this.workers.execute((Job)this, -1);
            if (log.isTraceEnabled()) {
                if (this.info.shapeInfo != null) {
                    log.trace(this.info.entityId + ".setShape(" + this.info.shapeName + ")");
                } else {
                    log.trace(this.info.entityId + ".setShape(" + null + ")");
                }
            }
        }

        public void runOnWorker() {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " runOnWorker()");
            }
            if (this.backgroundSpatial != null && this.lastShapeName != null && this.lastShapeName.getFullName().equals(this.info.shapeName.getFullName())) {
                if (this.info.shapeName.getAddOns().equals(this.lastShapeName.getAddOns())) {
                    return;
                }
                this.addOnsUpdated = true;
                this.lastShapeName = this.info.shapeName;
                return;
            }
            this.lastShapeName = this.info.shapeName;
            Object mass = null;
            this.backgroundSpatial = null;
            String s = this.info.shapeInfo.getShapeName(ModelViewState.this.ed);
            this.info.shape = (MBlockShape)ModelViewState.this.shapeFactory.createShape(s, this.info.shapeInfo.getScale(), this.info.mass);
            this.backgroundSpatial = ModelViewState.this.createModel(this.info);
            Spatial current = this.info.spatial;
            this.info.spatial = this.backgroundSpatial;
            if (current == null) {
                ModelViewState.this.fireModelCreated(this.info);
            } else {
                ModelViewState.this.fireModelUpdated(this.info);
            }
            this.info.spatial = current;
        }

        public double runOnUpdate() {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " runOnUpdate() pos:" + this.pos);
            }
            if (this.addOnsUpdated) {
                if (this.info.spatial != this.backgroundSpatial) {
                    log.error("Skipping full update but background and foreground spatials don't match:" + this.info.entityId);
                }
                ModelViewState.this.fireModelUpdated(this.info);
                this.addOnsUpdated = false;
                return 0.1;
            }
            if (this.info.spatial != null) {
                this.head = null;
                this.centerOfMass = null;
                this.info.spatial.removeFromParent();
            }
            this.info.spatial = this.backgroundSpatial;
            if (this.info.spatial != null) {
                ModelViewState.this.getObjectRoot().attachChild(this.info.spatial);
                AttachmentControl attachments = (AttachmentControl)this.info.spatial.getControl(AttachmentControl.class);
                if (attachments != null) {
                    this.head = attachments.getAttachment("head.top");
                    this.centerOfMass = attachments.getAttachment("com");
                }
                if (this.pos != null) {
                    this.setPosition(this.pos);
                } else {
                    this.updateRelativePosition();
                }
                this.resetVisibility();
                this.rewireLocalLighting();
            }
            return 0.1;
        }

        @Override
        public void setPosition(SpawnPosition pos) {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " setPosition(" + pos + ")");
            }
            this.pos = pos;
            this.updateRelativePosition();
            this.setWorldPosition(pos.getLocation(), pos.getOrientation());
        }

        public void setWorldPosition(Vec3d worldPos, Quatd worldRot) {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " setWorldPosition(" + worldPos + ") spatial:" + this.info.spatial);
            }
            this.worldPos = worldPos;
            this.worldRot = worldRot;
            if (this.parentModel != null) {
                this.setLighting(this.parentModel.lighting);
            } else if (this.info.spatial != null) {
                Vec3i loc;
                if (this.centerOfMass != null) {
                    this.centerOfMass.update();
                    Vec3d com = this.centerOfMass.getTranslation();
                    com = com.add(ModelViewState.this.centerWorld.toVec3d());
                    loc = com.floor();
                } else {
                    Vector3f center = this.info.spatial.getWorldBound().getCenter();
                    loc = new Vec3i(((ModelViewState)ModelViewState.this).centerWorld.x + (int)Math.floor(center.x), ((ModelViewState)ModelViewState.this).centerWorld.y + (int)Math.floor(center.y), ((ModelViewState)ModelViewState.this).centerWorld.z + (int)Math.floor(center.z));
                }
                if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                    log.info("TESTENTITY: " + this.info.entityId + " loc:" + loc + " worldCell:" + this.worldCell);
                }
                if (!Objects.equals(loc, this.worldCell)) {
                    this.worldCell = loc;
                    this.checkLighting();
                }
            }
        }

        public void updateRelativePosition() {
            if (!this.dynamic) {
                if (this.pos == null) {
                    log.info("dynamic=false, pos=null, useCount=" + this.useCount);
                } else if (this.info.spatial != null) {
                    Vec3d loc = this.pos.getLocation();
                    loc = loc.subtract(ModelViewState.this.centerWorld.toVec3d());
                    this.info.spatial.setLocalTranslation(loc.toVector3f());
                    this.info.spatial.setLocalRotation(this.pos.getOrientation().toQuaternion());
                }
                this.updateLabelLocation();
            }
        }

        protected void updateLabelLocation() {
            if (this.nameLabel == null || this.worldPos == null) {
                return;
            }
            if (this.info.spatial == null) {
                Vector3f pos = this.worldPos.subtract(ModelViewState.this.centerWorld).toVector3f();
                this.nameNode.setLocalTranslation(pos);
            } else if (this.nameNode != null) {
                if (this.head != null) {
                    this.head.update();
                    this.nameNode.setLocalTranslation(this.head.getTranslation().toVector3f());
                } else {
                    BoundingVolume bounds = this.info.spatial.getWorldBound();
                    float yOffset = ModelViewState.getOffset(bounds);
                    if (yOffset > 2.0f) {
                        yOffset = -1.5f;
                    }
                    this.nameNode.setLocalTranslation(bounds.getCenter());
                    this.nameNode.move(0.0f, yOffset, 0.0f);
                }
            }
        }

        public void setDynamic(boolean dynamic) {
            if (this.dynamic == dynamic) {
                return;
            }
            this.dynamic = dynamic;
            if (!dynamic) {
                this.updateRelativePosition();
            }
        }

        protected void markVisible() {
            ++this.visibleCount;
            this.resetVisibility();
        }

        protected void markInvisible() {
            --this.visibleCount;
            this.resetVisibility();
        }

        @Override
        public void setVisible(boolean f) {
            if (f == this.isVisible()) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("ModelImpl.setVisible(" + f + ")  existing:" + f);
            }
            if (f) {
                this.markVisible();
            } else {
                this.markInvisible();
            }
            this.resetVisibility();
        }

        public boolean isVisible() {
            return this.visibleCount > 0;
        }

        protected void resetVisibility() {
            if (log.isTraceEnabled()) {
                log.trace("resetVisibility():" + this.visibleCount);
            }
            if (this.info.spatial == null) {
                if (log.isTraceEnabled()) {
                    log.trace("spatial is null");
                }
                return;
            }
            if (this.visibleCount > 0) {
                if (log.isTraceEnabled()) {
                    log.trace("visible:" + this.info.entityId);
                }
                this.info.spatial.setCullHint(Spatial.CullHint.Inherit);
                if (this.nameNode != null) {
                    this.nameNode.setCullHint(Spatial.CullHint.Inherit);
                }
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("invisible:" + this.info.entityId);
                }
                this.info.spatial.setCullHint(Spatial.CullHint.Always);
                if (this.nameNode != null) {
                    this.nameNode.setCullHint(Spatial.CullHint.Always);
                }
            }
        }

        public void updateLighting(Set<Vec3i> changes) {
            if (changes.contains(this.worldCell)) {
                if (log.isTraceEnabled()) {
                    log.trace("updateLighting for:" + this.info.entityId);
                }
                int light = ModelViewState.this.worldState.getWorldLight(this.worldCell.x, this.worldCell.y, this.worldCell.z);
                this.setLighting(light);
            }
        }

        protected void checkLighting() {
            Vec3d avatarPos = (Vec3d)ModelViewState.this.posRef.get();
            if (this.worldCell == null) {
                return;
            }
            if (!this.largeObject && (Math.abs((double)this.worldCell.x - avatarPos.x) > 512.0 || Math.abs((double)this.worldCell.z - avatarPos.z) > 512.0)) {
                log.warn("Skipping checkLighting() for:" + this.info.entityId + " because it might be an unattached child object cell:" + this.worldCell + " avatarPos:" + avatarPos);
                return;
            }
            this.lightingUpdater.update(this.worldCell);
        }

        protected void setLighting(int lighting) {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " setLighting(" + Integer.toHexString(lighting) + ")");
            }
            if (this.lighting == lighting) {
                return;
            }
            this.lighting = lighting;
            final int red = LightUtils.red((int)lighting);
            final int green = LightUtils.green((int)lighting);
            final int blue = LightUtils.blue((int)lighting);
            final int sun = LightUtils.sun((int)lighting);
            this.localLighting.set((float)red / 15.0f, (float)green / 15.0f, (float)blue / 15.0f, (float)sun / 15.0f);
            this.info.spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

                public void visit(Geometry geom) {
                    Mesh mesh = geom.getMesh();
                    if (mesh instanceof ColliderlessMesh) {
                        ModelImpl.this.relight(mesh, red, green, blue, sun);
                    }
                }
            });
        }

        protected void rewireLocalLighting() {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " rewireLocalLighting()  lighting:" + Integer.toHexString(this.lighting));
            }
            this.info.spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

                public void visit(Geometry geom) {
                    Material mat = geom.getMaterial();
                    if (mat.getMaterialDef().getMaterialParam("LocalLighting") != null) {
                        mat.setColor("LocalLighting", ModelImpl.this.localLighting);
                    }
                }
            });
        }

        protected void relight(Mesh mesh, int red, int green, int blue, int sun) {
            if (ModelViewState.this.testEntities.contains(this.info.entityId)) {
                log.info("TESTENTITY: " + this.info.entityId + " relight()  lighting:" + Integer.toHexString(this.lighting));
            }
            VertexBuffer buff = mesh.getBuffer(VertexBuffer.Type.Color);
            FloatBuffer cb = (FloatBuffer)buff.getData();
            cb.rewind();
            int size = mesh.getVertexCount();
            for (int i = 0; i < size; ++i) {
                cb.put((float)red / 15.0f);
                cb.put((float)green / 15.0f);
                cb.put((float)blue / 15.0f);
                cb.put((float)sun / 15.0f);
            }
            buff.updateData((Buffer)cb);
        }
    }

    private class ObjectRootNode
    extends Node {
        public ObjectRootNode(String name) {
            super(name);
        }

        public int collideWith(Collidable other, CollisionResults results) {
            return 0;
        }

        public int pick(Collidable other, CollisionResults results) {
            return super.collideWith(other, results);
        }
    }

    private class MobContainer
    extends EntityContainer<Mob> {
        public MobContainer(EntityData ed) {
            super(ed, new Class[]{BodyPosition.class, ShapeInfo.class});
        }

        public Mob[] getArray() {
            return (Mob[])super.getArray();
        }

        protected Mob addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add mob for:" + e.getId());
            }
            Mob object = new Mob(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(Mob object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((BodyPosition)e.get(BodyPosition.class));
        }

        protected void removeObject(Mob object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove mob for:" + e.getId());
            }
            object.release();
        }
    }

    private class ModelContainer
    extends EntityContainer<ModelImpl> {
        public ModelContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public ModelImpl[] getArray() {
            return (ModelImpl[])super.getArray();
        }

        protected ModelImpl addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            }
            ModelImpl object = ModelViewState.this.getModel(e.getId(), true);
            this.updateObject(object, e);
            ModelViewState.this.markerQueue.add(new MarkVisible(object, ModelViewState.this.timeSource.getTime() + 100000000L));
            return object;
        }

        protected void updateObject(ModelImpl object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((SpawnPosition)e.get(SpawnPosition.class));
        }

        protected void removeObject(ModelImpl object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove model for:" + e.getId());
            }
            object.setVisible(false);
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class NameContainer
    extends EntityContainer<ModelImpl> {
        private Name oldName;

        public NameContainer(EntityData ed) {
            super(ed, new Class[]{Name.class, SpawnPosition.class, ShapeInfo.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected ModelImpl addObject(Entity e) {
            ModelImpl object = ModelViewState.this.getModel(e.getId(), true);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(ModelImpl object, Entity e) {
            Name name = (Name)e.get(Name.class);
            if (this.oldName == name) {
                return;
            }
            this.oldName = name;
            if (name == null) {
                object.setName(null);
            } else {
                object.setName(name.getName());
            }
        }

        protected void removeObject(ModelImpl object, Entity e) {
            object.setName(null);
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class LargeModelContainer
    extends EntityContainer<ModelImpl> {
        public LargeModelContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class, LargeObject.class, LargeGridCell.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public ModelImpl[] getArray() {
            return (ModelImpl[])super.getArray();
        }

        protected ModelImpl addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("LargeObject add model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            }
            ModelImpl object = ModelViewState.this.getModel(e.getId(), true);
            object.setLargeObject(true);
            this.updateObject(object, e);
            ModelViewState.this.markerQueue.add(new MarkVisible(object, ModelViewState.this.timeSource.getTime() + 100000000L));
            return object;
        }

        protected void updateObject(ModelImpl object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((SpawnPosition)e.get(SpawnPosition.class));
        }

        protected void removeObject(ModelImpl object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("LargeObject remove model for:" + e.getId());
            }
            object.setLargeObject(false);
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class Mob {
        private Entity entity;
        private ModelImpl model;
        private BodyPosition pos;
        private TransitionBuffer<? extends ChildPositionTransition3d> buffer;
        private EntityId lastParent;
        boolean visible;
        boolean forceInvisible;

        public Mob(Entity entity) {
            this.entity = entity;
            this.model = ModelViewState.this.getModel(entity.getId(), true);
            this.model.setDynamic(true);
        }

        public void setShape(ShapeInfo shapeInfo) {
            this.model.setShape(shapeInfo);
        }

        public void setPosition(BodyPosition pos) {
            if (this.pos == pos) {
                return;
            }
            pos.initialize(this.entity.getId(), 12);
            this.buffer = pos.getBuffer();
        }

        public void update(long time) {
            ChildPositionTransition3d trans = (ChildPositionTransition3d)this.buffer.getTransition(time);
            if (trans != null) {
                Vec3d pos = trans.getPosition(time, true);
                EntityId parentId = trans.getParentId(time, true);
                if (!Objects.equals(parentId, this.lastParent)) {
                    if (parentId == null) {
                        if (((ModelImpl)this.model).info.spatial != null) {
                            ModelViewState.this.getObjectRoot().attachChild(((ModelImpl)this.model).info.spatial);
                        }
                        this.model.setParent(null);
                        this.lastParent = parentId;
                    } else if (((ModelImpl)this.model).info.spatial != null) {
                        ModelImpl parent = (ModelImpl)ModelViewState.this.modelIndex.get(parentId);
                        if (parent != null) {
                            if (((ModelImpl)parent).info.spatial != null) {
                                ((Node)((ModelImpl)parent).info.spatial).attachChild(((ModelImpl)this.model).info.spatial);
                                this.model.setParent(parent);
                                this.lastParent = parentId;
                            }
                        } else {
                            this.lastParent = parentId;
                        }
                    }
                }
                Quatd rot = trans.getRotation(time, true);
                this.model.setWorldPosition(pos, rot);
                if (((ModelImpl)this.model).info.spatial != null) {
                    if (((ModelImpl)this.model).info.spatial.getParent() == ModelViewState.this.getObjectRoot()) {
                        pos = pos.subtract(ModelViewState.this.centerWorld.toVec3d());
                    }
                    ((ModelImpl)this.model).info.spatial.setLocalTranslation(pos.toVector3f());
                    ((ModelImpl)this.model).info.spatial.setLocalRotation(rot.toQuaternion());
                }
                this.model.updateLabelLocation();
                this.setVisible(trans.getVisibility(time));
            }
        }

        public void setVisible(boolean f) {
            if (this.visible == f) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Mob.setVisible(" + this.entity.getId() + ", " + f + ") existing:" + this.visible);
            }
            this.visible = f;
            if (this.visible) {
                this.model.markVisible();
            } else {
                this.model.markInvisible();
            }
        }

        public void release() {
            this.setVisible(false);
            ModelViewState.this.releaseModel(this.entity.getId());
            this.model.setDynamic(false);
        }
    }

    private class MarkVisible {
        ModelImpl model;
        long visibleTime;

        public MarkVisible(ModelImpl model, long visibleTime) {
            this.model = model;
            this.visibleTime = visibleTime;
        }

        public void update() {
            if (log.isTraceEnabled()) {
                log.trace("MarkVisible.update() useCount:" + this.model.useCount + "  dynamic:" + this.model.dynamic);
            }
            if (this.model.useCount == 1 && this.model.dynamic) {
                if (log.isTraceEnabled()) {
                    log.trace("only dynamic... should already be visible.");
                }
                return;
            }
            if (this.model.useCount == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("not used anymore");
                }
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Marking static object visible:" + ((ModelImpl)this.model).info.entityId);
            }
            this.model.markVisible();
        }
    }

    private class LightingUpdater
    implements Job {
        private ModelImpl model;
        private Vec3i worldCell = new Vec3i();
        private volatile int light;
        private volatile boolean queued;

        public LightingUpdater(ModelImpl model) {
            this.model = model;
        }

        public void update(Vec3i worldCell) {
            if (this.worldCell.equals((Object)worldCell)) {
                return;
            }
            this.worldCell.set(worldCell);
            if (!this.queued) {
                this.queued = true;
                ModelViewState.this.lowWorkers.execute((Job)this, -1);
            }
        }

        public void runOnWorker() {
            this.queued = false;
            if (log.isTraceEnabled()) {
                log.trace("query lighting for:" + ((ModelImpl)this.model).info.entityId + " at:" + this.worldCell);
            }
            this.light = ModelViewState.this.worldState.getWorldLight(this.worldCell.x, this.worldCell.y, this.worldCell.z);
        }

        public double runOnUpdate() {
            if (log.isTraceEnabled()) {
                log.trace("setting lighting for:" + ((ModelImpl)this.model).info.entityId + " to:" + this.light);
            }
            this.model.setLighting(this.light);
            return 0.0;
        }
    }
}

