/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.util.SafeArrayList;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.assembly.AssemblyShape;
import mythruna.assembly.MixControl;
import mythruna.client.GameSessionState;
import mythruna.client.view.ModelInfo;
import mythruna.client.view.ModelViewListener;
import mythruna.client.view.ModelViewState;
import mythruna.es.Morph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MorphViewState.class);
    private EntityData ed;
    private JobState workers;
    private Thread renderThread;
    private ModelObserver modelObserver = new ModelObserver();
    private ConcurrentHashMap<EntityId, MorphView> viewIndex = new ConcurrentHashMap();
    private SafeArrayList<MorphView> views = new SafeArrayList(MorphView.class);

    protected void initialize(Application app) {
        this.renderThread = Thread.currentThread();
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.workers = (JobState)this.getState("priorityWorkers", JobState.class, true);
        ((ModelViewState)this.getState(ModelViewState.class, true)).addModelViewListener(this.modelObserver);
    }

    protected void cleanup(Application app) {
        if (this.getState(ModelViewState.class) != null) {
            ((ModelViewState)this.getState(ModelViewState.class)).removeModelViewListener(this.modelObserver);
        }
    }

    protected void onEnable() {
    }

    public void update(float tpf) {
        for (MorphView view : (MorphView[])this.views.getArray()) {
            view.update();
        }
    }

    protected void onDisable() {
    }

    protected boolean isRenderThread() {
        return Thread.currentThread() == this.renderThread;
    }

    private class ModelObserver
    implements ModelViewListener {
        private ModelObserver() {
        }

        @Override
        public void modelCreated(ModelInfo info) {
            this.modelUpdated(info);
        }

        @Override
        public void modelUpdated(ModelInfo info) {
            MorphView view = (MorphView)MorphViewState.this.viewIndex.get(info.entityId);
            if (view == null && !(info.shape instanceof AssemblyShape)) {
                return;
            }
            if (view == null) {
                view = new MorphView(info);
                MorphViewState.this.viewIndex.put(info.entityId, view);
                if (MorphViewState.this.isRenderThread()) {
                    view.acquire();
                } else {
                    MorphViewState.this.getApplication().enqueue(view::acquire);
                }
            } else {
                view.updateInfo(info);
            }
            view.validate();
        }

        @Override
        public void modelReleased(ModelInfo info) {
            MorphView view = (MorphView)MorphViewState.this.viewIndex.get(info.entityId);
            if (view == null) {
                return;
            }
            if (MorphViewState.this.isRenderThread()) {
                view.release();
            } else {
                MorphViewState.this.getApplication().enqueue(view::release);
            }
        }
    }

    private class MorphView
    implements Job {
        private ModelInfo info;
        private EntitySet morphs;
        private MixControl mix;

        public MorphView(ModelInfo info) {
            log.info("MorphView(" + info + ")");
            this.info = info;
            this.morphs = MorphViewState.this.ed.getEntities(Morph.filter((EntityId)info.entityId), new Class[]{Morph.class});
            log.info("morphs size:" + this.morphs.size());
            this.updateInfo(info);
        }

        public void update() {
            if (this.morphs.applyChanges()) {
                log.info("  morphs:" + this.morphs);
                for (Entity e : this.morphs.getAddedEntities()) {
                    this.apply((Morph)e.get(Morph.class));
                }
                for (Entity e : this.morphs.getChangedEntities()) {
                    this.apply((Morph)e.get(Morph.class));
                }
            }
        }

        protected void apply(Morph morph) {
            log.info("   apply(" + morph + ") mix:" + this.mix);
            if (this.mix != null) {
                this.mix.setMix(morph.getVerbString(MorphViewState.this.ed), morph.getMix());
            }
        }

        public void updateInfo(ModelInfo info) {
            this.mix = (MixControl)info.spatial.getControl(MixControl.class);
        }

        public void validate() {
        }

        public void acquire() {
            MorphViewState.this.views.add((Object)this);
        }

        public void release() {
            this.morphs.release();
            MorphViewState.this.views.remove((Object)this);
        }

        public void runOnWorker() {
        }

        public double runOnUpdate() {
            double work = 0.0;
            return work;
        }
    }
}

