/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.ObjectStatusListener;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.assembly.AssemblyShape;
import mythruna.es.Morph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(MorphSystem.class);
    private ObservableEntityData ed;
    private MPhysSystem<MBlockShape> physics;
    private PhysicsSpace<EntityId, MBlockShape> space;
    private EntityChangeObserver entityListener = new EntityChangeObserver();
    private BodyStatusObserver bodyListener = new BodyStatusObserver();
    private ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();

    protected void initialize() {
        this.ed = (ObservableEntityData)this.getSystem(EntityData.class, true);
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class, true);
        this.space = this.physics.getPhysicsSpace();
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).getBinEntityManager().addObjectStatusListener((ObjectStatusListener)this.bodyListener);
    }

    protected void terminate() {
        this.physics.getBinEntityManager().addObjectStatusListener((ObjectStatusListener)this.bodyListener);
    }

    public void start() {
        this.ed.addEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    public void update(SimTime time) {
        EntityChange change = null;
        while ((change = this.changes.poll()) != null) {
            if (change.getComponentType() != Morph.class) continue;
            Morph morph = (Morph)change.getComponent();
            if (morph == null) {
                this.removeMorph(change.getEntityId());
                continue;
            }
            this.updateMorph(change.getEntityId(), morph);
        }
    }

    public void stop() {
        this.ed.removeEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    protected AbstractBody<EntityId, MBlockShape> getBody(EntityId entity) {
        RigidBody result = this.space.getBinIndex().getRigidBody((Object)entity);
        if (result != null) {
            return result;
        }
        result = this.space.getBinIndex().getStaticBody((Object)entity);
        return result;
    }

    protected void updateMorph(EntityId entity, Morph morph) {
        log.info("updateMorph(" + entity + ", " + morph + ")");
        AbstractBody<EntityId, MBlockShape> body = this.getBody(morph.getTarget());
        if (body != null) {
            this.applyMorph(body, morph);
        }
    }

    protected void removeMorph(EntityId entity) {
        log.info("removeMorph(" + entity + ")");
    }

    protected void applyMorph(AbstractBody<EntityId, MBlockShape> body, Morph morph) {
        log.info("applyMorph(" + body.id + ", " + morph + ")");
        if (!(body.shape instanceof AssemblyShape)) {
            log.warn("Morph for object without a joints:" + body.id);
            return;
        }
        String verb = morph.getVerbString((EntityData)this.ed);
        ((AssemblyShape)body.shape).setMix(verb, morph.getMix());
    }

    protected void bodyLoaded(EntityId entity, AbstractBody<EntityId, MBlockShape> body) {
        ComponentFilter<Morph> filter = Morph.filter(entity);
        for (EntityId morphId : this.ed.findEntities(filter, new Class[]{Morph.class})) {
            this.applyMorph(body, (Morph)this.ed.getComponent(morphId, Morph.class));
        }
    }

    protected void bodyUnloaded(EntityId entity, AbstractBody<EntityId, MBlockShape> body) {
    }

    private class EntityChangeObserver
    implements EntityComponentListener {
        private EntityChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            Class type = change.getComponentType();
            if (type != Morph.class) {
                return;
            }
            MorphSystem.this.changes.add(change);
        }
    }

    private class BodyStatusObserver
    extends ObjectStatusAdapter<MBlockShape> {
        private BodyStatusObserver() {
        }

        public void objectLoaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            log.info("objectLoaded(" + entity + ")");
            MorphSystem.this.bodyLoaded(entity, (AbstractBody<EntityId, MBlockShape>)body);
        }

        public void objectUnloaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            log.info("objectUnloaded(" + entity + ")");
            MorphSystem.this.bodyUnloaded(entity, (AbstractBody<EntityId, MBlockShape>)body);
        }

        public void staticObjectLoaded(EntityId entity, StaticBody<EntityId, MBlockShape> body) {
            log.info("staticObjectLoaded(" + entity + ")");
            MorphSystem.this.bodyLoaded(entity, (AbstractBody<EntityId, MBlockShape>)body);
        }

        public void staticObjectUnloaded(EntityId entity, StaticBody<EntityId, MBlockShape> body) {
            log.info("staticObjectUnloaded(" + entity + ")");
            MorphSystem.this.bodyUnloaded(entity, (AbstractBody<EntityId, MBlockShape>)body);
        }
    }
}

