/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.util.TempVars;

public class MathUtils {
    private MathUtils() {
    }

    public static Quaternion log(Quaternion q, Quaternion store) {
        float a = FastMath.acos(q.w);
        float sina = FastMath.sin(a);
        store.w = 0.0f;
        if (sina > 0.0f) {
            store.x = a * q.x / sina;
            store.y = a * q.y / sina;
            store.z = a * q.z / sina;
        } else {
            store.x = 0.0f;
            store.y = 0.0f;
            store.z = 0.0f;
        }
        return store;
    }

    public static Quaternion exp(Quaternion q, Quaternion store) {
        float cosLen;
        float len = FastMath.sqrt(q.x * q.x + q.y * q.y + q.z * q.z);
        float sinLen = FastMath.sin(len);
        store.w = cosLen = FastMath.cos(len);
        if (len > 0.0f) {
            store.x = sinLen * q.x / len;
            store.y = sinLen * q.y / len;
            store.z = sinLen * q.z / len;
        } else {
            store.x = 0.0f;
            store.y = 0.0f;
            store.z = 0.0f;
        }
        return store;
    }

    public static Quaternion slerpNoInvert(Quaternion q1, Quaternion q2, float t, Quaternion store) {
        float dot = q1.dot(q2);
        if (dot > -0.95f && dot < 0.95f) {
            float angle = FastMath.acos(dot);
            float sin1 = FastMath.sin(angle * (1.0f - t));
            float sin2 = FastMath.sin(angle * t);
            float sin3 = FastMath.sin(angle);
            store.x = (q1.x * sin1 + q2.x * sin2) / sin3;
            store.y = (q1.y * sin1 + q2.y * sin2) / sin3;
            store.z = (q1.z * sin1 + q2.z * sin2) / sin3;
            store.w = (q1.w * sin1 + q2.w * sin2) / sin3;
            System.err.println("real slerp");
        } else {
            store.set(q1).nlerp(q2, t);
            System.err.println("nlerp");
        }
        return store;
    }

    public static Quaternion slerp(Quaternion q1, Quaternion q2, float t, Quaternion store) {
        float dot = q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
        if (dot < 0.0f) {
            q2.x = -q2.x;
            q2.y = -q2.y;
            q2.z = -q2.z;
            q2.w = -q2.w;
            dot = -dot;
        }
        float scale0 = 1.0f - t;
        float scale1 = t;
        if (dot < 0.9f) {
            float theta = FastMath.acos(dot);
            float invSinTheta = 1.0f / FastMath.sin(theta);
            scale0 = FastMath.sin((1.0f - t) * theta) * invSinTheta;
            scale1 = FastMath.sin(t * theta) * invSinTheta;
            store.x = scale0 * q1.x + scale1 * q2.x;
            store.y = scale0 * q1.y + scale1 * q2.y;
            store.z = scale0 * q1.z + scale1 * q2.z;
            store.w = scale0 * q1.w + scale1 * q2.w;
        } else {
            store.x = scale0 * q1.x + scale1 * q2.x;
            store.y = scale0 * q1.y + scale1 * q2.y;
            store.z = scale0 * q1.z + scale1 * q2.z;
            store.w = scale0 * q1.w + scale1 * q2.w;
            store.normalizeLocal();
        }
        return store;
    }

    private static Quaternion spline(Quaternion qnm1, Quaternion qn, Quaternion qnp1, Quaternion store, Quaternion tmp) {
        Quaternion invQn = new Quaternion(-qn.x, -qn.y, -qn.z, qn.w);
        MathUtils.log(invQn.mult(qnp1), tmp);
        MathUtils.log(invQn.mult(qnm1), store);
        store.addLocal(tmp).multLocal(-0.25f);
        MathUtils.exp(store, tmp);
        store.set(qn).multLocal(tmp);
        return store.normalizeLocal();
    }

    public static Quaternion squad(Quaternion q0, Quaternion q1, Quaternion q2, Quaternion q3, Quaternion a, Quaternion b, float t, Quaternion store) {
        MathUtils.spline(q0, q1, q2, a, store);
        MathUtils.spline(q1, q2, q3, b, store);
        MathUtils.slerp(a, b, t, store);
        MathUtils.slerp(q1, q2, t, a);
        return MathUtils.slerp(a, store, 2.0f * t * (1.0f - t), b);
    }

    public static float raySegmentShortestDistance(Ray ray, Vector3f segStart, Vector3f segEnd, Camera camera) {
        TempVars vars = TempVars.get();
        Vector3f resultSegmentPoint1 = vars.vect1;
        Vector3f resultSegmentPoint2 = vars.vect2;
        Vector3f p1 = segStart;
        Vector3f p2 = segEnd;
        Vector3f p3 = ray.origin;
        Vector3f p4 = vars.vect3.set(ray.getDirection()).multLocal(Math.min(ray.getLimit(), 1000.0f)).addLocal(ray.getOrigin());
        Vector3f p13 = vars.vect4.set(p1).subtractLocal(p3);
        Vector3f p43 = vars.vect5.set(p4).subtractLocal(p3);
        if ((double)p43.lengthSquared() < 1.0E-4) {
            vars.release();
            return -1.0f;
        }
        Vector3f p21 = vars.vect6.set(p2).subtractLocal(p1);
        if ((double)p21.lengthSquared() < 1.0E-4) {
            vars.release();
            return -1.0f;
        }
        double d1343 = (double)p13.x * (double)p43.x + (double)p13.y * (double)p43.y + (double)p13.z * (double)p43.z;
        double d4321 = (double)p43.x * (double)p21.x + (double)p43.y * (double)p21.y + (double)p43.z * (double)p21.z;
        double d1321 = (double)p13.x * (double)p21.x + (double)p13.y * (double)p21.y + (double)p13.z * (double)p21.z;
        double d2121 = (double)p21.x * (double)p21.x + (double)p21.y * (double)p21.y + (double)p21.z * (double)p21.z;
        double d4343 = (double)p43.x * (double)p43.x + (double)p43.y * (double)p43.y + (double)p43.z * (double)p43.z;
        double denominator = d2121 * d4343 - d4321 * d4321;
        if (Math.abs(denominator) < 1.0E-4) {
            vars.release();
            return -1.0f;
        }
        double numerator = d1343 * d4321 - d1321 * d4343;
        double mua = numerator / denominator;
        double mub = (d1343 + d4321 * mua) / d4343;
        resultSegmentPoint1.x = (float)((double)p1.x + mua * (double)p21.x);
        resultSegmentPoint1.y = (float)((double)p1.y + mua * (double)p21.y);
        resultSegmentPoint1.z = (float)((double)p1.z + mua * (double)p21.z);
        resultSegmentPoint2.x = (float)((double)p3.x + mub * (double)p43.x);
        resultSegmentPoint2.y = (float)((double)p3.y + mub * (double)p43.y);
        resultSegmentPoint2.z = (float)((double)p3.z + mub * (double)p43.z);
        float startToPoint = vars.vect3.set(resultSegmentPoint1).subtractLocal(segStart).lengthSquared();
        float endToPoint = vars.vect3.set(resultSegmentPoint1).subtractLocal(segEnd).lengthSquared();
        float segLength = vars.vect3.set(segEnd).subtractLocal(segStart).lengthSquared();
        if (startToPoint > segLength || endToPoint > segLength) {
            vars.release();
            return -1.0f;
        }
        if (camera != null) {
            camera.getScreenCoordinates(resultSegmentPoint1, resultSegmentPoint1);
            camera.getScreenCoordinates(resultSegmentPoint2, resultSegmentPoint2);
        }
        float length = resultSegmentPoint1.subtractLocal(resultSegmentPoint2).length();
        vars.release();
        return length;
    }
}

