/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */

// Some essentially temporary test objects for testing inventory, item
// holding, item manipulation, and other test things. 


import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.tree.*;

findTree = { Vec3i block ->
    def tileId = TileId.fromWorld(block);
    def treeTile = world.getTrees(tileId, null);
    def tileLoc = block - tileId.getWorld(null);
    //treeTile.getTrees(block).each {
    //}
    return treeTile.getTrees(block).find { tree -> tree.x == tileLoc.x && tree.z == tileLoc.z }
}

createType("Axe").with {
    supertypes("BaseItem");

    setTypeVar("manipulator", "Swing");

    setTypeVar("description",
        "This was axe was created by %creator with ID %id.");
    setTypeVar("handleLocation", new Vec3d(6, 0, 5));

    setTypeVar("shape",
               ShapeInfo.create("/Models/items/axe1.blocks", standardItemScale)); 
    setTypeVar("volume", new ObjectVolume(getTypeVar("shape").volume));

    addAction("mainPressBlock") { blockHit ->
        Vec3d loc = blockHit.location;
        Vec3i block = blockHit.block;
        log.info("start chopping:" + block);
    }

    addAction("mainClickBlock") { blockHit ->
        Vec3d loc = blockHit.location;
        Vec3i block = blockHit.block;
        log.info("chop:" + loc);

        int cell = world.getWorldCell(block as Vec3d);
        int type = MaskUtils.getType(cell);
        int sides = MaskUtils.getSideMask(cell);

        def genType = CellGenType.getType(cell);

        echo("Chop:" + genType);

        def found = findTree(block);
        echo("Tree:" + found);

        // The below would be nearly 100% accurate but would require
        // straddling columns to get the full tree and requires shuffling
        // lots of additional leaf data around just to pull out a single
        // tree.  Instead, we will let TreeType guess if block type is
        // part of it or not.
        //def colId = ColumnId.fromWorld(block);
        //def colData = new ColumnData(colId, GameConstants.MAX_BUILD_HEIGHT / 32);
        //
        //def tileId = TileId.fromWorld(block);
        //def treeTile = world.getTrees(tileId, null);
        //
        //def localTrees = treeTile.getTrees(colId);
        //if( localTrees.isEmpty() ) {
        //    return false;
        //}
        //
        //Random rand = new Random(columnId.getId()); // consistent random per column
        //def cells = new TileColumnCells(colData);
        //for( Tree tree : localTrees ) {
        //    //log.info("  insert:" + tree + " into:" + col.getColumnId());
        //    if( tree == found ) {
        //        // Clear everything so far
        //        colData.leafs.each { leaf ->
        //            leaf.rawCells.clear();
        //        }
        //    }
        //    tree.type.insertTree(tree, cells, rand);
        //    if( tree == found ) {
        //        break;
        //    }
        //}

        // Guess which blocks are part of this tree
        def tileId = TileId.fromWorld(block);
        def tileLoc = block - tileId.getWorld(null);

        int size = 1 + found.radius * 2;
        int xBase = found.x - found.radius;
        int yBase = found.y;
        int zBase = found.z - found.radius;

        CellArray cells = new CellArray(size, found.height, size);

        Vec3d base = new Vec3d(xBase, yBase, zBase);
        //log.info("base:" + base);
        base = base + tileId.getWorld(null);
        //log.info("world base:"+ base);

        for( int y = 0; y < found.height; y++ ) {
            for( int z = 0; z < size; z++ ) {
                def sb = new StringBuilder();
                for( int x = 0; x < size; x++ ) {
                    cell = world.getWorldCell(base.add(x, y, z));
                    genType = CellGenType.getType(cell);
                    if( genType == CellGenType.Flora ) {
                        type = MaskUtils.getType(cell);
                        if( found.type.isBlock(found, x - found.radius, y, z - found.radius, type) ) {
                            //sb.append("[1]");
                            cells.setCell(x, y, z, type);
                        } else {
                            //sb.append("[0]");
                        }
                    } else {
                        //sb.append("[0]");
                    }
                }
                //log.info("[" + y + "][" + z + "] = " + sb);
            }
        }

        // Make sure the cells have accurate masks
        MaskUtils.calculateSideMasks(cells);

        //createBlueprintFromCells(activator.id, "Tree:" + block.x + "x" + block.z, "Tree", cells, false, 0.25);
        createBlueprintFromCells(activator.id, "Tree:" + block.x + "x" + block.z, "Tree", cells, false, 1);
    }


    addAction("altClickBlock") { blockHit ->
        Vec3d loc = blockHit.location;
        Vec3i block = blockHit.block;
        echo("Loc:" + loc + " block:" + block);

        def filter = fieldEquals(BlueprintInfo, "parent", activator.id);

        // Get the blueprints as a tree set just so they are ordered by
        // ID... which is roughly by creation time.
        def blueprints = findEntities(filter, BlueprintInfo) as TreeSet;

        def tree = blueprints.find { it.name.startsWith("Tree") };

        echo("Tree blueprint:" + tree);

        def bp = tree;

        def shape = bp[ShapeInfo];

        // Need to get the size so we can find its base's center.
        // We probably should keep this as part of the object type or even a separate
        // component.
        def cells = shape.loadCells();

        def worldEdits = new WorldEdits();

        for( int x = 0; x < cells.sizeX; x++ ) {
            for( int z = 0; z < cells.sizeZ; z++ ) {
                for( int y = 0; y < cells.sizeY; y++ ) {
                    int val = cells.getCell(x, y, z);
                    world.setWorldCell(loc.add(x, y, z), val, worldEdits);
                }
            }
        }

        world.deliverEvents(worldEdits);

        echo("World implemention:" + world.getClass() + "  thread:" + Thread.currentThread());

        return true;

    }

    addAction("startSwing") { facing ->
        log.info("startSwing:" + facing);
    }

    addAction("swing") { facing ->
        log.info("swing:" + facing);
    }

    addAction("stopSwing") { facing ->
        log.info("stopSwing:" + facing);
    }

}

createType("Sword").with {
    supertypes("BaseItem");

    setTypeVar("manipulator", "Swing");

    setTypeVar("shape",
               ShapeInfo.create("/Models/items/sword1.blocks", standardItemScale)); 
    // The sword requires some custom sizing to make sense in inventory              
    def size = getTypeVar("shape").loadCells().size.toVec3d();
    size.x = 3;
    size *= standardItemScale;                
    setTypeVar("volume", new ObjectVolume(size));

    setTypeVar("description",
        "This %name was created by %creator with ID %id.");
    setTypeVar("handleLocation", new Vec3d(3, 1, 4));
    setTypeVar("handleRotation", new Quatd().fromAngles(0, 0, -Math.PI * 0.5));

    addAction("startSwing") { facing ->
        log.info("startSwing:" + facing);
    }

    addAction("swing") { facing ->
        log.info("swing:" + facing);
    }

    addAction("stopSwing") { facing ->
        log.info("stopSwing:" + facing);
    }
}

createType("Book").with {
    supertypes("BaseItem");

    setTypeVar("shape",
               ShapeInfo.create("/Models/items/book.blocks", standardItemScale)); 
    setTypeVar("volume", new ObjectVolume(getTypeVar("shape").volume));

    setTypeVar("description",
        "This was book was created by %creator with ID %id.");
    setTypeVar("handleLocation", new Vec3d(0, 4, 1));
    setTypeVar("handleRotation", new Quatd().fromAngles(Math.PI * 0.5, Math.PI, 0));
}


createType("TestObject").with {
    supertypes("BaseItem");

    setTypeVar("manipulator", "Digger");
    setTypeVar("description",
        "This was book was created by %creator with ID %id.");

    addAction("Test") { ->
        //log.info("" + this + "." + getName() + "(" + Arrays.asList(args) + ")");
        log.info("" + this + "." + "Test" + "(" + ")");
        log.info("owner:" + owner + " delegate:" + delegate);
        log.info("Activator:" + activator);
        log.info("Activator:" + getActivator());
        //log.info("variables:" + getVariables()); // from 'delegate'
        log.info("activator.vars:" + activator.vars); // from 'delegate'
        log.info("target:" + getTarget()); // from 'this'

        // This goes to a global binding
        testProperty = 123;

        //log.info("variables:" + getVariables()); // from 'delegate'

        //activator.target = "Test Target";
        //log.info("activator.vars:" + activator.vars); // from 'delegate'
        //log.info("target:" + getTarget()); // from 'this'?  Yep.

        //log.info("vars:" + activator.vars);
        //log.info("test:" + activator.vars.get("selectedType"));
        //log.info("test1:" + activator.getProperty("selectedType"));
        //log.info("test2:" + activator.selectedType);
        //activator.foo = 123;
        //log.info("test3:" + activator.foo);
        return true;
    }

    addAction("Test2") { String name ->
        log.info("Test2:" + name);
        return true;
    }

    addAction("Test3") { ->
        log.info("Calling delegate version of run()");
        // This one calls it directly on ActionContext which is our 'this'
        object.run(env, "Test2", "This is a test")
        log.info("Calling non-delegate version of run()");
        run("Test2", "This is a different test")
        //run("BaseTest")

        def manipulator = object.getType().getTypeVar("manipulator", "Default");

        log.info("Manipulator:" + manipulator);
        log.info("test:" + (object.manipulator?:"Default"));

        log.info("holding1:" + Holding.create(object.getTarget(), manipulator, entityData));
        log.info("holding2:" + Holding.create(object.getTarget(), manipulator));
        log.info("holding3:" + Holding.create(object, manipulator));
        log.info("holding4:" + Holding.create(activator, manipulator));

        log.info("contains1:" + activator.contains(object));

        // What about running an action from a different type or one of
        // our super types?
        log.info("Running it the hard way--------------------");
        type("BaseObject").findAction("Look").run(env, context);

        log.info("Running it the easy way--------------------");
        run(type("BaseObject"), "Look");

        return true;
    }

    addGetter("test") { -> //target ->
        log.info("getter-test");
        log.info("  getter-ed:" + system(EntityData));
        log.info("  getter-target:" + target);
        log.info("  getter-activator:" + activator);
        log.info("  owner:" + owner);
        log.info("  delegate:" + delegate);
        log.info("  this:" + this);
        return "foo-123"
    }

    //addGetter("name") { ->
    //    log.info("target:" + target);
    //    log.info("delegate:" + delegate);
    //    def on = delegate[ObjectName];
    //    log.info("name test:" + on);
    //    log.info("delegate test:" + delegate[ObjectName]);
    //    if( on != null ) {
    //        return on.getName(entityData);
    //    }
    //    def n = delegate[Name];
    //    if( n != null ) {
    //        return n.getName();
    //    }
    //    return "Entity@" + target.getId();
    //}

}

createType("TestWand").with {
    supertypes("BaseItem");

    setTypeVar("manipulator", "Creator");
    setTypeVar("handleLocation", new Vec3d(0, 3, 0));
    setTypeVar("handleRotation", new Quatd().fromAngles(Math.PI * 0.5, 0, 0));
    setTypeVar("description",
               "A Test Wand."
             );

    setTypeVar("shape",
               ShapeInfo.create("/Models/items/metal-wand.blocks", standardItemScale * 0.5)); 
    setTypeVar("volume", new ObjectVolume(getTypeVar("shape").volume));

    addAction("mainClickBlock") { blockHit ->
        Vec3d loc = blockHit.location;
        Vec3i block = blockHit.block;
        echo("Clicked:" + block)

        //double temperature = worldManager.worldFractal.getTemperature(block.x, block.y, block.z);
        //double weather = worldManager.worldFractal.getWeather(block.x, block.y, block.z);
        //double ecology = worldManager.worldFractal.getEcology(block.x, block.y, block.z);
        //
        //// Adjust temperature for elevation
        ////int seaLevel = 128;
        ////int treeLine = seaLevel + 490;
        ////double height = Math.abs(block.y - seaLevel) / (double)treeLine;
        ////echo("height scale:" + height);
        ////double baselineHeight = 0.2;
        ////double effectiveTemperature = temperature;
        ////if( height > baselineHeight ) {
        ////    double heightEffect = (height - baselineHeight) / (1.0 - baselineHeight);
        ////    double temperatureAdjust = heightEffect * 0.4;
        ////    effectiveTemperature = temperature - temperatureAdjust;
        ////}
        //double effectiveTemperature = worldManager.worldFractal.getAdjustedTemperature(block.x, block.y, block.z);
        //
        //// Adjust precipiation by temperature if we are in particularly
        //// hot climates.  Anything above 40C is desert and will significantly
        //// affect whether precipitation accumulates.
        //// 40C in the range of -20 to 50 should be 0.857
        ////double effectiveWeather = weather;
        ////if( effectiveTemperature > 0.857 ) {
        ////    double weatherAdjust = (effectiveTemperature - 0.857) / (1.0 - 0.857);
        ////    weatherAdjust = 1 - weatherAdjust;
        ////    // Weather adjust should be in 0..1 where 0 is no precip. and
        ////    // 1 is max precip
        ////    effectiveWeather *= weatherAdjust;
        ////}
        //double effectiveWeather = worldManager.worldFractal.getAdjustedWeather(block.x, block.y, block.z, effectiveTemperature);
        //
        ////// Temper ecology by how wet things are on average
        ////double effectiveEcology = ecology;
        ////if( effectiveWeather < 0.25 ) {
        ////    effectiveEcology *= (effectiveWeather / 0.25);
        ////} else if( effectiveWeather > 0.75 ) {
        ////    // Increase ecology, up to double
        ////    effectiveEcology *= 1 + ((effectiveWeather - 0.75)/0.25);
        ////    if( effectiveEcology > 1 ) {
        ////        effectiveEcology = 1;
        ////    }
        ////}
        //double effectiveEcology = worldManager.worldFractal.getAdjustedEcology(block.x, block.y, block.z, effectiveWeather);

        def info = worldManager.worldFractal.getBioInfo(block.x, block.y, block.z, null);

        echo("Temperature:" + info.baseTemperature + "  effective:" + info.temperature);
        echo("Weather:" + info.basePrecipitation + "  effective:" + info.precipitation);
        echo("Climate:" + info.climate + "  Soil Quality:" + info.soilQuality);
        echo("Vegetation:" + info.baseVegetationLevel + "  effective:" + info.vegetationLevel);

        int foliage = (int)Math.round(info.vegetationLevel * 3) & 0x3;
        int wetness = (int)Math.round(info.precipitation * 3) & 0x3;
        echo("foliage level:" + foliage + "/3   wetness level:" + wetness + "/3");

        def tileId = TileId.fromWorld(block.x, block.y, block.z);
        def terrain = world.getTerrainImage(tileId, TerrainImageType.Terrain, null);
        def origin = tileId.getWorld(null);        
        int type = terrain.getType((int)(block.x - origin.x), (int)(block.z - origin.z));
        byte light = terrain.getLight((int)(block.x - origin.x), (int)(block.z - origin.z));
        int baseType = TerrainTypes.getBaseType(type); 
        echo("Encoded type:" + baseType + " foliage level:" + TerrainTypes.getFoliageLevel(type) + "/3 wetness level:" + TerrainTypes.getWetnessLevel(type) + "/3 frozen:" + TerrainTypes.isFrozen(type));

        double c = (info.temperature * 70) - 20;
        double f = c * 1.8 + 32;
        double p = info.precipitation * 100;
        echo(String.format("%.01f C (%.01f F)  Avg. rainfall: %.02f cm (%.02f inches)", c, f, p*2.5, p));
        
        // Show what the tree generator would use for type selection
        int TEMPERATURE_ZONES = 7;
        double VEG1 = 0.2;
        double VEG2 = 0.25;
        double VEG3 = 0.4;
        double VEG4 = 0.5;
        double VEG5 = 0.75;
        double VEG6 = 1;

        double PROB1 = 0.001;
        double PROB2 = 0.003;
        double PROB3 = 0.01;
        double PROB4 = 0.1;
        double PROB5 = 0.75;
        double PROB6 = 1.0;
        int treeLine = 490 + GameConstants.SEA_LEVEL;
        def density = "LOW";
        double chance = 0;
        double veg = 0;
        
        if( baseType == TerrainTypes.TYPE_SAND ) {
            chance = info.vegetationLevel * 0.001;
        } else {
            veg = info.vegetationLevel;
 
            if( veg < VEG1 ) {
                chance = (veg/VEG1);
                chance = chance * PROB1;
                density = "LOW";
            } else if( veg < VEG2 ) { 
                chance = (veg - VEG1)/(VEG2 - VEG1);
                chance = PROB1 + (chance * (PROB2 - PROB1)); 
                density = "LOW";
            } else if( veg < VEG3 ) { 
                chance = (veg - VEG2)/(VEG3 - VEG2);
                chance = PROB2 + (chance * (PROB3 - PROB2)); 
                density = "MEDIUM";
            } else if( veg < VEG4 ) { 
                chance = (veg - VEG3)/(VEG4 - VEG3);
                chance = PROB3 + (chance * (PROB4 - PROB3)); 
                density = "MEDIUM";
            } else if( veg < VEG5 ) { 
                chance = (veg - VEG4)/(VEG5 - VEG4);
                chance = PROB4 + (chance * (PROB5 - PROB4)); 
                density = "HIGH";
            } else if( veg < VEG6 ) { 
                chance = (veg - VEG5)/(VEG6 - VEG5);
                chance = PROB5 + (chance * (PROB6 - PROB5)); 
                density = "HIGH";
            } else {
                chance = 1;
                density = "HIGH";
            }
        } 
        if( block.y > treeLine ) {
            // only the very very smallest chance
            t = 0.0001 * info.soilQuality; 
        }
        int zone = (int)(TEMPERATURE_ZONES * info.temperature);

        echo(String.format("Density: %s  Zone: %d  Chance: %.03f  Splat: %d", density, zone, chance, light));
    }

    addAction("place") { blockHit ->
        Vec3d loc = blockHit.location;
        Vec3i block = blockHit.block;
        log.info("place:" + loc);

        if( !getPerms(activator, loc).canAddObject() ) {
            echo("You do not have permission to place objects here.");
            return;
        }

        //echo("Placing speakers.");

        boolean useSpeakers = false;
        boolean useAssembly = true;
        def shape;
        def objectType = null;
        if( useSpeakers ) {
            shape = ShapeInfo.create("/Models/objects/speakers.blocks", 0.25, entityData);

            // Need to get the size so we can find its base's center.
            // We probably should keep this as part of the object type or even a separate
            // component.
            def cells = shape.loadCells();
            def size = cells.size;
            def offset = size * 0.5 * shape.scale;
            offset.y = 0;
            log.info("cells:" + cells + "  offset:" + offset);

            loc -= offset;

        } else if( useAssembly ) {
            //shape = ShapeInfo.create("/Models/objects/chest1.assembly", 1, entityData);
            //objectType = "TestChest"; 

            //shape = ShapeInfo.create("/Models/objects/wood-door1.assembly", 1, entityData);
            //objectType = "TestDoor";
             
            shape = ShapeInfo.create("/Models/objects/desk1.assembly", 1, entityData);
            objectType = "TestDesk"; 
        } else {
            shape = ShapeInfo.create("animals/gaefen.rig", 1, entityData);
            //shape = ShapeInfo.create("human/female/human-female.rig", 1, entityData);
        }


        // FIXME: make a createObject() method that encapsulates some of
        // this, calls a default object init action, etc..
        def pos = new SpawnPosition(loc, new Quatd());

        if( useSpeakers ) {
            def startTime = gameSystems.stepTime.time;
            //def endTime = gameSystems.stepTime.getFutureTime(30); // 30 seconds
            def endTime = gameSystems.stepTime.getFutureTime(32); // 32 seconds

            def placed = createEntity(
                    pos, shape,
                    ObjectName.create("Speakers", entityData),
                    ObjectTypeInfo.create("Speakers", entityData),
                    //SoundInfo.create("/Sounds/Effects/machine-spin-mono.ogg", startTime, 1, true, entityData),
                    SoundInfo.create("/Sounds/Effects/TestSounds.ogg", startTime, 1, true, entityData),
                    //SoundInfo.create("/Sounds/Effects/machine-spin-mono.wav", 0, 1, true, entityData),
                    new CreatedBy(activator.id),
                    new Decay(startTime, endTime)
                );
        } else if( useAssembly ) {
            def startTime = gameSystems.stepTime.time;
            def endTime = gameSystems.stepTime.getFutureTime(30); // 30 seconds

            def placed = createEntity(
                    pos, shape,
                    ObjectName.create("Test", entityData),
                    ObjectTypeInfo.create(objectType, entityData),
                    new Mass(0),
                    new CreatedBy(activator.id)
                    //new Decay(startTime, endTime)
                );
        } else {
            def startTime = gameSystems.stepTime.time;
            def endTime = gameSystems.stepTime.getFutureTime(120); // 2 minutes

            def placed = createEntity(
                    pos, shape,
                    ObjectName.create("Gaefen", entityData),
                    new Mass(10),
                    new CreatedBy(activator.id),
                    AgentType.create("Gaefin", AgentType.LEVEL_HIGH, entityData),
                    new Decay(startTime, endTime)
                );

            //def anim = createEntity(
            //        new AnimationConfig(placed, new LayerConfig(null, "Idle", "Walk", "Run"))
            //    );
        }

        return true;
    }

    addAction("contextAction") { objectHit ->
        def clicked = objectHit.entityId;
        def pos = objectHit.location;

        log.info("contextAction:" + clicked + ", " + pos);
        def name = clicked.name?:"Unknown";

        // Here we want to let the player run some actions on the object

        // Is it our object?
        def creator = clicked[CreatedBy]?.creatorId;
        log.info("Player:" + activator.id + " creator:" + creator);

        // Assemble the action list
        def options = [];
        def clickedContext = clicked.context;
        log.info("Checking actions for type:" + clicked.type);        
        for( def action : clicked.type.contextActions ) {
            if( !action.canRun(env, clickedContext) ) {
                log.info("Skipping:" + action);
                continue;
            }
            options.add(new Option(action.getName()));
        }

        // Instead of hasShape... we should probably base this on
        // the actions that the object has.  That way we can have non-removable
        // objects that have shapes.  And then move "deleteObject" to the objects
        // that support delete... the others can echo a message that they can't
        // be removed.
        // FIXME: use the runnable action list when we have it... ie: not all
        // actions, just the ones that canRun().
        def objPos = clicked[SpawnPosition]?.location;
        if( getPerms(activator, objPos).canRemoveObject() ) {
            // Options to call us back as the manipulator
            options.add(new Option(target, "deleteObject", clicked));
        }
        session.showPrompt(clicked, PromptType.List, name);
        session.showOptions(clicked, options);
    }

    addAction("deleteObject") { clicked ->
        log.info("deleteObject:" + clicked);

        def objPos = clicked[SpawnPosition]?.location;
        if( !getPerms(activator, objPos).canRemoveObject() ) {
            echo("You do not have permission to remove objects here.");
            return;
        }
        // We should probably check to see if we can in case we hacked
        // in around the context menu
        removeEntity(clicked);
    }
}

createType("TestChest").with {
    supertypes("BaseCloseable");
}

createType("TestDoor").with {
    supertypes("BaseCloseable");
}

createType("TestDesk").with {
    supertypes("BaseCloseable");
}


createType("Speakers").with {
    supertypes("BaseObject");

    addAction("Look") { ->
        def lines = [];

        lines += "Examine: " + object.name;

        lines += "Sound:" + object[SoundInfo]

        session.showPrompt(target, PromptType.Dialog, lines.join("\n"));
        session.showOptions(target, []);

        return true;
    }

}


