/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.ColliderType;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.collision.AngleCollider;
import com.simsilica.mblock.phys.collision.ColliderFactory;
import com.simsilica.mblock.phys.collision.CubeCollider;
import com.simsilica.mblock.phys.collision.WedgeCollider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderFactories {
    static Logger log = LoggerFactory.getLogger(ColliderFactories.class);
    private Map<String, ColliderFactory> registry = new HashMap<String, ColliderFactory>();

    public ColliderFactories() {
        this(false);
    }

    public ColliderFactories(boolean initDefaults) {
        if (initDefaults) {
            this.initializeDefaults();
        }
    }

    public void initializeDefaults() {
        this.register("cube", new CubeColliderFactory());
        this.register("wedge", new WedgeColliderFactory());
        this.register("wedge-corner", new CubeColliderFactory());
        this.register("angle", new AngleColliderFactory());
        this.register("vcyl", new CubeColliderFactory());
        this.register("hcyl", new CubeColliderFactory());
        this.register("shallow-corner", new CubeColliderFactory());
        this.register("hi-wedge-corner", new CubeColliderFactory());
        this.register("sphere", new CubeColliderFactory());
    }

    public void register(String name, ColliderFactory factory) {
        this.registry.put(name, factory);
    }

    public Collider[] createColliders(BlockType[] types) {
        Collider[] result = new Collider[types.length];
        for (int i = 0; i < result.length; ++i) {
            BlockName name;
            result[i] = this.createCollider(types[i]);
            BlockName blockName = name = types[i] != null ? types[i].getName() : null;
            if (!log.isTraceEnabled()) continue;
            log.trace("types[" + i + "]=" + name + "   collider:" + result[i]);
        }
        return result;
    }

    public Collider createCollider(BlockType type) {
        if (type == null) {
            return null;
        }
        ColliderType colliderType = type.getColliderType();
        if (colliderType == null) {
            return null;
        }
        ColliderFactory factory = this.registry.get(colliderType.getName());
        if (factory == null) {
            throw new IllegalArgumentException("No factory found for:" + colliderType.getName());
        }
        Collider result = factory.createCollider(type);
        return result;
    }

    public static class AngleColliderFactory
    implements ColliderFactory {
        @Override
        public Collider createCollider(BlockType type) {
            return new AngleCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().getRotation(), type.getName().toString());
        }
    }

    public static class WedgeColliderFactory
    implements ColliderFactory {
        private static Direction[] dirs = Direction.values();

        @Override
        public Collider createCollider(BlockType type) {
            BoundaryShapes.Triangle tri = null;
            for (int i = 0; i < 4; ++i) {
                Direction dir = Direction.cardinalDirection((int)i);
                BoundaryShape shape = type.getShape(dir);
                if (!(shape instanceof BoundaryShapes.Triangle)) continue;
                tri = (BoundaryShapes.Triangle)shape;
                break;
            }
            if (tri == null) {
                throw new IllegalArgumentException("Block type does not have triangle shaped sides:" + type);
            }
            Direction up = tri.getNormal().y < 0.0f ? Direction.Down : Direction.Up;
            return new WedgeCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().getRotation(), up, tri, type.getName().toString());
        }
    }

    public static class CubeColliderFactory
    implements ColliderFactory {
        @Override
        public Collider createCollider(BlockType type) {
            return new CubeCollider(type.getFactory().getMin(), type.getFactory().getMax(), type.getName().toString());
        }
    }
}

