/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mworld.io.CellArrayProtocol;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.assembly.Subassembly;
import mythruna.assembly.db.SubassemblyId;
import mythruna.assembly.io.SubassemblyProtocol;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.net.DataSession;
import mythruna.net.DataSessionListener;
import mythruna.text.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSessionClientService
extends AbstractClientService
implements DataSession {
    static Logger log = LoggerFactory.getLogger(DataSessionClientService.class);
    private RmiClientService rmiService;
    private byte channel;
    private DataSession delegate;
    private LoadingCache<CellArrayId, CellArray> cellArrayCache;
    private LoadingCache<SubassemblyId, Subassembly> subassemblyCache;
    private DataSessionCallback sessionCallback = new DataSessionCallback();
    private List<DataSessionListener> listeners = new CopyOnWriteArrayList<DataSessionListener>();

    public DataSessionClientService(int channel) {
        this.channel = (byte)channel;
        this.cellArrayCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<CellArrayId, CellArray>(){

            public CellArray load(CellArrayId key) {
                DataSessionClientService.this.threadCheck();
                byte[] bytes = DataSessionClientService.this.getCellArrayBytes(key.getId());
                return CellArrayProtocol.fromBytes((byte[])bytes);
            }
        });
        this.subassemblyCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<SubassemblyId, Subassembly>(){

            public Subassembly load(SubassemblyId key) {
                DataSessionClientService.this.threadCheck();
                byte[] bytes = DataSessionClientService.this.getSubassemblyBytes(key.getId());
                return SubassemblyProtocol.fromBytes(bytes);
            }
        });
    }

    protected void threadCheck() {
        if ("jME3 Main".equals(Thread.currentThread().getName())) {
            log.error("long-style query, cache miss on render thread", new Throwable("stack-trace"));
        }
    }

    private DataSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (DataSession)this.rmiService.getRemoteObject(DataSession.class);
            log.info("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No DataSession found");
            }
        }
        return this.delegate;
    }

    public void addDataSessionListener(DataSessionListener l) {
        this.listeners.add(l);
    }

    public void removeDataSessionListener(DataSessionListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.info("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("RMI service required");
        }
        this.rmiService.share((Object)this.sessionCallback, DataSessionListener.class);
    }

    public void start() {
        log.info("start()");
        super.start();
    }

    @Override
    public FabricTypeData getFabricTypeData() {
        byte[] bytes = this.getFabricTypeDataBytes();
        return FabricTypeData.fromBytes(bytes);
    }

    @Override
    public byte[] getFabricTypeDataBytes() {
        return this.getDelegate().getFabricTypeDataBytes();
    }

    @Override
    public SwatchShapeData getSwatchShapeData() {
        byte[] bytes = this.getSwatchShapeDataBytes();
        return SwatchShapeData.fromBytes(bytes);
    }

    @Override
    public byte[] getSwatchShapeDataBytes() {
        return this.getDelegate().getSwatchShapeDataBytes();
    }

    @Override
    public byte[] getCellArrayBytes(long id) {
        this.threadCheck();
        return this.getDelegate().getCellArrayBytes(id);
    }

    @Override
    public CellArray getCellArray(CellArrayId id) {
        return (CellArray)this.cellArrayCache.getUnchecked((Object)id);
    }

    @Override
    public byte[] getSubassemblyBytes(long id) {
        this.threadCheck();
        return this.getDelegate().getSubassemblyBytes(id);
    }

    @Override
    public Subassembly getSubassembly(SubassemblyId id) {
        return (Subassembly)this.subassemblyCache.getUnchecked((Object)id);
    }

    @Override
    public void setLocale(String countryCode) {
        this.getDelegate().setLocale(countryCode);
    }

    @Override
    public String getText(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return null;
        }
        byte[] data = this.getTextData(id);
        return TextUtils.decompress(data);
    }

    @Override
    public byte[] getTextData(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return null;
        }
        return this.getDelegate().getTextData(id);
    }

    private class DataSessionCallback
    implements DataSessionListener {
        private DataSessionCallback() {
        }

        @Override
        public void dataAvailable() {
            log.info("dataAvailable()");
            for (DataSessionListener l : DataSessionClientService.this.listeners) {
                l.dataAvailable();
            }
        }
    }
}

