/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.jme3.app.Application;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import java.util.ArrayList;
import java.util.Objects;
import mythruna.character.BodyConfigIndex;
import mythruna.character.RaceTypeIndex;
import mythruna.client.net.LobbyState;
import mythruna.client.net.character.AppearancePage;
import mythruna.client.net.character.BackstoryPage;
import mythruna.client.net.character.CharacterEditorFunctions;
import mythruna.client.net.character.CharacterPage;
import mythruna.client.net.character.InfoPage;
import mythruna.client.net.character.MapEntity;
import mythruna.client.net.character.RaceSelectorPage;
import mythruna.client.net.character.StatsSelectorPage;
import mythruna.client.net.character.SummaryPage;
import mythruna.net.CharacterSession;
import mythruna.net.DataSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(CharacterEditor.class);
    private CharacterPage[] basePages = new CharacterPage[]{new InfoPage("docs/lobby.txt"), new RaceSelectorPage(), new StatsSelectorPage(), new BackstoryPage(), new AppearancePage(), new SummaryPage()};
    private CharacterPage[] pages;
    private LobbyState parent;
    private EntityData ed;
    private InputMapper inputMapper;
    private MapEntity character;
    private int currentIndex;
    private CharacterPage currentPage;
    private int changeCount;
    private DataSession dataSession;
    private RaceTypeIndex races;
    private BodyConfigIndex bodyConfigs;
    private CharacterSession characterSession;
    private Label title;
    private Container viewPanel;
    private ActionButton previousButton;
    private Container nextContainer;
    private ActionButton[] nextButtons;

    public CharacterEditor(LobbyState parent) {
        super((GuiLayout)new BorderLayout(), new ElementId("book"));
        this.parent = parent;
        this.ed = this.ed;
        this.inputMapper = GuiGlobals.getInstance().getInputMapper();
        CharacterEditorFunctions.initializeDefaultMappings(this.inputMapper);
        this.title = (Label)this.addChild((Node)new Label("Title Here", this.getElementId().child("title.label")), new Object[]{BorderLayout.Position.North});
        this.viewPanel = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.None)), new Object[]{BorderLayout.Position.East});
        this.viewPanel.setInsets(new Insets3f(0.0f, 30.0f, 0.0f, 0.0f));
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[]{BorderLayout.Position.South});
        this.previousButton = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Back", (Object)this, "previousPage")), new Object[0]);
        this.nextContainer = (Container)buttons.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        this.resetPageList();
    }

    public Application getApplication() {
        return this.parent.getApplication();
    }

    public void openViewport() {
        this.parent.getViewState().setEnabled(true);
    }

    public void closeViewport() {
        this.parent.getViewState().setEnabled(false);
    }

    public void resizeViewport(Panel view) {
        Vector3f pos = view.getWorldTranslation().clone();
        Vector3f scale = view.getWorldScale();
        Vector3f size = view.getSize().clone();
        size.x *= scale.x;
        size.y *= scale.y;
        pos.y -= size.y;
        this.parent.getViewState().setPosition(pos, size);
    }

    public Node getViewportRoot() {
        return this.parent.getViewState().getRoot();
    }

    public boolean isReadOnly() {
        return this.character == null || this.pages.length <= 1;
    }

    public DataSession getDataSession() {
        return this.dataSession;
    }

    public CharacterSession getCharacterSession() {
        return this.characterSession;
    }

    public EntityData getEntityData() {
        return this.ed;
    }

    public void setCharacter(MapEntity character) {
        if (this.character == character) {
            return;
        }
        this.character = character;
        for (CharacterPage page : this.basePages) {
            page.setCharacter(character);
        }
        this.changeCount = 0;
        this.resetPageList();
    }

    public MapEntity getCharacter() {
        return this.character;
    }

    public void setComponent(EntityComponent component) {
        if (this.character == null) {
            return;
        }
        Object original = this.getBaseComponent(component.getClass());
        if (Objects.equals(original, component)) {
            return;
        }
        log.info("character.set(" + component + ")");
        this.character.set(component);
        ++this.changeCount;
    }

    public <T extends EntityComponent> T getBaseComponent(Class<T> type) {
        if (this.character == null || this.character.getId() == null) {
            return null;
        }
        return (T)this.ed.getComponent(this.character.getId(), type);
    }

    public void initialize(CharacterSession characterSession, DataSession dataSession) {
        if (this.dataSession == dataSession) {
            return;
        }
        this.ed = this.parent.getEntityData();
        this.characterSession = characterSession;
        this.dataSession = dataSession;
        this.races = RaceTypeIndex.create(id -> dataSession.getText(id), (boolean)true);
        this.bodyConfigs = BodyConfigIndex.create(id -> dataSession.getText(id));
        for (CharacterPage page : this.basePages) {
            page.initialize(this);
        }
    }

    public RaceTypeIndex getRaces() {
        return this.races;
    }

    public BodyConfigIndex getBodyConfigs() {
        return this.bodyConfigs;
    }

    protected void nextPage() {
        log.info("nextPage()");
        ++this.currentIndex;
        this.resetPage();
    }

    protected void previousPage() {
        log.info("previousPage()");
        if (this.currentIndex == 0) {
            if (this.character != null && this.changeCount > 0) {
                if (this.character.getId() == null) {
                    this.parent.checkCancelEdit("Cancel character creation?");
                } else {
                    this.parent.checkCancelEdit("Cancel character updates?");
                }
            } else {
                this.parent.cancelEdit();
            }
            return;
        }
        --this.currentIndex;
        this.resetPage();
    }

    protected void saveCharacter() {
        this.parent.saveCharacter();
        this.changeCount = 0;
    }

    protected void doneEdit() {
        log.info("play");
        this.parent.saveEditAndPlay();
    }

    protected void resetPageList() {
        ArrayList<CharacterPage> list = new ArrayList<CharacterPage>();
        for (CharacterPage page : this.basePages) {
            if (!page.isEnabled()) continue;
            list.add(page);
        }
        this.pages = list.toArray(new CharacterPage[0]);
        this.resetPage();
    }

    protected void resetPage() {
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        } else if (this.currentIndex >= this.pages.length) {
            this.currentIndex = this.pages.length - 1;
        }
        if (this.currentPage == this.pages[this.currentIndex]) {
            return;
        }
        if (this.currentPage != null) {
            this.removeChild((Node)this.currentPage.getPanel());
            if (this.currentPage.getView() != null) {
                this.viewPanel.removeChild((Node)this.currentPage.getView());
            }
        }
        this.currentPage = this.pages[this.currentIndex];
        if (this.currentPage != null) {
            this.addChild((Node)this.currentPage.getPanel(), new Object[]{BorderLayout.Position.Center});
            if (this.currentPage.getView() != null) {
                this.viewPanel.addChild((Node)this.currentPage.getView(), new Object[0]);
            }
            this.title.setText(this.currentPage.getName());
            this.resetButtons();
        }
    }

    protected void resetButtons() {
        if (this.isReadOnly()) {
            this.previousButton.setCullHint(Spatial.CullHint.Always);
        } else {
            this.previousButton.setCullHint(Spatial.CullHint.Inherit);
        }
        this.nextContainer.clearChildren();
        if (this.currentPage != null) {
            Action[] next = this.currentPage.getNextActions();
            this.nextButtons = new ActionButton[next.length];
            for (int i = 0; i < this.nextButtons.length; ++i) {
                this.nextButtons[i] = new ActionButton(next[i]);
                this.nextContainer.addChild((Node)this.nextButtons[i], new Object[0]);
            }
        }
    }
}

