/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.jme3.util.SafeArrayList;
import com.simsilica.fx.geom.TruncatedDome;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.state.BlackboardState;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mythruna.client.Bloom;
import mythruna.client.PostProcessingState;
import mythruna.client.sound.CompositeAudio;
import mythruna.client.sound.DynamicAudio;
import mythruna.client.sound.SoundState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.WorldTimeState;
import mythruna.client.view.WorldViewState;
import mythruna.client.view.geom.Point;
import mythruna.client.view.geom.PointMesh;
import mythruna.sim.time.ScheduledSupplier;
import mythruna.sim.time.TimeInterval;
import mythruna.sim.time.WorldTimeSettingsSystem;
import mythruna.world.LocalEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(EnvironmentState.class);
    private WorldTimeState time;
    private WorldTimeSettingsSystem timeSettings;
    private float inclination = 1.5707964f - FastMath.atan2((float)1.0f, (float)0.4f);
    private Node environmentRoot = new Node("environment");
    private Node sky;
    private Geometry skyGeom;
    private Geometry groundGeom;
    private Vector2f skyEast = new Vector2f(0.0f, 0.0f);
    private Vector2f skyWest = new Vector2f(1.0f, 0.0f);
    private Vector2f skyNorthSouth = new Vector2f(0.0f, 0.0f);
    private ColorRGBA sunColor = new ColorRGBA(1.2f, 0.2f, 0.1f, 1.0f);
    private ColorRGBA sunHaloColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.75f);
    private ColorRGBA directionalLightColor = new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f);
    private Geometry sunCircleGeom;
    private Mesh sunCircleMesh;
    private Geometry sunHaloGeom;
    private Mesh sunHaloMesh;
    private ColorRGBA moonColor = new ColorRGBA(0.75f, 0.75f, 0.8f, 1.0f);
    private Geometry moonGeom;
    private Mesh moonMesh;
    private int moonPhase = -1;
    private float moonAdvance;
    private float moonTilt;
    private float moonPhaseAngle;
    private boolean moonRotationInvalid;
    private Vector4f moonClip = new Vector4f();
    private Geometry starGeom;
    private ColorRGBA starColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private Vector2f sunFade = new Vector2f(500.0f, 500.0f);
    private boolean starsEnabled = true;
    private FogSettings fogSettings = new FogSettings();
    private DirectionalLight directionalLight = new DirectionalLight(new Vector3f(0.0f, -1.0f, 0.0f), this.directionalLightColor);
    private ColorRGBA ambientColor = new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f);
    private AmbientLight ambient = new AmbientLight(this.ambientColor);
    private Bloom bloom = new Bloom();
    private double localOverrideCurrent = 0.0;
    private double localOverrideTarget = 0.0;
    private double localOverrideDelta = 1.0;
    private SafeArrayList<Consumer> localOverrides = new SafeArrayList(Consumer.class);
    private boolean localOverridesInvalid = false;
    float tod = 0.0f;
    float phase = 0.0f;
    public static final int SECS_PER_DAY = 86400;

    public EnvironmentState(WorldTimeSettingsSystem timeSettings) {
        this.timeSettings = timeSettings;
    }

    public Consumer<Double> addLocalOverride(Consumer<Double> override) {
        this.localOverrides.add(override);
        this.localOverridesInvalid = true;
        return override;
    }

    public void removeLocalOverride(Consumer<Double> override) {
        this.localOverrides.remove(override);
        this.localOverridesInvalid = true;
    }

    public void setLocalOverrideTarget(double localOverrideTarget) {
        this.localOverrideTarget = localOverrideTarget;
    }

    public double getLocalOverrideTarget() {
        return this.localOverrideTarget;
    }

    public void setStarsEnabled(boolean b) {
        if (this.starsEnabled == b) {
            return;
        }
        this.starsEnabled = b;
        if (this.starGeom != null) {
            this.resetStarVisibility();
        }
    }

    public boolean getStarsEnabled() {
        return this.starsEnabled;
    }

    public void setSunFade(Vector2f fade) {
        this.sunFade.set(fade);
    }

    public void setBloom(Bloom bloom) {
        if (this.bloom.equals(bloom)) {
            return;
        }
        this.bloom.set(bloom);
        bloom.apply(((PostProcessingState)this.getState(PostProcessingState.class, true)).getBloomFilter());
    }

    public Bloom getBloom() {
        return this.bloom;
    }

    public void setMoonColor(ColorRGBA moonColor) {
        this.moonColor.set(moonColor);
    }

    public ColorRGBA getMoonColor() {
        return this.moonColor;
    }

    public void setSunColor(ColorRGBA sunHaloColor) {
        this.sunColor.set(sunHaloColor);
    }

    public ColorRGBA getSunColor() {
        return this.sunColor;
    }

    public void setSunHaloColor(ColorRGBA sunHaloColor) {
        this.sunHaloColor.set(sunHaloColor);
    }

    public ColorRGBA getSunHaloColor() {
        return this.sunHaloColor;
    }

    public void setDirectionalLightColor(ColorRGBA directionalLightColor) {
        this.directionalLightColor.set(directionalLightColor);
        this.directionalLight.setColor(directionalLightColor);
    }

    public ColorRGBA getDirectionalLightColor() {
        return this.directionalLightColor;
    }

    public void setAmbientLightColor(ColorRGBA ambientColor) {
        this.ambientColor.set(ambientColor);
        this.ambient.setColor(ambientColor);
    }

    public ColorRGBA getAmbientLightColor() {
        return this.ambientColor;
    }

    public void setSkyEast(Vector2f skyEast) {
        this.skyEast.set(skyEast);
    }

    public Vector2f getSkyEast() {
        return this.skyEast;
    }

    public void setSkyWest(Vector2f skyWest) {
        this.skyWest.set(skyWest);
    }

    public Vector2f getSkyWest() {
        return this.skyWest;
    }

    public void setSkyNorthSouth(Vector2f skyNorthSouth) {
        this.skyNorthSouth.set(skyNorthSouth);
    }

    public Vector2f getSkyNorthSouth() {
        return this.skyNorthSouth;
    }

    public FogSettings getFogSettings() {
        return this.fogSettings;
    }

    public void setStarColor(ColorRGBA starColor) {
        this.starColor.set(starColor);
        this.resetStarVisibility();
    }

    protected void resetStarVisibility() {
        if (this.starGeom == null) {
            return;
        }
        Spatial.CullHint ch = !this.starsEnabled ? Spatial.CullHint.Always : (this.starColor.a == 0.0f ? Spatial.CullHint.Always : Spatial.CullHint.Inherit);
        if (this.starGeom.getCullHint() != ch) {
            this.starGeom.setCullHint(ch);
        }
    }

    public ColorRGBA getStarColor() {
        return this.starColor;
    }

    public void setMoonPhase(int moonPhase) {
        if (this.moonPhase == (moonPhase %= 25)) {
            return;
        }
        this.moonPhase = moonPhase;
        int xCell = moonPhase / 5;
        int yCell = moonPhase % 5;
        log.info("phase:" + moonPhase + "  xCell:" + xCell + "  yCell:" + yCell);
        float u1 = (float)xCell * 0.2f;
        float v1 = (float)yCell * 0.2f;
        float u2 = u1 + 0.2f;
        float v2 = v1 + 0.2f;
        this.moonMesh.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{u1, v1, u2, v1, u2, v2, u1, v2});
    }

    public int getMoonPhase() {
        return this.moonPhase;
    }

    public void setMoonPhaseAngle(float angle) {
        if (this.moonPhaseAngle == angle) {
            return;
        }
        this.moonRotationInvalid = true;
        this.moonPhaseAngle = angle;
    }

    public void setMoonTilt(float angle) {
        if (this.moonTilt == angle) {
            return;
        }
        this.moonRotationInvalid = true;
        this.moonTilt = angle;
    }

    public void setMoonAdvance(float angle) {
        if (this.moonAdvance == angle) {
            return;
        }
        this.moonRotationInvalid = true;
        this.moonAdvance = angle;
    }

    protected void recalculateMoonRotation() {
        if (!this.moonRotationInvalid) {
            return;
        }
        this.moonRotationInvalid = false;
        Quaternion invTilt = new Quaternion().fromAngles(-this.inclination, 0.0f, 0.0f);
        Quaternion incTilt = new Quaternion().fromAngles(this.inclination, 0.0f, 0.0f);
        Quaternion advance = new Quaternion().fromAngles(0.0f, 0.0f, this.moonAdvance);
        Quaternion phase = new Quaternion().fromAngles(0.0f, this.moonPhaseAngle, 0.0f);
        Quaternion tilt = new Quaternion().fromAngles(this.moonTilt, 0.0f, 0.0f);
        Quaternion q = advance.mult(phase).mult(tilt);
        this.moonGeom.setLocalRotation(q);
    }

    protected void initialize(Application app) {
        Geometry geom;
        this.time = (WorldTimeState)this.getState(WorldTimeState.class, true);
        ((BlackboardState)this.getState(BlackboardState.class)).set(FogSettings.class, (Object)this.fogSettings);
        this.fogSettings.setFogColor(new ColorRGBA(0.7f, 0.7f, 0.9f, 1.0f));
        this.fogSettings.setFogDistance(3072);
        float domeInnerRadius = 0.0f;
        float domeOuterRadius = 8000.0f;
        TruncatedDome domeMesh = new TruncatedDome(domeInnerRadius, domeOuterRadius, 8, 2, true);
        this.skyGeom = new Geometry("SkyDome", (Mesh)domeMesh);
        log.info("dome bounds:" + this.skyGeom.getWorldBound());
        Material domeMaterial = new Material(app.getAssetManager(), "MatDefs/SkyDome.j3md");
        domeMaterial.setColor("Color", ColorRGBA.Blue);
        Texture skyGradient = app.getAssetManager().loadTexture("Environment/sky-colors-64.png");
        domeMaterial.setTexture("SkyGradient", skyGradient);
        domeMaterial.setVector2("East", this.skyEast);
        domeMaterial.setVector2("West", this.skyWest);
        domeMaterial.setVector2("NorthSouth", this.skyNorthSouth);
        this.skyGeom.setMaterial(domeMaterial);
        this.skyGeom.setQueueBucket(RenderQueue.Bucket.Sky);
        log.info("dome bounds:" + this.skyGeom.getWorldBound());
        this.skyGeom.setModelBound((BoundingVolume)new BoundingSphere(Float.POSITIVE_INFINITY, Vector3f.ZERO));
        this.environmentRoot.attachChild((Spatial)this.skyGeom);
        this.groundGeom = new Geometry("GroundDome", (Mesh)domeMesh);
        Material groundMaterial = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        groundMaterial.setColor("Color", this.fogSettings.getFogColor());
        this.groundGeom.setMaterial(groundMaterial);
        this.groundGeom.setQueueBucket(RenderQueue.Bucket.Sky);
        this.groundGeom.rotate((float)Math.PI, 0.0f, 0.0f);
        this.groundGeom.setModelBound((BoundingVolume)new BoundingSphere(Float.POSITIVE_INFINITY, Vector3f.ZERO));
        this.sky = new Node("sky");
        this.environmentRoot.attachChild((Spatial)this.sky);
        this.environmentRoot.attachChild((Spatial)this.groundGeom);
        Random rand = new Random(((WorldViewState)this.getState(WorldViewState.class)).getWorldSeed());
        int count = 1000;
        Point[] points = new Point[count];
        double range = 500.0;
        int test = 0;
        for (int i = 0; i < count; ++i) {
            double z;
            double y;
            Point p;
            points[i] = p = new Point();
            double x = rand.nextGaussian();
            double dist = Math.sqrt(x * x + (y = rand.nextGaussian()) * y + (z = rand.nextGaussian()) * z);
            if (dist == 0.0) {
                x = 1.0;
            } else {
                x /= dist;
                y /= dist;
                z /= dist;
            }
            p.x = (float)(x * range);
            p.y = (float)(y * range);
            p.z = (float)(z * range);
            p.size = (float)(rand.nextDouble() + 0.01);
            p.color = -1;
            int xCell = test % 15;
            p.u1 = (float)xCell * 0.06666667f;
            p.v1 = 0.0f;
            p.u2 = p.u1 + 0.06666667f;
            p.v2 = 1.0f;
            ++test;
        }
        PointMesh pm = new PointMesh(points);
        pm.updateBound();
        this.starGeom = geom = new Geometry("stars", (Mesh)pm);
        Material mat = new Material(app.getAssetManager(), "MatDefs/SkyPoints.j3md");
        mat.setBoolean("PointSprite", true);
        Texture t = app.getAssetManager().loadTexture("Textures/stars.png");
        mat.setTexture("Texture", t);
        mat.setColor("Color", this.starColor);
        mat.setVector4("Clip", this.moonClip);
        mat.setVector2("SunFade", this.sunFade);
        geom.setQueueBucket(RenderQueue.Bucket.Sky);
        float C = app.getCamera().getProjectionMatrix().m00;
        mat.setFloat("Quadratic", C *= (float)app.getCamera().getWidth() * 0.5f);
        geom.setMaterial(mat);
        this.sky.attachChild((Spatial)geom);
        this.sunHaloMesh = new Quad(1.0f, 1.0f);
        float sunHaloRadius = 100.0f;
        float sunDistance = 500.0f;
        this.sunHaloMesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{sunDistance, -sunHaloRadius, -sunHaloRadius, sunDistance, -sunHaloRadius, sunHaloRadius, sunDistance, sunHaloRadius, sunHaloRadius, sunDistance, sunHaloRadius, -sunHaloRadius});
        this.sunHaloMesh.updateBound();
        this.sunHaloGeom = geom = new Geometry("sunHalo", this.sunHaloMesh);
        mat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        t = app.getAssetManager().loadTexture("Environment/sun-256.png");
        mat.setTexture("ColorMap", t);
        mat.setColor("Color", this.sunHaloColor);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Sky);
        this.sky.attachChild((Spatial)geom);
        this.sunCircleMesh = new Quad(1.0f, 1.0f);
        float sunCircleRadius = 20.0f;
        float sunCircleDistance = 490.0f;
        this.sunCircleMesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{sunCircleDistance, -sunCircleRadius, -sunCircleRadius, sunCircleDistance, -sunCircleRadius, sunCircleRadius, sunCircleDistance, sunCircleRadius, sunCircleRadius, sunCircleDistance, sunCircleRadius, -sunCircleRadius});
        this.sunCircleMesh.updateBound();
        this.sunCircleGeom = geom = new Geometry("sun", this.sunCircleMesh);
        mat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        t = app.getAssetManager().loadTexture("Environment/sun-circle.png");
        mat.setTexture("ColorMap", t);
        mat.setColor("Color", this.sunColor);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.setFloat("AlphaDiscardThreshold", 0.5f);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Sky);
        this.sky.attachChild((Spatial)geom);
        Quad q = new Quad(1.0f, 1.0f);
        this.moonMesh = q;
        float moonRadius = 30.0f;
        float distance = 500.0f;
        q.setBuffer(VertexBuffer.Type.Position, 3, new float[]{-distance, moonRadius, -moonRadius, -distance, moonRadius, moonRadius, -distance, -moonRadius, moonRadius, -distance, -moonRadius, -moonRadius});
        q.updateBound();
        this.moonGeom = geom = new Geometry("moon", (Mesh)q);
        mat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        t = app.getAssetManager().loadTexture("Environment/moon-phases.png");
        mat.setTexture("ColorMap", t);
        mat.setColor("Color", this.moonColor);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.AlphaAdditive);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Sky);
        this.sky.attachChild((Spatial)geom);
        this.setMoonPhase(19);
        this.timeSettings.addSetting(wt -> {
            double gameTime = this.time.getGameTime();
            double tod = gameTime % 86400.0;
            double timeOffset = 0.2916666666666667;
            double rads = (tod / 86400.0 - timeOffset) * Math.PI * 2.0;
            Quaternion tilt = new Quaternion().fromAngles(this.inclination, 0.0f, 0.0f);
            Quaternion rot = new Quaternion().fromAngles(0.0f, 0.0f, (float)rads);
            this.sky.setLocalRotation(tilt.mult(rot));
        });
        this.attachLights();
        LocalEnvironment localEnv = ((AvatarState)this.getState(AvatarState.class, true)).getLocalEnvironment();
        Supplier<Double> outsideVolume = () -> {
            int sun = localEnv.getSun();
            double factor = (double)Math.max(0, sun - 5) / 10.0;
            return factor * 1.5;
        };
        CompositeAudio outside = new CompositeAudio(outsideVolume);
        ((SoundState)this.getState(SoundState.class)).getAmbientSound().addSource(outside);
        Supplier<Double> forestVolume = () -> localEnv.getForestFactor();
        Supplier<Double> notForestVolume = () -> {
            double result = 1.0 - localEnv.getForestFactor();
            if (result < 0.05) {
                result = 0.05;
            }
            return result;
        };
        CompositeAudio notForestSounds = new CompositeAudio(notForestVolume);
        outside.addChild(notForestSounds);
        ScheduledSupplier windTime = new ScheduledSupplier(this.time.getWorldTimeSource(), new TimeInterval(0, 0, 1));
        windTime.at("0:00", Double.valueOf(0.1)).at("5:00", Double.valueOf(0.1)).at("7:00", Double.valueOf(0.3)).at("17:00", Double.valueOf(0.3)).at("18:00", Double.valueOf(0.4)).at("19:00", Double.valueOf(0.5)).at("20:00", Double.valueOf(0.3)).at("21:00", Double.valueOf(0.1)).at("22:00", Double.valueOf(0.1));
        notForestSounds.addChild(new DynamicAudio((SoundState)this.getState(SoundState.class), "Sounds/Ambient/Wind, Heavy, Blowing Snow.ogg", (Supplier<Double>)windTime));
        CompositeAudio forestSounds = new CompositeAudio(forestVolume);
        outside.addChild(forestSounds);
        ScheduledSupplier dayTime = new ScheduledSupplier(this.time.getWorldTimeSource(), new TimeInterval(0, 0, 1));
        dayTime.at("0:00", Double.valueOf(0.0)).at("5:00", Double.valueOf(0.0)).at("6:00", Double.valueOf(1.0)).at("18:00", Double.valueOf(1.0)).at("19:00", Double.valueOf(0.0));
        forestSounds.addChild(new DynamicAudio((SoundState)this.getState(SoundState.class), "Sounds/Ambient/Quiet_Forest_Morning_Loop-low.ogg", (Supplier<Double>)dayTime));
        ScheduledSupplier nightTime = new ScheduledSupplier(this.time.getWorldTimeSource(), new TimeInterval(0, 0, 1));
        nightTime.at("0:00", Double.valueOf(1.0)).at("5:00", Double.valueOf(1.0)).at("6:00", Double.valueOf(0.0)).at("20:00", Double.valueOf(0.0)).at("21:00", Double.valueOf(1.0));
        forestSounds.addChild(new DynamicAudio((SoundState)this.getState(SoundState.class), "Sounds/Ambient/Crickets,_Night,_Forest_Edge,_Chirpy,_Steady-low.ogg", (Supplier<Double>)nightTime));
        ScheduledSupplier eveningTime = new ScheduledSupplier(this.time.getWorldTimeSource(), new TimeInterval(0, 0, 1));
        eveningTime.at("0:00", Double.valueOf(0.0)).at("17:00", Double.valueOf(0.0)).at("18:00", Double.valueOf(0.4)).at("19:00", Double.valueOf(0.8)).at("20:00", Double.valueOf(0.4)).at("21:00", Double.valueOf(0.0));
        forestSounds.addChild(new DynamicAudio((SoundState)this.getState(SoundState.class), "Sounds/Ambient/wind-low.ogg", (Supplier<Double>)eveningTime));
        ScheduledSupplier morningTime = new ScheduledSupplier(this.time.getWorldTimeSource(), new TimeInterval(0, 0, 1));
        morningTime.at("0:00", Double.valueOf(0.0)).at("5:00", Double.valueOf(-5.0)).at("6:00", Double.valueOf(1.0)).at("7:00", Double.valueOf(0.0));
        forestSounds.addChild(new DynamicAudio((SoundState)this.getState(SoundState.class), "Sounds/Ambient/Pretty_Forest_Birds_Loop_01-low.ogg", (Supplier<Double>)morningTime));
        ScheduledSupplier transTime = new ScheduledSupplier(this.time.getWorldTimeSource(), new TimeInterval(0, 0, 1));
        transTime.at("0:00", Double.valueOf(0.0)).at("4:00", Double.valueOf(0.0)).at("5:00", Double.valueOf(1.0)).at("6:00", Double.valueOf(0.5)).at("7:00", Double.valueOf(0.0)).at("19:00", Double.valueOf(0.0)).at("20:00", Double.valueOf(1.0)).at("21:00", Double.valueOf(-2.0)).at("22:00", Double.valueOf(0.0));
        forestSounds.addChild(new DynamicAudio((SoundState)this.getState(SoundState.class), "Sounds/Ambient/Meadow___Crickets___Birds___Crow-low.ogg", (Supplier<Double>)transTime));
    }

    public Quaternion getSunRotation() {
        return this.sunCircleGeom.getWorldRotation();
    }

    public Quaternion getMoonRotation() {
        return this.moonGeom.getWorldRotation();
    }

    public void setLightDirection(Vector3f dir) {
        this.directionalLight.setDirection(dir);
    }

    protected void attachLights() {
        Node rootNode = ((SimpleApplication)this.getApplication()).getRootNode();
        rootNode.addLight((Light)this.directionalLight);
        rootNode.addLight((Light)this.ambient);
    }

    protected void detachLights() {
        Node rootNode = ((SimpleApplication)this.getApplication()).getRootNode();
        rootNode.removeLight((Light)this.directionalLight);
        rootNode.removeLight((Light)this.ambient);
    }

    protected void cleanup(Application app) {
        this.detachLights();
    }

    protected void onEnable() {
        Node rootNode = ((SimpleApplication)this.getApplication()).getRootNode();
        rootNode.attachChild((Spatial)this.environmentRoot);
        this.bloom.apply(((PostProcessingState)this.getState(PostProcessingState.class, true)).getBloomFilter());
    }

    public void update(float tpf) {
        this.sky.setLocalTranslation(this.getApplication().getCamera().getLocation().add(0.0f, 100.0f, 0.0f));
        this.skyGeom.setLocalTranslation(this.getApplication().getCamera().getLocation());
        this.groundGeom.setLocalTranslation(this.getApplication().getCamera().getLocation());
        this.recalculateMoonRotation();
        Vector3f moonPos = this.moonGeom.getWorldRotation().mult(new Vector3f(-500.0f, 0.0f, 0.0f));
        moonPos.addLocal(this.getApplication().getCamera().getLocation().add(0.0f, 100.0f, 0.0f));
        this.moonClip.set(moonPos.x, moonPos.y, moonPos.z, 30.0f);
        if (this.localOverrideCurrent > this.localOverrideTarget) {
            this.localOverrideCurrent = Math.max(this.localOverrideTarget, this.localOverrideCurrent - this.localOverrideDelta * (double)tpf);
        } else if (this.localOverrideCurrent < this.localOverrideTarget) {
            this.localOverrideCurrent = Math.min(this.localOverrideTarget, this.localOverrideCurrent + this.localOverrideDelta * (double)tpf);
        }
        this.updateLocalOverrides();
    }

    protected void onDisable() {
        this.environmentRoot.removeFromParent();
    }

    protected void updateLocalOverrides() {
        for (Consumer c : (Consumer[])this.localOverrides.getArray()) {
            c.accept(this.localOverrideCurrent);
        }
        this.localOverridesInvalid = false;
    }
}

