/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.objects;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.fbx.SceneLoader;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.objects.FbxObject;
import com.jme3.scene.plugins.fbx.objects.FbxTexture;

public class FbxMaterial
extends FbxObject {
    public String shadingModel = "phong";
    public Vector3f ambientColor = new Vector3f(0.2f, 0.2f, 0.2f);
    public float ambientFactor = 1.0f;
    public Vector3f diffuseColor = new Vector3f(0.8f, 0.8f, 0.8f);
    public float diffuseFactor = 1.0f;
    public Vector3f specularColor = new Vector3f(0.2f, 0.2f, 0.2f);
    public float specularFactor = 1.0f;
    public float shininessExponent = 1.0f;
    public Material material;

    public FbxMaterial(SceneLoader scene, FbxElement element) {
        super(scene, element);
        if (this.type.equals("")) {
            for (FbxElement e : element.children) {
                if (e.id.equals("ShadingModel")) {
                    this.shadingModel = (String)e.properties.get(0);
                    continue;
                }
                if (!e.id.equals("Properties70")) continue;
                for (FbxElement e2 : e.children) {
                    String propName;
                    if (!e2.id.equals("P")) continue;
                    switch (propName = (String)e2.properties.get(0)) {
                        case "AmbientColor": {
                            double x = (Double)e2.properties.get(4);
                            double y = (Double)e2.properties.get(5);
                            double z = (Double)e2.properties.get(6);
                            this.ambientColor.set((float)x, (float)y, (float)z);
                            break;
                        }
                        case "AmbientFactor": {
                            double x = (Double)e2.properties.get(4);
                            this.ambientFactor = (float)x;
                            break;
                        }
                        case "DiffuseColor": {
                            double x = (Double)e2.properties.get(4);
                            double y = (Double)e2.properties.get(5);
                            double z = (Double)e2.properties.get(6);
                            this.diffuseColor.set((float)x, (float)y, (float)z);
                            break;
                        }
                        case "DiffuseFactor": {
                            double x = (Double)e2.properties.get(4);
                            this.diffuseFactor = (float)x;
                            break;
                        }
                        case "SpecularColor": {
                            double x = (Double)e2.properties.get(4);
                            double y = (Double)e2.properties.get(5);
                            double z = (Double)e2.properties.get(6);
                            this.specularColor.set((float)x, (float)y, (float)z);
                            break;
                        }
                        case "Shininess": 
                        case "ShininessExponent": {
                            double x = (Double)e2.properties.get(4);
                            this.shininessExponent = (float)x;
                        }
                    }
                }
            }
            this.material = this.createMaterial();
        }
    }

    @Override
    public void link(FbxObject otherObject, String propertyName) {
        if (otherObject instanceof FbxTexture) {
            FbxTexture tex = (FbxTexture)otherObject;
            if (tex.texture == null || this.material == null) {
                return;
            }
            switch (propertyName) {
                case "DiffuseColor": {
                    this.material.setTexture("DiffuseMap", tex.texture);
                    this.material.setColor("Diffuse", ColorRGBA.White);
                    break;
                }
                case "SpecularColor": {
                    this.material.setTexture("SpecularMap", tex.texture);
                    this.material.setColor("Specular", ColorRGBA.White);
                    break;
                }
                case "NormalMap": {
                    this.material.setTexture("NormalMap", tex.texture);
                }
            }
        }
    }

    private Material createMaterial() {
        Material m = new Material(this.scene.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        m.setName(this.name);
        this.ambientColor.multLocal(this.ambientFactor);
        this.diffuseColor.multLocal(this.diffuseFactor);
        this.specularColor.multLocal(this.specularFactor);
        m.setColor("Ambient", new ColorRGBA(this.ambientColor.x, this.ambientColor.y, this.ambientColor.z, 1.0f));
        m.setColor("Diffuse", new ColorRGBA(this.diffuseColor.x, this.diffuseColor.y, this.diffuseColor.z, 1.0f));
        m.setColor("Specular", new ColorRGBA(this.specularColor.x, this.specularColor.y, this.specularColor.z, 1.0f));
        m.setFloat("Shininess", this.shininessExponent);
        m.setBoolean("UseMaterialColors", true);
        m.setFloat("AlphaDiscardThreshold", 0.5f);
        m.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        return m;
    }
}

