/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.simsilica.es.EntityId;
import com.simsilica.es.StringType;
import com.simsilica.es.sql.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldTypes {
    private static final Map<String, String> dbTypes = new HashMap<String, String>();

    public static List<FieldType> getFieldTypes(Class type) {
        return FieldTypes.getFieldTypes(null, type);
    }

    protected static List<FieldType> getFieldTypes(String prefix, Class type) {
        Field[] fields;
        ArrayList<FieldType> results = new ArrayList<FieldType>();
        for (Field f : fields = type.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            Class<?> ft = f.getType();
            if (ft.isPrimitive()) {
                results.add(new PrimitiveField(prefix, f));
                continue;
            }
            if (EntityId.class.isAssignableFrom(ft)) {
                results.add(new EntityIdField(prefix, f));
                continue;
            }
            if (String.class.equals(ft)) {
                results.add(new StringField(prefix, f));
                continue;
            }
            if (Enum.class.isAssignableFrom(ft)) {
                throw new UnsupportedOperationException("Enum types are not supported.");
            }
            results.add(new ObjectField(prefix, f));
        }
        return results;
    }

    static {
        dbTypes.put("int", "INTEGER");
        dbTypes.put("long", "BIGINT");
        dbTypes.put("short", "SMALLINT");
        dbTypes.put("byte", "TINYINT");
        dbTypes.put("float", "FLOAT");
        dbTypes.put("double", "DOUBLE");
    }

    protected static class PrimitiveField
    implements FieldType {
        private String name;
        private String dbFieldName;
        private Field field;

        public PrimitiveField(Field field) {
            this(null, field);
        }

        public PrimitiveField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            this.dbFieldName = prefix == null ? this.name : prefix + this.name;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            String s = this.field.getType().getSimpleName();
            String result = (String)dbTypes.get(s);
            if (result != null) {
                return result;
            }
            return s;
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            defs.put(prefix + this.dbFieldName.toUpperCase(), this);
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            fields.add(prefix + this.dbFieldName);
        }

        @Override
        public Object toDbValue(Object o) {
            return o;
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                ps.setObject(index++, this.field.get(object));
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        protected Object cast(Number n, Class c) {
            if (c == Float.TYPE) {
                return Float.valueOf(n.floatValue());
            }
            if (c == Byte.TYPE) {
                return n.byteValue();
            }
            if (c == Short.TYPE) {
                return n.shortValue();
            }
            if (c == Integer.TYPE) {
                return n.intValue();
            }
            return n;
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                Object value = rs.getObject(index++);
                if (value instanceof Number) {
                    value = this.cast((Number)value, this.getType());
                }
                this.field.set(target, value);
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            Object value;
            if ((value = rs.getObject(columnIndex++)) instanceof Number) {
                value = this.cast((Number)value, this.getType());
            }
            store[storeIndex] = value;
            return columnIndex;
        }

        public String toString() {
            if (this.dbFieldName != this.name) {
                return this.name + "/" + this.dbFieldName + ":" + this.getType();
            }
            return this.getFieldName() + ":" + this.getType();
        }
    }

    protected static class ObjectField
    implements FieldType {
        private String name;
        private Field field;
        private FieldType[] fields;

        public ObjectField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            List<FieldType> list = FieldTypes.getFieldTypes(prefix, field.getType());
            this.fields = new FieldType[list.size()];
            this.fields = list.toArray(this.fields);
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            return "Undefined";
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            prefix = prefix + this.name + "_";
            for (FieldType t : this.fields) {
                t.addFieldDefinitions(prefix.toUpperCase(), defs);
            }
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            prefix = prefix + this.name + "_";
            for (FieldType t : this.fields) {
                t.addFields(prefix, fields);
            }
        }

        @Override
        public Object toDbValue(Object o) {
            return o;
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                Object subValue = this.field.get(object);
                for (FieldType t : this.fields) {
                    index = t.store(subValue, ps, index);
                }
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                Object subValue = this.field.getType().newInstance();
                for (FieldType t : this.fields) {
                    index = t.load(subValue, rs, index);
                }
                this.field.set(target, subValue);
                return index;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            try {
                Object subValue = this.field.getType().newInstance();
                for (FieldType t : this.fields) {
                    columnIndex = t.load(subValue, rs, columnIndex);
                }
                store[storeIndex] = subValue;
                return columnIndex;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        public String toString() {
            return this.getFieldName() + ":" + this.getType() + "{" + Arrays.asList(this.fields) + "}";
        }
    }

    protected static class StringField
    implements FieldType {
        private String name;
        private String dbFieldName;
        private Field field;
        private int maxLength;

        public StringField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            this.dbFieldName = prefix == null ? this.name : prefix + this.name;
            StringType meta = field.getAnnotation(StringType.class);
            this.maxLength = meta != null ? meta.maxLength() : 512;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            return "VARCHAR(" + this.maxLength + ")";
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            defs.put(prefix + this.dbFieldName.toUpperCase(), this);
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            fields.add(prefix + this.dbFieldName);
        }

        @Override
        public Object toDbValue(Object o) {
            return o;
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                ps.setObject(index++, this.field.get(object));
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                this.field.set(target, rs.getObject(index++));
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            store[storeIndex] = rs.getObject(columnIndex++);
            return columnIndex;
        }

        public String toString() {
            if (this.dbFieldName != this.name) {
                return this.name + "/" + this.dbFieldName + ":" + this.getType();
            }
            return this.getFieldName() + ":" + this.getType();
        }
    }

    protected static class EntityIdField
    implements FieldType {
        private String name;
        private String dbFieldName;
        private Field field;

        public EntityIdField(Field field) {
            this(null, field);
        }

        public EntityIdField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            this.dbFieldName = prefix == null ? this.name : prefix + this.name;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            String result = (String)dbTypes.get("long");
            return result;
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            defs.put(prefix + this.dbFieldName.toUpperCase(), this);
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            fields.add(prefix + this.dbFieldName);
        }

        @Override
        public Object toDbValue(Object o) {
            if (o == null) {
                return null;
            }
            return ((EntityId)o).getId();
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                EntityId entityId = (EntityId)this.field.get(object);
                if (entityId != null) {
                    ps.setObject(index++, entityId.getId());
                } else {
                    ps.setObject(index++, null);
                }
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                Number value = (Number)rs.getObject(index++);
                if (value != null) {
                    this.field.set(target, new EntityId(value.longValue()));
                } else {
                    this.field.set(target, null);
                }
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            Number value;
            store[storeIndex] = (value = (Number)rs.getObject(columnIndex++)) != null ? new EntityId(value.longValue()) : null;
            return columnIndex;
        }

        public String toString() {
            if (this.dbFieldName != this.name) {
                return this.name + "/" + this.dbFieldName + ":" + this.getType();
            }
            return this.getFieldName() + ":" + this.getType();
        }
    }
}

