/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTypeIndexProtocol
implements ObjectProtocol<TreeTypeIndex> {
    static Logger log = LoggerFactory.getLogger(TreeTypeIndexProtocol.class);
    private int protocolVersion = 1;

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TreeTypeIndex data, BitOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bOut);){
            oos.writeObject(data);
        }
        byte[] bytes = bOut.toByteArray();
        out.writeBits(bytes.length, 32);
        for (byte b : bOut.toByteArray()) {
            out.writeBits((int)b, 8);
        }
    }

    @Override
    public TreeTypeIndex read(BitInputStream in) throws IOException {
        int size = in.readBits(32);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)in.readBits(8);
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = new ObjectInputStream(bIn);){
            TreeTypeIndex treeTypeIndex = (TreeTypeIndex)ois.readObject();
            return treeTypeIndex;
        }
    }
}

