/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractSphereMorphology;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SphereFill
extends AbstractSphereMorphology {
    static Logger log = LoggerFactory.getLogger(SphereFill.class);
    private int blockFill;
    private byte terrainFill;

    public SphereFill(Vec3i center, int radius, int blockFill, byte terrainFill) {
        super(center, radius);
        this.blockFill = blockFill;
        this.terrainFill = terrainFill;
    }

    public int getBlockFill() {
        return this.blockFill;
    }

    public byte getTerrainFill() {
        return this.terrainFill;
    }

    protected double calculateY(double x, double z) {
        Vec3i center = this.getCenter();
        double r = this.getRadius();
        double rSq = r * r;
        double ySq = rSq - (x -= (double)center.x) * x - (z -= (double)center.z) * z;
        if (ySq < 0.0) {
            return Double.NaN;
        }
        double y = Math.sqrt(ySq);
        return y + (double)center.y;
    }

    @Override
    public boolean morph(Tile tile, Random rand) {
        log.info("morph(" + tile + ")");
        TerrainImage terrain = tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        int size = terrain.getSize();
        int skip = 1024 / size;
        Vec3i tileMin = tile.getTileId().getWorld(null);
        Vec3i tileMax = tileMin.add(1024, 0, 1024);
        Vec3i center = this.getCenter();
        int radius = this.getRadius();
        int xMin = (Math.max(tileMin.x, center.x - radius) - tileMin.x) / skip;
        int xMax = (Math.min(tileMax.x, center.x + radius + 1) - tileMin.x) / skip;
        int zMin = (Math.max(tileMin.z, center.z - radius) - tileMin.z) / skip;
        int zMax = (Math.min(tileMax.z, center.z + radius + 1) - tileMin.z) / skip;
        boolean changed = false;
        for (int x = xMin; x < xMax; ++x) {
            for (int z = zMin; z < zMax; ++z) {
                int elevation;
                double y = this.calculateY(tileMin.x + x * skip, tileMin.z + z * skip);
                if (Double.isNaN(y) || (elevation = (int)y) <= terrain.getElevation(x, z)) continue;
                terrain.setElevation(x, z, (short)elevation);
                terrain.setType(x, z, this.terrainFill);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        Vec3i colMin = colData.getColumnId().getWorld(null);
        Vec3i colMax = colMin.add(COLUMN_SIZE, colData.getCeiling(), COLUMN_SIZE);
        Vec3i center = this.getCenter();
        int radius = this.getRadius();
        int xMin = Math.max(colMin.x, center.x - radius) - colMin.x;
        int xMax = Math.min(colMax.x, center.x + radius + 1) - colMin.x;
        int yMin = Math.max(colMin.y, center.y - radius) - colMin.y;
        int yMax = Math.min(colMax.y, center.y + radius + 1) - colMin.y;
        int zMin = Math.max(colMin.z, center.z - radius) - colMin.z;
        int zMax = Math.min(colMax.z, center.z + radius + 1) - colMin.z;
        int xCenter = center.x - colMin.x;
        int yCenter = center.y - colMin.y;
        int zCenter = center.z - colMin.z;
        int rSq = radius * radius;
        boolean changed = false;
        for (int y = yMin; y < yMax; ++y) {
            int layer = y / 32;
            int yBase = layer * 32;
            LeafData leaf = colData.getLeafs()[layer];
            int j = y - yBase;
            for (int i = xMin; i < xMax; ++i) {
                for (int k = zMin; k < zMax; ++k) {
                    int dx = i - xCenter;
                    int dy = y - yCenter;
                    int dz = k - zCenter;
                    double dSq = dx * dx + dy * dy + dz * dz;
                    if (!(dSq <= (double)rSq)) continue;
                    leaf.setCell(i, j, k, this.blockFill);
                    changed = true;
                }
            }
        }
        return changed;
    }
}

