/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.util;

import com.simsilica.util.Log4j2LevelConverter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAdapter
extends Handler {
    private final Set<String> seen = new HashSet<String>();
    private static final List<java.util.logging.Logger> keepAlive = new ArrayList<java.util.logging.Logger>();

    public static void initialize() {
        java.util.logging.Logger root = LogManager.getLogManager().getLogger("");
        for (Handler h : root.getHandlers()) {
            root.removeHandler(h);
        }
        LogAdapter adapter = new LogAdapter();
        root.addHandler(adapter);
        Logger rootLog = LoggerFactory.getLogger((String)"ROOT");
        if (rootLog != null) {
            System.out.println("Setting root JUL log level to:" + LogAdapter.getJulLevel(rootLog));
            root.setLevel(LogAdapter.getJulLevel(rootLog));
        }
        try {
            Class.forName("org.apache.logging.log4j.core.config.LoggerConfig");
            Log4j2LevelConverter.convert();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    protected static String foldMessage(LogRecord record) {
        String msg = record.getMessage();
        Object[] parms = record.getParameters();
        if (parms != null && parms.length > 0) {
            msg = MessageFormat.format(msg, record.getParameters());
        }
        return msg;
    }

    protected static Level getJulLevel(Logger log) {
        if (log.isTraceEnabled()) {
            return Level.FINER;
        }
        if (log.isDebugEnabled()) {
            return Level.FINE;
        }
        if (log.isInfoEnabled()) {
            return Level.INFO;
        }
        if (log.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (log.isErrorEnabled()) {
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    @Override
    public void publish(LogRecord record) {
        String message = LogAdapter.foldMessage(record);
        String logger = record.getLoggerName();
        if (logger == null) {
            logger = "";
        }
        Level lvl = record.getLevel();
        Logger log = LoggerFactory.getLogger((String)logger);
        if (lvl != Level.OFF) {
            if (lvl == Level.CONFIG) {
                log.info(message, record.getThrown());
            } else if (lvl == Level.FINE) {
                log.debug(message, record.getThrown());
            } else if (lvl == Level.FINER) {
                log.trace(message, record.getThrown());
            } else if (lvl == Level.FINEST) {
                log.trace(message, record.getThrown());
            } else if (lvl == Level.INFO) {
                log.info(message, record.getThrown());
            } else if (lvl == Level.SEVERE) {
                log.error(message, record.getThrown());
            } else if (lvl == Level.WARNING) {
                log.warn(message, record.getThrown());
            } else {
                log.info(message, record.getThrown());
            }
        }
    }
}

