/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.FluidName;
import com.simsilica.mblock.FluidType;
import com.simsilica.mblock.io.UpdateableData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidTypeData
implements UpdateableData<FluidTypeData> {
    public static final long formatVersion = 42L;
    static Logger log = LoggerFactory.getLogger(FluidTypeData.class);
    public FluidType[] types;

    public FluidTypeData() {
    }

    public FluidTypeData(FluidType[] types) {
        this.types = types;
    }

    @Override
    public boolean update(FluidTypeData update) {
        if (Arrays.asList(this.types).equals(Arrays.asList(update.types))) {
            return false;
        }
        HashMap<FluidName, FluidType> index = new HashMap<FluidName, FluidType>();
        for (FluidType type : this.types) {
            if (type == null) continue;
            index.put(type.getName(), type);
        }
        ArrayList<FluidType> newTypes = new ArrayList<FluidType>(Arrays.asList(this.types));
        for (FluidType type : update.types) {
            if (type == null) continue;
            FluidType existing = (FluidType)index.get(type.getName());
            if (existing == null) {
                log.info("New type:" + type.getName());
                newTypes.add(type);
                index.put(type.getName(), type);
                continue;
            }
            if (Objects.equals(type, existing)) continue;
            log.info("Replacing:" + existing.getName());
            int i = newTypes.indexOf(existing);
            if (i < 0) {
                throw new RuntimeException("Data format error: existing fluid type not found in type list, type:" + existing.getName());
            }
            newTypes.set(i, type);
            index.put(type.getName(), type);
        }
        this.types = newTypes.toArray(new FluidType[0]);
        return true;
    }

    public static FluidTypeData load(InputStream rawIn) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(rawIn);){
            FluidTypeData result = new FluidTypeData();
            long version = in.readLong();
            try {
                result.types = (FluidType[])in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Error resolving types", e);
            }
            FluidTypeData fluidTypeData = result;
            return fluidTypeData;
        }
    }

    public static FluidTypeData load(String resource) throws IOException {
        URL u = FluidTypeData.class.getResource(resource);
        if (u == null) {
            return null;
        }
        return FluidTypeData.load(u.openStream());
    }

    public static FluidTypeData load(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        return FluidTypeData.load(new FileInputStream(f));
    }

    public static void store(FluidTypeData data, File f) throws IOException {
        FluidTypeData.store(data, new FileOutputStream(f));
    }

    public static void store(FluidTypeData data, OutputStream rawOut) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(rawOut);){
            out.writeLong(42L);
            out.writeObject(data.types);
        }
    }

    public void writeIndex(File f) throws IOException {
        FileOutputStream fOut = new FileOutputStream(f);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fOut, Charsets.UTF_8));){
            out.println("# Generated:" + String.format("%1$tF %1$tT", new Date()));
            for (int i = 0; i < this.types.length; ++i) {
                FluidType type = this.types[i];
                if (type == null) continue;
                out.println("[" + i + "] " + type.getName());
            }
        }
    }
}

