/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.RigidBody;
import java.util.List;
import java.util.Objects;
import mythruna.shape.ShapeName;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.AgentDriver;
import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Behaviors;
import mythruna.sim.ai.SteeringPrimitive;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Brain {
    static Logger log = LoggerFactory.getLogger(Brain.class);
    private EntityData ed;
    private AgentDriver agent;
    private Behavior defaultBehavior = Behaviors.constant(this, "Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.25));
    private Behavior globalBehavior;
    private Behavior currentBehavior;
    private double hunger = 0.0;
    private double lonely = 0.0;
    private String name;
    private String behaviorName;

    public Brain(final EntityData ed, final AgentDriver agent) {
        Behavior gaefen;
        this.ed = ed;
        this.agent = agent;
        agent.setNearPerception(new Vec3d(0.0, 0.25, 1.0), 3.0);
        agent.setFarPerception(new Vec3d(0.0, 0.25, 2.0), 6.0);
        final AbstractBehavior eat = new AbstractBehavior(this){

            @Override
            public void start() {
                Brain.this.behaviorName = "Eat";
                agent.setDefaultAction("Eat");
                agent.setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
            }

            @Override
            public boolean update(long frameTime, double step) {
                Brain.this.hunger -= step * 5.0;
                return Brain.this.hunger > 0.0;
            }
        };
        this.globalBehavior = gaefen = new Behavior(){
            private double flockCheck = 0.0;
            private Behavior lastFlock;

            @Override
            public void start() {
            }

            @Override
            public boolean update(long frameTime, double step) {
                List<RigidBody<EntityId, MBlockShape>> bodies;
                Brain.this.hunger += step;
                this.flockCheck += step;
                if (this.flockCheck > 5.0) {
                    this.flockCheck = 0.0;
                    bodies = agent.queryNearBodies();
                    if (bodies.isEmpty()) {
                        log.info(agent.getEntityId() + " is getting lonelier.");
                        Brain.this.lonely += 1.0;
                    } else {
                        Brain.this.lonely = 0.0;
                        if (this.lastFlock != Brain.this.getCurrentBehavior()) {
                            log.info(agent.getEntityId() + " canceling flock.");
                            Brain.this.setCurrentBehavior(null);
                        }
                    }
                }
                if (Brain.this.hunger > 60.0) {
                    Brain.this.setCurrentBehavior(eat);
                    return true;
                }
                if (Brain.this.lonely > 5.0) {
                    log.info(agent.getEntityId() + " is very lonely:" + Brain.this.lonely);
                    if (this.lastFlock != Brain.this.getCurrentBehavior()) {
                        log.info(agent.getEntityId() + ":************** I'm lonely....");
                        bodies = agent.queryFarBodies();
                        RigidBody<EntityId, MBlockShape> found = null;
                        if (!bodies.isEmpty()) {
                            RigidBody<EntityId, MBlockShape> nearest = null;
                            double minDist = Double.POSITIVE_INFINITY;
                            RigidBody<EntityId, MBlockShape> nearestUs = null;
                            double minDistUs = Double.POSITIVE_INFINITY;
                            ShapeInfo ourShape = (ShapeInfo)ed.getComponent(agent.getEntityId(), ShapeInfo.class);
                            Vec3d ourLoc = agent.getLocation();
                            for (RigidBody<EntityId, MBlockShape> b : bodies) {
                                ShapeInfo shape;
                                double d = ourLoc.distanceSq(b.position);
                                if (d < minDist) {
                                    nearest = b;
                                    minDist = d;
                                }
                                if (!(d < minDistUs) || (shape = (ShapeInfo)ed.getComponent((EntityId)b.id, ShapeInfo.class)).getShapeId() != ourShape.getShapeId()) continue;
                                nearestUs = b;
                                minDistUs = d;
                            }
                            log.info("Nearest:" + nearest + "  nearestUs:" + nearestUs);
                            found = nearestUs != null ? nearestUs : nearest;
                        }
                        log.info("------------------------Found:" + found);
                        if (found != null) {
                            SteeringPrimitive go = SteeringPrimitives.arrive(agent, found.position, 1.0);
                            go = SteeringPrimitives.scaleSpeed(go, 0.5);
                            Behavior flock = Behaviors.constant(Brain.this, "Idle", go);
                            flock = Behaviors.limited(flock, 30.0);
                            ShapeInfo shape = (ShapeInfo)ed.getComponent((EntityId)found.id, ShapeInfo.class);
                            if (shape != null) {
                                ShapeName shapeName = ShapeName.parse(shape.getShapeName(ed));
                                Brain.this.behaviorName = "flock:" + shapeName.getName();
                            } else {
                                Brain.this.behaviorName = "flock:" + ((EntityId)found.id).getId();
                            }
                            this.lastFlock = flock;
                            Brain.this.setCurrentBehavior(flock);
                        }
                    } else {
                        log.info(agent.getEntityId() + ":is already flocking");
                    }
                }
                if (Brain.this.hunger > 10.0) {
                    Brain.this.setCurrentBehavior(eat);
                    return true;
                }
                return true;
            }

            @Override
            public void stop() {
            }
        };
    }

    public AgentDriver getAgent() {
        return this.agent;
    }

    protected void setName(String name) {
        if (Objects.equals(this.name, name)) {
            return;
        }
        this.name = name;
        log.info("setName(" + name + ")");
        this.ed.setComponent(this.agent.getEntityId(), (EntityComponent)new Name(name, true));
    }

    public void setCurrentBehavior(Behavior currentBehavior) {
        if (this.currentBehavior != null && this.currentBehavior == currentBehavior) {
            return;
        }
        if (this.currentBehavior != null) {
            this.currentBehavior.stop();
        }
        if (currentBehavior == null) {
            this.behaviorName = "default";
        }
        Behavior behavior = this.currentBehavior = currentBehavior == null ? this.defaultBehavior : currentBehavior;
        if (this.currentBehavior != null) {
            this.currentBehavior.start();
        }
    }

    public Behavior getCurrentBehavior() {
        return this.currentBehavior;
    }

    public void update(long frameTime, double step) {
        if (this.globalBehavior != null) {
            this.globalBehavior.update(frameTime, step);
        }
        if (this.currentBehavior == null) {
            this.setCurrentBehavior(null);
        }
        if (!this.currentBehavior.update(frameTime, step)) {
            this.setCurrentBehavior(null);
        }
        String s = String.format("H:%.02f L:%.02f", this.hunger, this.lonely);
        this.setName(this.behaviorName + ":" + this.agent.getDefaultAction() + ":" + s);
    }
}

