/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */

// Base container types
// ...and for now the only container implementation.

createType("Backpack").with {
    // Right now, just extend base object since we cannot pickup/put down
    // a backpack yet and therefore there is also no equip/unequip... but
    // we might want to look at it or get its name.
    supertypes("BaseObject");

    setTypeVar("shape",
               ShapeInfo.create("/Models/items/backpack2.blocks", standardItemScale)); 
    setTypeVar("volume", new ObjectVolume(getTypeVar("shape").volume));

    // Backpack requires some custom fixup
    def backpackScale = getTypeVar("shape").scale; 
    def size = getTypeVar("shape").loadCells().size.toVec3d();
    size.x = 8;
    size.z = 5;
    size *= backpackScale;
    
    def innerSize = new Vec3d(7, 9, 3.5);
    innerSize *= backpackScale;
    
    def offset = size.subtract(innerSize).mult(0.5);
    offset.y = backpackScale; // hard coded to 1 block thickness for the base
    
    setTypeVar("volume", new ObjectVolume(size));
    setTypeVar("containerVolume", new ContainerVolume(innerSize, offset));

    addAction("drop") { dropped, xSlot, ySlot ->
        log.info("drop:" + dropped + " at:" + xSlot + ", " + ySlot);

        // Find out the root of this container object
        def root = object[ContainedIn].root;
        dropped << new ContainedIn(root, target, xSlot, ySlot);
    }

    addAction("itemActions") { clicked ->
        log.info("itemActions:" + clicked);

        // Confirm that it really is in this container just in case
        if( !object.isSameEntity(clicked[ContainedIn].container) ) {
            log.warn("Running actions from container:" + target + " on object not in the container:" + clicked);
            return false;
        }

        // Assemble the action list
        def options = [];
        def clickedContext = clicked.context;
        for( def action : clicked.type.contextActions ) {
            if( !action.canRun(env, clickedContext) ) {
                log.info("Skipping:" + action);
                continue;
            }
            options.add(new Option(action.getName()));
        }
        session.showPrompt(clicked, PromptType.List, clicked.name);
        session.showOptions(clicked, options);

        return true;
    }
}


