/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.jme3.scene.Node;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.TbtQuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import mythruna.assembly.Joint;
import mythruna.client.ui.assembly.QuatdEditor;
import mythruna.client.ui.assembly.Vec3dEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JointEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(JointEditor.class);
    private VersionedHolder<Joint> subassembly = new VersionedHolder();
    private Label restingLabel;
    private Vec3dEditor restingLocEditor;
    private VersionedReference<Vec3d> restingLocRef;
    private QuatdEditor restingRotEditor;
    private VersionedReference<Quatd> restingRotRef;
    private Label targetLabel;
    private Vec3dEditor targetLocEditor;
    private VersionedReference<Vec3d> targetLocRef;
    private QuatdEditor targetRotEditor;
    private VersionedReference<Quatd> targetRotRef;

    public JointEditor() {
        TbtQuadBackgroundComponent bg = TbtQuadBackgroundComponent.create((String)"/Interface/drawn-box-64.png", (float)0.25f, (int)10, (int)10, (int)53, (int)53, (float)1.0f, (boolean)false);
        bg.setMargin(0.0f, 3.0f);
        this.restingLabel = (Label)this.addChild((Node)new Label("Start:"), new Object[0]);
        this.restingLabel.setFontSize(18.0f);
        Container child = (Container)this.addChild((Node)new Container(), new Object[0]);
        child.setBorder((GuiComponent)bg);
        this.restingLocEditor = (Vec3dEditor)child.addChild((Node)new Vec3dEditor(Vec3dEditor.createModel(-0.75, 0.75, 0.005, 0.001, 0.0), Vec3dEditor.createModel(-0.25, 1.5, 0.005, 0.001, 0.0), Vec3dEditor.createModel(-0.75, 0.75, 0.005, 0.001, 0.0), "%.3f", 80.0f, 10.0f), new Object[0]);
        this.restingLocRef = this.restingLocEditor.createReference();
        this.restingRotEditor = (QuatdEditor)child.addChild((Node)new QuatdEditor(Vec3dEditor.createModel(-180.0, 180.0, 0.5, 0.1, 0.0), Vec3dEditor.createModel(-90.0, 90.0, 0.5, 0.1, 0.0), Vec3dEditor.createModel(-90.0, 90.0, 0.5, 0.1, 0.0), "%.1f", 80.0f), new Object[0]);
        this.restingRotRef = this.restingRotEditor.createReference();
        this.targetLabel = (Label)this.addChild((Node)new Label("End:"), new Object[0]);
        this.targetLabel.setFontSize(18.0f);
        child = (Container)this.addChild((Node)new Container(), new Object[0]);
        child.setBorder((GuiComponent)bg.clone());
        this.targetLocEditor = (Vec3dEditor)child.addChild((Node)new Vec3dEditor(Vec3dEditor.createModel(-1.25, 1.25, 0.005, 0.001, 0.0), Vec3dEditor.createModel(-0.25, 2.5, 0.005, 0.001, 0.0), Vec3dEditor.createModel(-1.25, 1.25, 0.005, 0.001, 0.0), "%.3f", 80.0f, 10.0f), new Object[0]);
        this.targetLocRef = this.targetLocEditor.createReference();
        this.targetRotEditor = (QuatdEditor)child.addChild((Node)new QuatdEditor(Vec3dEditor.createModel(-180.0, 180.0, 0.5, 0.1, 0.0), Vec3dEditor.createModel(-90.0, 90.0, 0.5, 0.1, 0.0), Vec3dEditor.createModel(-90.0, 90.0, 0.5, 0.1, 0.0), "%.1f", 80.0f), new Object[0]);
        this.targetRotRef = this.targetRotEditor.createReference();
    }

    public void setJoint(Joint sub) {
        if (this.subassembly.getObject() != sub) {
            this.subassembly.setObject((Object)sub);
            this.resetFields(sub);
        }
    }

    public VersionedReference<Joint> createReference() {
        return this.subassembly.createReference();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.subassembly.getObject() == null) {
            return;
        }
        Joint sub = (Joint)this.subassembly.getObject();
        boolean changed = false;
        if (this.restingLocRef.update()) {
            changed = true;
        }
        if (this.restingRotRef.update()) {
            changed = true;
        }
        if (this.targetLocRef.update()) {
            changed = true;
        }
        if (this.targetRotRef.update()) {
            changed = true;
        }
        if (changed) {
            this.subassembly.incrementVersion();
        }
    }

    protected void resetFields(Joint joint) {
        this.restingLabel.setText(joint.getRestingState().getState() + ":");
        this.targetLabel.setText(joint.getTargetState().getState() + ":");
        Vec3d loc = joint.getLocation();
        this.restingLocEditor.setObject(loc);
        Quatd rot = joint.getOrientation();
        this.restingRotEditor.setObject(rot);
        this.targetLocEditor.setObject(joint.getTargetLocation());
        this.targetRotEditor.setObject(joint.getTargetOrientation());
    }
}

