/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.geom.GeomUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.Part;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import mythruna.assembly.AssemblyShape;
import mythruna.assembly.Joint;
import mythruna.assembly.MixControl;
import mythruna.assembly.PartJointController;
import mythruna.client.view.ModelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialFactory {
    static Logger log = LoggerFactory.getLogger(SpatialFactory.class);
    private GeometryFactory geomFactory;
    private Predicate<Geometry> carveIncludes;
    private boolean debugJoints = false;

    public SpatialFactory(GeometryFactory geomFactory, Predicate<Geometry> carveIncludes) {
        this.geomFactory = geomFactory;
        this.carveIncludes = carveIncludes;
    }

    public Spatial createModel(ModelInfo info) {
        if (log.isTraceEnabled()) {
            log.trace("createModel(" + info.shapeName + ")");
        }
        log.info("createModel(" + info.shapeName + ")");
        MixControl mix = null;
        HashMap<Part, Joint> jointIndex = null;
        if (info.shape instanceof AssemblyShape) {
            mix = new MixControl();
            jointIndex = new HashMap<Part, Joint>();
            AssemblyShape shape = (AssemblyShape)info.shape;
            for (PartJointController controller : shape.getJoints()) {
                jointIndex.put((Part)controller.getTarget(), controller.getJoint());
            }
        }
        Part part = info.shape.getPart();
        Spatial result = this.createPartSpatial(info, part, mix, jointIndex);
        if (mix != null) {
            result.addControl((Control)mix);
        }
        return result;
    }

    protected Spatial createPartSpatial(ModelInfo info, Part part, MixControl mix, Map<Part, Joint> jointIndex) {
        if (part instanceof CellArrayPart) {
            return this.createCellArrayPart(info, (CellArrayPart)part);
        }
        if (part instanceof Group) {
            return this.createGroupPart(info, (Group)part, mix, jointIndex);
        }
        throw new IllegalArgumentException("Unhandled part type:" + part);
    }

    protected boolean isCarved(Part part) {
        String name = part.getName();
        if (name == null) {
            return false;
        }
        if (name.endsWith(".ca") && name.startsWith("c_")) {
            return true;
        }
        return name.endsWith(".carved.blocks");
    }

    protected Spatial createCellArrayPart(ModelInfo info, CellArrayPart part) {
        Node parts = new Node("parts:" + part.getName());
        this.geomFactory.generateBlocks(parts, part.getCells(), (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        if (this.isCarved((Part)part)) {
            float scale = (float)part.getScale();
            GeomUtils.carve((Node)parts, (float)scale, this.carveIncludes);
        }
        parts.setLocalScale((float)part.getScale());
        parts.setLocalTranslation(part.getLocalPosition().toVector3f());
        parts.setLocalRotation(part.getLocalOrientation().toQuaternion());
        parts.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        parts.setUserData("oid", (Object)info.entityId.getId());
        if (this.debugJoints) {
            parts.attachChild((Spatial)this.createBox(0.01f, ColorRGBA.Pink));
        }
        return parts;
    }

    protected Spatial createGroupPart(ModelInfo info, Group group, MixControl mix, Map<Part, Joint> jointIndex) {
        Node node = new Node(group.getName());
        for (Part child : group.getChildren()) {
            Spatial spatial = this.createPartSpatial(info, child, mix, jointIndex);
            node.attachChild(spatial);
        }
        if (mix != null) {
            Joint joint = jointIndex.get(group);
            log.info("Found joint:" + joint);
            if (joint != null) {
                mix.addJoint(joint, (Spatial)node);
                if (this.debugJoints) {
                    node.attachChild((Spatial)this.createBox(0.1f, ColorRGBA.Orange));
                }
            }
        }
        node.setLocalTranslation(group.getLocalPosition().toVector3f());
        node.setLocalRotation(group.getLocalOrientation().toQuaternion());
        node.setUserData("oid", (Object)info.entityId.getId());
        if (this.debugJoints) {
            node.attachChild((Spatial)this.createBox(0.02f, ColorRGBA.Green));
        }
        return node;
    }

    protected Geometry createBox(float size, ColorRGBA color) {
        log.info("createBox(" + size + ", " + color + ")");
        Box box = new Box(size, size, size);
        Geometry geom = new Geometry("box", (Mesh)box);
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(color, false).getMaterial());
        geom.getMaterial().getAdditionalRenderState().setWireframe(true);
        geom.getMaterial().getAdditionalRenderState().setDepthTest(false);
        geom.setQueueBucket(RenderQueue.Bucket.Translucent);
        return geom;
    }
}

