/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fx.sky;

import com.jme3.app.Application;
import com.jme3.math.Vector3f;
import com.simsilica.fx.LightingState;
import com.simsilica.fx.sky.AtmosphericParameters;
import com.simsilica.fx.sky.SkyState;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.BaseAppState;
import com.simsilica.lemur.props.PropertyPanel;

public class SkySettingsState
extends BaseAppState {
    private AtmosphericParameters atmosphericParms;
    private float mieConstant;
    private float rayleighConstant;
    private VersionedReference<Vector3f> lightDir;
    private PropertyPanel settings;

    public PropertyPanel getSettings() {
        return this.settings;
    }

    public void setMieConstant(float f) {
        this.atmosphericParms.setMieConstant(f / 10.0f);
        this.mieConstant = f / 10.0f;
    }

    public float getMieConstant() {
        return this.mieConstant * 10.0f;
    }

    public void setRayleighConstant(float f) {
        this.atmosphericParms.setRayleighConstant(f / 10.0f);
        this.rayleighConstant = f / 10.0f;
    }

    public float getRayleighConstant() {
        return this.rayleighConstant * 10.0f;
    }

    protected void initialize(Application app) {
        this.lightDir = ((LightingState)this.getState(LightingState.class)).getLightDirRef();
        this.atmosphericParms = ((SkyState)this.getState(SkyState.class)).getAtmosphericParameters();
        this.mieConstant = this.atmosphericParms.getMieConstant();
        this.rayleighConstant = this.atmosphericParms.getRayleighConstant();
        this.settings = new PropertyPanel("glass");
        this.settings.addFloatProperty("Intensity", (Object)this.atmosphericParms, "lightIntensity", 0.0f, 100.0f, 1.0f);
        this.settings.addFloatProperty("Sky Exposure", (Object)this.atmosphericParms, "skyExposure", 0.0f, 10.0f, 0.1f);
        this.settings.addFloatProperty("Rayleigh Constant(x10)", (Object)this, "rayleighConstant", 0.0f, 1.0f, 0.001f);
        this.settings.addFloatProperty("Scale Depth", (Object)this.atmosphericParms, "averageDensityScale", 0.0f, 1.0f, 0.001f);
        this.settings.addFloatProperty("Mie Constant(x10)", (Object)this, "mieConstant", 0.0f, 1.0f, 0.001f);
        this.settings.addFloatProperty("MPA Factor", (Object)this.atmosphericParms, "miePhaseAsymmetryFactor", -1.5f, 0.0f, 0.001f);
        this.settings.addFloatProperty("Flattening", (Object)this.atmosphericParms, "skyFlattening", 0.0f, 1.0f, 0.01f);
        this.settings.addFloatProperty("Red Wavelength (nm)", (Object)this.atmosphericParms, "redWavelength", 0.0f, 1.0f, 0.001f);
        this.settings.addFloatProperty("Green Wavelength (nm)", (Object)this.atmosphericParms, "greenWavelength", 0.0f, 1.0f, 0.001f);
        this.settings.addFloatProperty("Blue Wavelength (nm)", (Object)this.atmosphericParms, "blueWavelength", 0.0f, 1.0f, 0.001f);
        this.settings.addFloatProperty("Time", (Object)this.getState(LightingState.class), "timeOfDay", -0.1f, 1.1f, 0.01f);
        this.settings.addFloatProperty("Orientation", (Object)this.getState(LightingState.class), "orientation", 0.0f, (float)Math.PI * 2, 0.01f);
        this.settings.addBooleanProperty("Flat Shaded", (Object)this.getState(SkyState.class), "flatShaded");
        this.settings.addBooleanProperty("Show Ground Disc", (Object)this.getState(SkyState.class), "showGroundDisc");
    }

    protected void cleanup(Application app) {
    }

    protected void enable() {
    }

    protected void disable() {
    }
}

