/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import mythruna.character.SkinTone;
import mythruna.text.CsvUtils;
import mythruna.text.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinToneIndex {
    static Logger log = LoggerFactory.getLogger(SkinToneIndex.class);
    public static final String SKIN_TONE_INDEX_CSV = "races/skin-tones.csv";
    private List<SkinTone> allTones = new ArrayList<SkinTone>();
    private ListMultimap<String, SkinTone> raceIndex = MultimapBuilder.hashKeys().arrayListValues().build();

    public SkinToneIndex(List<SkinTone> tones) {
        this.allTones = tones;
        for (SkinTone tone : tones) {
            for (String race : tone.getRaces()) {
                this.raceIndex.put((Object)race, (Object)tone);
            }
        }
    }

    public List<SkinTone> getTones() {
        return this.allTones;
    }

    public SkinTone getRandomTone(String race, Random rand) {
        List tones = this.raceIndex.get((Object)race);
        if (tones.isEmpty()) {
            throw new IllegalArgumentException("Unknown race:" + race);
        }
        int i = rand.nextInt(tones.size());
        return (SkinTone)tones.get(i);
    }

    public static SkinToneIndex create(Function<String, String> textFunc) {
        String text = textFunc.apply(SKIN_TONE_INDEX_CSV);
        SkinToneIndex index = SkinToneIndex.create(text);
        return index;
    }

    public static SkinToneIndex create(String text) {
        List<Map<String, String>> records = CsvUtils.csvToRecords(text, 0, '\t');
        List<SkinTone> configs = MapUtils.toObjects(records, SkinTone.class);
        return new SkinToneIndex(configs);
    }
}

