/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.simsilica.es.EntityData;
import com.simsilica.ext.mblock.BlockShapeFactory;
import com.simsilica.ext.mblock.CellArrayFunctions;
import com.simsilica.ext.mblock.SphereFactory;
import com.simsilica.ext.mphys.CompositeShapeFactory;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.phys.MBlockShape;
import java.util.function.Function;
import mythruna.assembly.AssemblyShapeFactory;
import mythruna.assembly.Subassembly;
import mythruna.assembly.db.SubassemblyId;
import mythruna.net.DataSession;
import mythruna.shape.FabricShapeFactory;
import mythruna.shape.RigShapeFactory;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeRegistryBuilder {
    static Logger log = LoggerFactory.getLogger(ShapeRegistryBuilder.class);

    public static ShapeFactoryRegistry<MBlockShape> serverRegistry(WorldManager worldManager) {
        return ShapeRegistryBuilder.createRegistry((EntityData)worldManager.getEntityData(), worldManager.getSubassemblyStorage(), (Function<CellArrayId, CellArray>)worldManager.getCellArrayStorage());
    }

    public static ShapeFactoryRegistry<MBlockShape> clientRegistry(EntityData ed, final DataSession dataSession) {
        return ShapeRegistryBuilder.createRegistry(ed, new Function<SubassemblyId, Subassembly>(){

            @Override
            public Subassembly apply(SubassemblyId id) {
                return dataSession.getSubassembly(id);
            }
        }, new Function<CellArrayId, CellArray>(){

            @Override
            public CellArray apply(CellArrayId id) {
                return dataSession.getCellArray(id);
            }
        });
    }

    public static ShapeFactoryRegistry<MBlockShape> createRegistry(EntityData ed, Function<SubassemblyId, Subassembly> subStorage, Function<CellArrayId, CellArray> cellStorage) {
        ShapeFactoryRegistry shapeFactory = new ShapeFactoryRegistry();
        shapeFactory.registerFactory("sphere", (ShapeFactory)new SphereFactory());
        CompositeShapeFactory chain = new CompositeShapeFactory(new ShapeFactory[0]);
        shapeFactory.setDefaultFactory((ShapeFactory)chain);
        chain.addDelegate((ShapeFactory)new AssemblyShapeFactory(subStorage, cellStorage));
        chain.addDelegate((ShapeFactory)new RigShapeFactory());
        chain.addDelegate((ShapeFactory)new FabricShapeFactory(cellStorage));
        BlockShapeFactory blockFactory = new BlockShapeFactory();
        chain.addDelegate((ShapeFactory)blockFactory);
        Function loaders = CellArrayFunctions.chain((Function[])new Function[]{CellArrayFunctions.blocksResource(), CellArrayFunctions.cellArrayStorage(cellStorage)});
        blockFactory.addDelegate(CellArrayFunctions.singletonCache((Function)loaders));
        return shapeFactory;
    }
}

