/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.CharacterRig;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.ethereal.zone.ZoneManager;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.ObjectStatusListener;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.net.ZoneNetworkListener;
import com.simsilica.ext.mphys.net.ZoneNetworkSystem;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.es.AttachedTo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(AttachmentSystem.class);
    private EntityData ed;
    private MPhysSystem<MBlockShape> physics;
    private PhysicsSpace<EntityId, MBlockShape> space;
    private ShapeFactory<MBlockShape> shapeFactory;
    private EntityChangeObserver entityListener = new EntityChangeObserver();
    private BodyStatusObserver bodyListener = new BodyStatusObserver();
    private ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();
    private Map<EntityId, AttachmentEntry> activeAttachments = new HashMap<EntityId, AttachmentEntry>();
    private Multimap<EntityId, AttachmentEntry> childIndex = MultimapBuilder.hashKeys().hashSetValues().build();
    private ZoneManager zones;
    private ZoneNetworkObserver zoneObserver = new ZoneNetworkObserver();
    private Set<AttachmentEntry> toUpdate = new HashSet<AttachmentEntry>();
    private Set<EntityId> toRemove = new HashSet<EntityId>();
    private List<AttachmentEntry> dynamicAttachments = new ArrayList<AttachmentEntry>();

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class, true);
        this.shapeFactory = (ShapeFactory)this.getSystem(ShapeFactory.class, true);
        this.zones = ((ZoneNetworkSystem)this.getSystem(ZoneNetworkSystem.class, true)).getZones();
        ((ZoneNetworkSystem)this.getSystem(ZoneNetworkSystem.class, true)).addZoneNetworkListener((ZoneNetworkListener)this.zoneObserver);
        this.space = this.physics.getPhysicsSpace();
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).getBinEntityManager().addObjectStatusListener((ObjectStatusListener)this.bodyListener);
    }

    protected void terminate() {
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).getBinEntityManager().addObjectStatusListener((ObjectStatusListener)this.bodyListener);
        ((ZoneNetworkSystem)this.getSystem(ZoneNetworkSystem.class, true)).removeZoneNetworkListener((ZoneNetworkListener)this.zoneObserver);
    }

    public void start() {
        ((ObservableEntityData)this.ed).addEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    public void update(SimTime time) {
        EntityChange change = null;
        while ((change = this.changes.poll()) != null) {
            ShapeInfo info;
            if (change.getComponentType() == AttachedTo.class) {
                AttachedTo att = (AttachedTo)change.getComponent();
                if (att == null) {
                    this.removeAttachment(change.getEntityId());
                    continue;
                }
                this.updateAttachment(change.getEntityId(), att);
                continue;
            }
            if (change.getComponentType() != ShapeInfo.class || (info = (ShapeInfo)change.getComponent()) == null) continue;
            this.updateShape(change.getEntityId(), info);
        }
        if (!this.dynamicAttachments.isEmpty()) {
            for (AttachmentEntry att : this.dynamicAttachments) {
                att.resetPosition();
            }
        }
    }

    public void stop() {
        ((ObservableEntityData)this.ed).removeEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    protected void updateAttachment(EntityId attachment, AttachedTo to) {
        AttachmentEntry entry = this.activeAttachments.get(attachment);
        if (entry == null) {
            RigidBody body = this.space.getBinIndex().getRigidBody((Object)to.getParent());
            if (body != null) {
                this.addAttachment((RigidBody<EntityId, MBlockShape>)body, attachment, to);
            } else {
                log.warn("updateAttachment() No body for ID:" + to.getParent());
            }
        } else {
            entry.update(to);
        }
    }

    protected void updateShape(EntityId attachment, ShapeInfo shape) {
        AttachmentEntry entry = this.activeAttachments.get(attachment);
        if (entry != null) {
            entry.updateShape(shape);
        }
    }

    protected void removeAttachment(EntityId attachment) {
        AttachmentEntry entry = this.activeAttachments.remove(attachment);
        if (entry == null) {
            return;
        }
        this.childIndex.remove((Object)entry.parent, (Object)entry);
        log.info("Remove " + attachment + " from:" + entry.parent);
        entry.release();
    }

    protected void addAttachment(RigidBody<EntityId, MBlockShape> body, EntityId attachmentId) {
        AttachedTo to = (AttachedTo)this.ed.getComponent(attachmentId, AttachedTo.class);
        if (to == null) {
            log.warn("No AttachedTo component found in addAttachment()");
            return;
        }
        this.addAttachment(body, attachmentId, to);
    }

    protected void addAttachment(RigidBody<EntityId, MBlockShape> body, EntityId attachmentId, AttachedTo to) {
        log.info("addAttachment(" + attachmentId + ") to:" + body.id);
        AttachmentEntry entry = new AttachmentEntry(body, attachmentId, to);
        this.toRemove.remove(attachmentId);
        this.activeAttachments.put(attachmentId, entry);
        this.childIndex.put((Object)((EntityId)body.id), (Object)entry);
        entry.update(to);
        ShapeInfo shape = (ShapeInfo)this.ed.getComponent(attachmentId, ShapeInfo.class);
        if (shape != null) {
            entry.updateShape(shape);
        }
    }

    private class EntityChangeObserver
    implements EntityComponentListener {
        private EntityChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            Class type = change.getComponentType();
            if (type != AttachedTo.class && type != ShapeInfo.class) {
                return;
            }
            AttachmentSystem.this.changes.add(change);
        }
    }

    private class BodyStatusObserver
    extends ObjectStatusAdapter<MBlockShape> {
        private BodyStatusObserver() {
        }

        public void objectLoaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            log.info("objectLoaded(" + entity + ")");
            ComponentFilter filter = Filters.fieldEquals(AttachedTo.class, (String)"parent", (Object)entity);
            for (EntityId attachmentId : AttachmentSystem.this.ed.findEntities(filter, new Class[]{AttachedTo.class, ShapeInfo.class})) {
                log.info(" found attachment:" + attachmentId);
                AttachmentSystem.this.addAttachment(body, attachmentId);
            }
        }

        public void objectUnloaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            log.info("objectUnloaded(" + entity + ")");
            for (AttachmentEntry entry : AttachmentSystem.this.childIndex.removeAll((Object)entity)) {
                log.info(" removing:" + entry.attachment);
                AttachmentSystem.this.activeAttachments.remove(entry.attachment);
                entry.release();
            }
        }
    }

    private class ZoneNetworkObserver
    implements ZoneNetworkListener {
        private long frameTime;

        private ZoneNetworkObserver() {
        }

        public void beginUpdate(long frameTime) {
            this.frameTime = frameTime;
        }

        public void endUpdate() {
            boolean active;
            for (AttachmentEntry entry : AttachmentSystem.this.toUpdate) {
                if (entry.body == null) continue;
                active = !entry.body.isSleepy();
                AttachmentSystem.this.zones.updateEntity(Long.valueOf(entry.parent.getId()), Long.valueOf(entry.attachment.getId()), active, entry.offset, entry.rotation, entry.body.getWorldBounds());
                entry.pos.addFrame(this.frameTime, entry.parent, entry.offset, entry.rotation, entry.visible);
            }
            AttachmentSystem.this.toUpdate.clear();
            if (!AttachmentSystem.this.dynamicAttachments.isEmpty()) {
                for (AttachmentEntry entry : AttachmentSystem.this.dynamicAttachments) {
                    if (entry.body == null) continue;
                    active = !entry.body.isSleepy();
                    AttachmentSystem.this.zones.updateEntity(Long.valueOf(entry.parent.getId()), Long.valueOf(entry.attachment.getId()), active, entry.offset, entry.rotation, entry.body.getWorldBounds());
                    entry.pos.addFrame(this.frameTime, entry.parent, entry.offset, entry.rotation, entry.visible);
                }
            }
            for (EntityId id : AttachmentSystem.this.toRemove) {
                log.info("zones remove:" + id);
                AttachmentSystem.this.zones.remove(Long.valueOf(id.getId()));
            }
            AttachmentSystem.this.toRemove.clear();
        }
    }

    private class AttachmentEntry {
        EntityId parent;
        EntityId attachment;
        AttachedTo attachedTo;
        int attachmentId;
        String attachmentName;
        ShapeInfo shapeInfo;
        Part part;
        RigidBody<EntityId, MBlockShape> body;
        BodyPosition pos;
        boolean visible = true;
        AttachmentPoint attachmentPoint;
        Vec3d offset = new Vec3d();
        Quatd rotation = new Quatd();

        public AttachmentEntry(RigidBody<EntityId, MBlockShape> body, EntityId attachment, AttachedTo to) {
            this.parent = (EntityId)body.id;
            this.body = body;
            this.attachment = attachment;
            this.attachedTo = to;
            this.attachmentId = to.getAttachmentId();
            this.attachmentName = to.getAttachmentName(AttachmentSystem.this.ed);
            this.pos = (BodyPosition)AttachmentSystem.this.ed.getComponent(attachment, BodyPosition.class);
            if (this.pos == null) {
                this.pos = new BodyPosition(3);
                AttachmentSystem.this.ed.setComponent(attachment, (EntityComponent)this.pos);
            }
        }

        public void release() {
            this.updateShape(null);
            if (this.attachmentPoint != null) {
                AttachmentSystem.this.dynamicAttachments.remove(this);
                this.attachmentPoint = null;
            }
            AttachmentSystem.this.toRemove.add(this.attachment);
            AttachmentSystem.this.toUpdate.add(this);
            this.visible = false;
            log.info("Removing BodyPosition for:" + this.attachment);
            if (this.pos.getLastParentId() != null) {
                AttachmentSystem.this.ed.removeComponent(this.attachment, BodyPosition.class);
            }
        }

        protected void resetPosition() {
            if (this.attachmentPoint != null) {
                this.attachmentPoint.update();
                this.offset.set(this.attachmentPoint.getTranslation());
                this.rotation.set(this.attachmentPoint.getRotation());
                Vec3d v = this.rotation.mult(this.attachedTo.getOffset());
                this.rotation.multLocal(this.attachedTo.getRotation());
                this.offset.addLocal(v);
            } else {
                this.offset.set(this.attachedTo.getOffset());
                this.rotation.set(this.attachedTo.getRotation());
            }
            if (this.part != null) {
                this.part.setLocalPosition(this.offset);
                this.part.setLocalOrientation(this.rotation);
            }
        }

        protected void resetAttachment() {
            AttachmentPoint old = this.attachmentPoint;
            if (this.attachmentName != null && this.body.shape instanceof CharacterRig) {
                CharacterRig crig = (CharacterRig)this.body.shape;
                this.attachmentPoint = crig.getAttachmentPoint(this.attachmentName);
                log.info("Found attachment point:" + this.attachmentPoint);
            }
            if (old != null && this.attachmentPoint == null) {
                AttachmentSystem.this.dynamicAttachments.remove(this);
            } else if (old == null && this.attachmentPoint != null) {
                AttachmentSystem.this.dynamicAttachments.add(this);
            }
            this.resetPosition();
            if (this.attachmentPoint == null) {
                AttachmentSystem.this.toUpdate.add(this);
            }
        }

        public void update(AttachedTo to) {
            log.info("update attachment:" + to);
            if (!Objects.equals(this.parent, to.getParent())) {
                log.warn("Changing parents not yet supported:" + to + "  from:" + this.parent);
                return;
            }
            this.attachedTo = to;
            this.resetAttachment();
        }

        public void updateShape(ShapeInfo shapeInfo) {
            if (Objects.equals(shapeInfo, this.shapeInfo)) {
                return;
            }
            log.info("update shape:" + shapeInfo);
            this.shapeInfo = shapeInfo;
            log.info("Cog before:" + ((MBlockShape)this.body.shape).getMass().getCog());
            if (this.part != null && ((MBlockShape)this.body.shape).getPart() instanceof Group) {
                ((Group)((MBlockShape)this.body.shape).getPart()).removeChild(this.part);
                log.info("Cog after remove:" + ((MBlockShape)this.body.shape).getMass().getCog());
            }
            if (shapeInfo == null) {
                this.part = null;
                return;
            }
            MBlockShape shape = (MBlockShape)AttachmentSystem.this.shapeFactory.createShape(shapeInfo.getShapeName(AttachmentSystem.this.ed), shapeInfo.getScale(), new Mass(0.001));
            this.part = shape.getPart();
            log.info("created part:" + this.part);
            if (!(((MBlockShape)this.body.shape).getPart() instanceof Group)) {
                log.info("creating holder");
                Group group = new Group("holder");
                group.addChild(((MBlockShape)this.body.shape).getPart());
                MBlockShape newShape = new MBlockShape((Part)group);
                this.body.morph((AbstractShape)newShape);
            }
            ((Group)((MBlockShape)this.body.shape).getPart()).addChild(this.part);
            if (this.attachedTo != null) {
                this.resetAttachment();
            }
            log.info("Cog after:" + ((MBlockShape)this.body.shape).getMass().getCog());
        }
    }
}

