/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.SteeringPrimitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Behaviors {
    static Logger log = LoggerFactory.getLogger(Behaviors.class);

    public static Behavior constant(Brain brain, String defaultAction, SteeringPrimitive steering) {
        return new Constant(brain, defaultAction, steering);
    }

    public static Behavior limited(Behavior delegate, double timeout) {
        return new Limited(delegate, timeout);
    }

    private static class Constant
    extends AbstractBehavior {
        private String defaultAction;
        private SteeringPrimitive steering;

        public Constant(Brain brain, String defaultAction, SteeringPrimitive steering) {
            super(brain);
            this.defaultAction = defaultAction;
            this.steering = steering;
        }

        @Override
        protected void onStart() {
            this.getBrain().getAgent().setDefaultAction(this.defaultAction);
            this.getBrain().getAgent().setSteering(this.steering);
        }

        @Override
        public boolean update(long frameTime, double step) {
            return true;
        }
    }

    private static class Limited
    implements Behavior {
        private Behavior delegate;
        private double timeout;
        private double time;

        public Limited(Behavior delegate, double timeout) {
            this.delegate = delegate;
            this.timeout = timeout;
        }

        @Override
        public void start() {
            this.time = 0.0;
            this.delegate.start();
        }

        @Override
        public boolean isRunning() {
            return this.delegate.isRunning();
        }

        @Override
        public boolean update(long frameTime, double step) {
            this.time += step;
            boolean result = this.delegate.update(frameTime, step);
            return this.time < this.timeout && result;
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[timeout:" + this.timeout + ", delegate:" + this.delegate + "]";
        }
    }
}

