/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly;

import com.simsilica.ext.mblock.CellArrayFunctions;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mythruna.assembly.AssemblyShape;
import mythruna.assembly.Joint;
import mythruna.assembly.PartJointController;
import mythruna.assembly.Subassembly;
import mythruna.assembly.db.SubassemblyId;
import mythruna.assembly.io.SubassemblyJson;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblyShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(AssemblyShapeFactory.class);
    private Function<SubassemblyId, Subassembly> subassemblyStorage;
    private Function<CellArrayId, CellArray> cellStorage;
    private Function<String, CellArray> cellLoaders;

    public AssemblyShapeFactory(Function<SubassemblyId, Subassembly> subassemblyStorage, Function<CellArrayId, CellArray> cellStorage) {
        this.subassemblyStorage = subassemblyStorage;
        this.cellStorage = cellStorage;
        Function loaders = CellArrayFunctions.chain((Function[])new Function[]{CellArrayFunctions.blocksResource(), CellArrayFunctions.cellArrayStorage(cellStorage)});
        this.cellLoaders = CellArrayFunctions.singletonCache((Function)loaders);
    }

    protected Subassembly load(ShapeName name) {
        if ("asm".equals(name.getType())) {
            SubassemblyId id = SubassemblyId.fromString(name.getName());
            return this.subassemblyStorage.apply(id);
        }
        if ("assembly".equals(name.getType())) {
            return SubassemblyJson.loadResource(name.getFullName());
        }
        throw new IllegalArgumentException("Unsupported subassembly type:" + name.getType());
    }

    public MBlockShape createShape(String name, double scale, Mass mass) {
        HashMap<String, PartJointController> joints;
        Part root;
        log.info("createShape(" + name + ", " + scale + ", " + mass + ")");
        ShapeName shapeName = ShapeName.parse(name);
        if (!"assembly".equals(shapeName.getType()) && !"asm".equals(shapeName.getType())) {
            return null;
        }
        Subassembly assembly = this.load(shapeName);
        double m = mass == null ? 0.0 : mass.getMass();
        double massScale = 0.0;
        if (m > 0.0) {
            double assemblyMass = assembly.getTotalMass();
            massScale = assemblyMass == 0.0 ? 0.0 : m / assemblyMass;
        }
        if ((root = this.createPart(assembly, scale, massScale, joints = new HashMap<String, PartJointController>())).getLocalPosition().lengthSq() > 0.0) {
            Group newRoot = new Group(root.getName());
            newRoot.addChild(root);
            root = newRoot;
        }
        if (!joints.isEmpty()) {
            AssemblyShape shape = new AssemblyShape(root, joints);
            return shape;
        }
        return new MBlockShape(root);
    }

    protected Part createPart(Subassembly sub, double scale, double massScale, Map<String, PartJointController> joints) {
        PartJointController controller;
        CellArrayPart result = null;
        String name = sub.getShapeName() == null ? null : sub.getShapeName().getFullName();
        double localScale = sub.getScale();
        if (name != null) {
            CellArray cells = this.cellLoaders.apply(name);
            result = CellArrayPart.createShape((String)name, (CellArray)cells, (double)localScale, (double)(sub.getMass() * massScale));
        }
        if (sub instanceof Joint) {
            name = "Joint:" + sub.getName();
        }
        if (sub.hasChildren()) {
            Group group = new Group(name);
            if (result != null) {
                group.addChild((Part)result);
            }
            result = group;
            for (Subassembly child : sub) {
                Part childPart = this.createPart(child, localScale, massScale, joints);
                if (childPart == null) continue;
                group.addChild(childPart);
            }
        }
        result.setLocalPosition(sub.getLocation());
        result.setLocalOrientation(sub.getOrientation());
        if (sub instanceof Joint && joints.put((controller = new PartJointController((Joint)sub, (Part)result)).getJointName(), controller) != null) {
            throw new RuntimeException("Duplicate joint name at:" + sub);
        }
        return result;
    }
}

