/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import com.simsilica.thread.IterationProcessor;
import com.simsilica.thread.IterationProcessorThread;
import mythruna.es.AgentType;
import mythruna.sim.ai.AgentActivationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentActivationSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(AgentActivationSystem.class);
    private EntityData ed;
    private IterationProcessorThread thread;
    private AgentActivationProcessor processor;

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class);
        if (this.ed == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " system requires an EntityData object.");
        }
        this.processor = new AgentActivationProcessor(this.ed);
        this.thread = new IterationProcessorThread("agentActivationSystem", (IterationProcessor)this.processor);
    }

    protected void terminate() {
    }

    public void start() {
        this.initializeAgentLevels();
        this.thread.start();
    }

    public void update(SimTime time) {
        this.thread.iterate();
    }

    public void stop() {
        this.thread.close();
    }

    protected void initializeAgentLevels() {
        ComponentFilter<AgentType> highFilter = AgentType.levelFilter(0);
        ComponentFilter<AgentType> lowFilter = AgentType.levelFilter(1);
        ComponentFilter filter = Filters.or(AgentType.class, (ComponentFilter[])new ComponentFilter[]{highFilter, lowFilter});
        for (EntityId id : this.ed.findEntities(filter, new Class[]{AgentType.class})) {
            log.warn("Fixing agent:" + id + " to be passive.");
            AgentType type = (AgentType)this.ed.getComponent(id, AgentType.class);
            this.ed.setComponent(id, (EntityComponent)type.changeLevel(2));
        }
    }
}

