/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.RigidBody;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mythruna.es.DebugText;
import mythruna.es.LocationRelationship;
import mythruna.es.StatusText;
import mythruna.shape.ShapeName;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.AgentDriver;
import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Behaviors;
import mythruna.sim.ai.BodyPositionMob;
import mythruna.sim.ai.FollowBehavior;
import mythruna.sim.ai.SteeringPrimitive;
import mythruna.sim.ai.SteeringPrimitives;
import mythruna.sim.ai.TalkBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Brain {
    static Logger log = LoggerFactory.getLogger(Brain.class);
    private EntityData ed;
    private AgentDriver agent;
    private long lastFrameTime;
    private Behavior defaultBehavior = Behaviors.constant(this, "Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0));
    private Behavior globalBehavior;
    private Behavior currentBehavior;
    private double hunger = 0.0;
    private double lonely = 0.0;
    private Vec3d home;
    private String debugText;
    private String behaviorName;
    private Behavior gaefen;
    private Behavior basicNpc;
    private TalkBehavior talkBehavior;
    private FollowBehavior followBehavior;
    private final Behavior standStill;
    private Vec3d lastPos = new Vec3d();

    public Brain(final EntityData ed, final AgentDriver agent) {
        this.ed = ed;
        this.agent = agent;
        agent.setNearPerception(new Vec3d(0.0, 0.25, 1.0), 3.0);
        agent.setFarPerception(new Vec3d(0.0, 0.25, 2.0), 6.0);
        final AbstractBehavior eat = new AbstractBehavior(this){

            @Override
            protected void onStart() {
                Brain.this.behaviorName = "Eat";
                agent.setDefaultAction("Eat");
                agent.setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
            }

            @Override
            public boolean update(long frameTime, double step) {
                Brain.this.hunger -= step * 5.0;
                return Brain.this.hunger > 0.0;
            }
        };
        this.standStill = new AbstractBehavior(this){

            @Override
            protected void onStart() {
                Brain.this.behaviorName = "Stand Still";
                agent.setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
                agent.setDefaultAction("Idle");
            }

            @Override
            public boolean update(long frameTime, double step) {
                return true;
            }
        };
        this.talkBehavior = new TalkBehavior(ed, this, "Idle", 20.0);
        this.followBehavior = new FollowBehavior(ed, this, "Idle", 20.0);
        this.gaefen = new Behavior(){
            private double flockCheck = 0.0;
            private Behavior lastFlock;
            private boolean running;

            @Override
            public void start() {
                this.running = true;
            }

            @Override
            public boolean isRunning() {
                return this.running;
            }

            @Override
            public boolean update(long frameTime, double step) {
                List<RigidBody<EntityId, MBlockShape>> bodies;
                Brain.this.hunger += step;
                this.flockCheck += step;
                if (this.flockCheck > 5.0) {
                    this.flockCheck = 0.0;
                    bodies = agent.queryNearBodies();
                    if (bodies.isEmpty()) {
                        log.info(agent.getEntityId() + " is getting lonelier.");
                        Brain.this.lonely += 1.0;
                    } else {
                        Brain.this.lonely = 0.0;
                        if (this.lastFlock == Brain.this.getCurrentBehavior()) {
                            log.info(agent.getEntityId() + " canceling flock.");
                            Brain.this.setCurrentBehavior(null);
                        }
                    }
                }
                if (Brain.this.hunger > 60.0) {
                    log.info("Eating");
                    Brain.this.setCurrentBehavior(eat);
                    return true;
                }
                if (!Brain.this.followBehavior.isRunning() && Brain.this.followBehavior.getFollow() != null) {
                    log.info("Start following:" + Brain.this.followBehavior.getFollow());
                    Brain.this.behaviorName = "Follow";
                    Brain.this.setCurrentBehavior(Brain.this.followBehavior);
                    return true;
                }
                if (Brain.this.lonely > 5.0) {
                    log.info(agent.getEntityId() + " is very lonely:" + Brain.this.lonely);
                    if (this.lastFlock != Brain.this.getCurrentBehavior()) {
                        log.info(agent.getEntityId() + ":************** I'm lonely....");
                        bodies = agent.queryFarBodies();
                        RigidBody<EntityId, MBlockShape> found = null;
                        if (!bodies.isEmpty()) {
                            RigidBody<EntityId, MBlockShape> nearest = null;
                            double minDist = Double.POSITIVE_INFINITY;
                            RigidBody<EntityId, MBlockShape> nearestUs = null;
                            double minDistUs = Double.POSITIVE_INFINITY;
                            ShapeInfo ourShape = (ShapeInfo)ed.getComponent(agent.getEntityId(), ShapeInfo.class);
                            Vec3d ourLoc = agent.getLocation();
                            for (RigidBody<EntityId, MBlockShape> b : bodies) {
                                ShapeInfo shape;
                                double d = ourLoc.distanceSq(b.position);
                                if (d < minDist) {
                                    nearest = b;
                                    minDist = d;
                                }
                                if (!(d < minDistUs) || (shape = (ShapeInfo)ed.getComponent((EntityId)b.id, ShapeInfo.class)).getShapeId() != ourShape.getShapeId()) continue;
                                nearestUs = b;
                                minDistUs = d;
                            }
                            log.info("Nearest:" + nearest + "  nearestUs:" + nearestUs);
                            found = nearestUs != null ? nearestUs : nearest;
                        }
                        log.info("------------------------Found:" + found);
                        if (found != null) {
                            SteeringPrimitive go = SteeringPrimitives.arrive(agent, found.position, 1.0);
                            go = SteeringPrimitives.scaleSpeed(go, 0.5);
                            Behavior flock = Behaviors.constant(Brain.this, "Idle", go);
                            flock = Behaviors.limited(flock, 30.0);
                            ShapeInfo shape = (ShapeInfo)ed.getComponent((EntityId)found.id, ShapeInfo.class);
                            if (shape != null) {
                                ShapeName shapeName = ShapeName.parse(shape.getShapeName(ed));
                                Brain.this.behaviorName = "flock:" + shapeName.getName();
                            } else {
                                Brain.this.behaviorName = "flock:" + ((EntityId)found.id).getId();
                            }
                            this.lastFlock = flock;
                            Brain.this.setCurrentBehavior(flock);
                        }
                    } else {
                        log.info(agent.getEntityId() + ":is already flocking");
                    }
                }
                if (Brain.this.currentBehavior != Brain.this.defaultBehavior) {
                    return true;
                }
                if (Brain.this.hunger > 10.0) {
                    log.info("Idle eating");
                    Brain.this.setCurrentBehavior(eat);
                    return true;
                }
                return true;
            }

            @Override
            public void stop() {
                this.running = false;
            }
        };
        this.basicNpc = new Behavior(){
            private boolean running;

            @Override
            public void start() {
                this.running = true;
                Brain.this.setCurrentBehavior(Behaviors.limited(Brain.this.standStill, 2.0));
            }

            @Override
            public boolean isRunning() {
                return this.running;
            }

            @Override
            public boolean update(long frameTime, double step) {
                if (!Brain.this.talkBehavior.isRunning() && Brain.this.talkBehavior.hasConversers()) {
                    log.info("Turning on talk behavior...");
                    Brain.this.behaviorName = "Talking";
                    Brain.this.setCurrentBehavior(Brain.this.talkBehavior);
                    return true;
                }
                if (Brain.this.currentBehavior != Brain.this.defaultBehavior) {
                    return true;
                }
                if (Brain.this.home == null) {
                    double idleTime = Math.random() * 2.0;
                    Brain.this.setCurrentBehavior(Behaviors.limited(Brain.this.standStill, idleTime));
                    Brain.this.behaviorName = "No home";
                    return true;
                }
                double roll = Math.random();
                if (roll < 0.5) {
                    double idleTime = Math.random() * 2.0;
                    Brain.this.behaviorName = "Idle:" + idleTime;
                    Brain.this.setCurrentBehavior(Behaviors.limited(Brain.this.standStill, idleTime));
                    return true;
                }
                if (Brain.this.home != null && roll < 0.75 && Brain.this.home.distanceSq(agent.getLocation()) > 1.0) {
                    Brain.this.behaviorName = "Heading home:" + Brain.this.home;
                    Brain.this.setCurrentBehavior(Behaviors.limited(Behaviors.constant(Brain.this, "Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.arrive(agent, Brain.this.home, 0.5), 0.25)), 10.0));
                    return true;
                }
                double idleTime = 2.0 + Math.random() * 2.0;
                Brain.this.behaviorName = "Wandering for:" + idleTime;
                Brain.this.setCurrentBehavior(Behaviors.limited(Behaviors.constant(Brain.this, "Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.25)), idleTime));
                return true;
            }

            @Override
            public void stop() {
                this.running = false;
            }
        };
    }

    public AgentDriver getAgent() {
        return this.agent;
    }

    public void signal(String signal, Object ... args) {
        log.info("signal(" + signal + ", " + Arrays.asList(args) + ")");
        if ("Talking".equals(signal)) {
            EntityId converser = (EntityId)args[0];
            log.info("Stand still and face:" + converser);
            this.talkBehavior.addConverser(converser);
        } else if ("Done Talking".equals(signal)) {
            if (args.length > 1) {
                log.info("Saying:" + args[1]);
                this.say(String.valueOf(args[1]));
            }
            EntityId converser = (EntityId)args[0];
            log.info("Done talking to:" + converser);
            this.talkBehavior.removeConverser(converser);
        } else if ("Pet".equals(signal)) {
            EntityId petter = (EntityId)args[0];
            BodyPosition bPos = (BodyPosition)this.ed.getComponent(petter, BodyPosition.class);
            if (bPos != null) {
                log.info("Will follow:" + petter);
                this.followBehavior.setFollow(new BodyPositionMob(bPos));
            }
        } else {
            log.info("Unhandled signal:" + signal);
        }
    }

    public void setAgentType(String type, int level) {
        log.info("setAgentType(" + type + ", " + level + ")");
        if ("Gaefen".equals(type)) {
            this.globalBehavior = this.gaefen;
            this.defaultBehavior = Behaviors.constant(this, "Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.25));
        } else {
            this.globalBehavior = this.basicNpc;
            this.defaultBehavior = Behaviors.constant(this, "Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0));
        }
        EntityId agentId = this.agent.getEntityId();
        EntityId homeId = this.ed.findEntity(LocationRelationship.sourceFilter(agentId), new Class[]{LocationRelationship.class});
        if (homeId != null) {
            this.home = ((LocationRelationship)this.ed.getComponent(homeId, LocationRelationship.class)).getLocation();
            log.info("Setting home to:" + this.home);
        }
    }

    protected void setDebugText(String debugText) {
        if (Objects.equals(this.debugText, debugText)) {
            return;
        }
        this.debugText = debugText;
        this.ed.setComponent(this.agent.getEntityId(), (EntityComponent)new DebugText(debugText));
    }

    public void say(String text) {
        this.agent.getChatProvider().say(text);
        this.say(text, this.lastFrameTime, 4.0);
    }

    protected void say(String text, long startTime, double duration) {
        this.setStatusText(0, "\"" + text + "\"", startTime, duration);
    }

    protected void setStatusText(int type, String text, long startTime, double duration) {
        log.info(this.agent.getEntityId() + " - setStatusText(" + type + ", " + text + ", " + startTime + ", " + duration + ")");
        this.ed.setComponent(this.agent.getEntityId(), (EntityComponent)new StatusText(type, text, startTime, duration));
    }

    public void setCurrentBehavior(Behavior currentBehavior) {
        if (this.currentBehavior != null && this.currentBehavior == currentBehavior) {
            return;
        }
        if (this.currentBehavior != null) {
            this.currentBehavior.stop();
        }
        if (currentBehavior == null) {
            this.behaviorName = "default";
        }
        Behavior behavior = this.currentBehavior = currentBehavior == null ? this.defaultBehavior : currentBehavior;
        if (this.currentBehavior != null) {
            this.currentBehavior.start();
        }
    }

    public Behavior getCurrentBehavior() {
        return this.currentBehavior;
    }

    public void update(long frameTime, double step) {
        this.lastFrameTime = frameTime;
        if (this.globalBehavior != null) {
            this.globalBehavior.update(frameTime, step);
        }
        if (this.currentBehavior == null) {
            this.setCurrentBehavior(null);
        }
        if (!this.currentBehavior.update(frameTime, step)) {
            this.setCurrentBehavior(null);
        }
        String s = String.format("H:%.02f L:%.02f", this.hunger, this.lonely);
        this.setDebugText(this.behaviorName + ":" + this.agent.getDefaultAction() + ":" + s);
    }
}

