/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.sim.AnimPump;
import com.simsilica.mathd.Vec3d;
import mythruna.sim.ai.AgentMovementInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigAnimator {
    static Logger log = LoggerFactory.getLogger(RigAnimator.class);
    private RigShape rigShape;
    private AnimPump animPump;
    private double averageWalkSpeed = 0.0;
    private String defaultAction = "Idle";
    public boolean human = false;

    public RigAnimator(RigShape rigShape) {
        this.rigShape = rigShape;
        this.animPump = new AnimPump((CharacterRig)rigShape, null);
        this.animPump.setCurrentAction("Idle", 1.0);
        rigShape.update();
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public void update(AgentMovementInput input, Vec3d actualVelocity, boolean onGround, double step) {
        double effectiveSpeed;
        if (step <= 0.0) {
            return;
        }
        String action = this.defaultAction;
        double animSpeed = 1.0;
        if (!onGround) {
            effectiveSpeed = 0.0;
            action = this.human ? "Jog" : "Run";
            animSpeed = 0.5;
        } else {
            Vec3d walkVelocity = actualVelocity.clone();
            walkVelocity.y = 0.0;
            effectiveSpeed = walkVelocity.length();
        }
        this.averageWalkSpeed = effectiveSpeed != 0.0 && this.averageWalkSpeed == 0.0 ? effectiveSpeed : (this.averageWalkSpeed * 4.0 + effectiveSpeed) / 5.0;
        if (log.isTraceEnabled()) {
            log.trace(String.format("averageWalkSpeed: %.04f  effectiveSpeed: %.04f", this.averageWalkSpeed, effectiveSpeed));
        }
        double moveThreshold = Math.abs(this.averageWalkSpeed);
        if (!this.human) {
            if (!(moveThreshold < 0.01)) {
                if (moveThreshold <= 0.7) {
                    action = "Walk";
                    animSpeed = 2.0 * (this.averageWalkSpeed / 0.7);
                } else if (moveThreshold < 5.0) {
                    action = "Run";
                    animSpeed = this.averageWalkSpeed / 0.7;
                }
            }
        } else if (!(moveThreshold < 0.001)) {
            if (moveThreshold < 1.8) {
                action = "Walk";
                animSpeed = 9.0 * (this.averageWalkSpeed / 2.0);
            } else {
                action = "Jog";
                animSpeed = this.averageWalkSpeed;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("     action:" + action + "   animSpeed:" + animSpeed);
        }
        if (action != null) {
            this.animPump.setCurrentAction(action, animSpeed);
            this.animPump.update(step);
            this.rigShape.update();
        }
    }
}

