/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import java.util.HashSet;
import java.util.Set;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkBehavior
extends AbstractBehavior {
    static Logger log = LoggerFactory.getLogger(TalkBehavior.class);
    private EntityData ed;
    private Brain brain;
    private String defaultAction;
    private Set<EntityId> conversers = new HashSet<EntityId>();
    private boolean resetFacing = false;
    private double maxWait;
    private double timeout;

    public TalkBehavior(EntityData ed, Brain brain, String defaultAction, double maxWait) {
        super(brain);
        this.ed = ed;
        this.brain = brain;
        this.defaultAction = defaultAction;
        this.maxWait = maxWait;
    }

    public void addConverser(EntityId id) {
        log.info("addConverser(" + id + ")");
        this.conversers.add(id);
        this.resetFacing = true;
        this.timeout = this.maxWait;
    }

    public void removeConverser(EntityId id) {
        log.info("removeConverser(" + id + ")");
        this.conversers.remove(id);
        this.resetFacing = true;
    }

    public boolean hasConversers() {
        return !this.conversers.isEmpty();
    }

    @Override
    protected void onStart() {
        log.info("onStart()");
        this.resetFacing = true;
        this.brain.getAgent().setDefaultAction(this.defaultAction);
    }

    @Override
    public boolean update(long frameTime, double step) {
        if (this.conversers.isEmpty()) {
            log.info("Done talking");
            return false;
        }
        this.timeout -= step;
        if (this.timeout < 0.0) {
            log.info("Got tired of waiting for more conversation.");
            this.conversers.clear();
            return false;
        }
        if (!this.resetFacing) {
            return true;
        }
        this.resetFacing = false;
        Vec3d center = new Vec3d();
        int count = 0;
        for (EntityId id : this.conversers) {
            BodyPosition bPos = (BodyPosition)this.ed.getComponent(id, BodyPosition.class);
            if (bPos == null) continue;
            center.addLocal(bPos.getLastLocation());
            ++count;
        }
        if (count > 0) {
            center.divideLocal((double)count);
            log.info("Want to look at:" + center);
            this.brain.getAgent().setSteering(SteeringPrimitives.faceLocation(this.brain.getAgent(), center));
        } else {
            log.warn("Somehow we found no locations for:" + this.conversers);
            this.brain.getAgent().setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
        }
        return true;
    }

    @Override
    protected void onStop() {
        log.info("onStop()");
    }
}

