/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LeafInfo;

public class LeafData
implements CellData {
    private LeafInfo info;
    private CellArray cells;
    private int emptyCells;

    public LeafData(LeafId id, long version) {
        this(new LeafInfo(id.getWorld(null), id, new DataVersion(version)));
    }

    public LeafData(LeafInfo info) {
        this(info, null, 32768);
    }

    public LeafData(LeafInfo info, CellArray cells, int emptyCellCount) {
        this.info = info;
        this.cells = cells;
        this.emptyCells = emptyCellCount;
        if (cells == null && !this.isEmpty()) {
            throw new IllegalArgumentException("Cells array is null but leaf is not empty");
        }
    }

    public final int getEmptyCellCount() {
        return this.emptyCells;
    }

    public final boolean isEmpty() {
        return this.emptyCells == 32768;
    }

    public final boolean containsCell(Vec3i world) {
        return this.containsCell(world.x, world.y, world.z);
    }

    public final boolean containsCell(int x, int y, int z) {
        return this.isValid(x -= this.info.location.x, y -= this.info.location.y, z -= this.info.location.z);
    }

    private boolean isValid(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return false;
        }
        return x < 32 && y < 32 && z < 32;
    }

    public int getCell(int x, int y, int z) {
        return this.cells == null ? 0 : this.cells.getCell(x, y, z);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        return this.cells == null ? 0 : this.cells.getCell(x, y, z, defaultValue);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        return this.cells == null ? 0 : this.cells.getCell(x, y, z, dir, defaultValue);
    }

    public void setCell(int x, int y, int z, int value) {
        if (this.cells == null) {
            this.cells = new CellArray(32);
            this.cells.setCell(x, y, z, value);
            --this.emptyCells;
            return;
        }
        int oldVal = this.cells.getCell(x, y, z);
        this.cells.setCell(x, y, z, value);
        if (oldVal == 0 && value != 0) {
            --this.emptyCells;
        } else if (oldVal != 0 && value == 0) {
            ++this.emptyCells;
        }
    }

    public LeafId getLeafId() {
        return this.info.leafId;
    }

    public LeafInfo getInfo() {
        return this.info;
    }

    public CellArray getRawCells() {
        return this.cells;
    }

    public int[] getArray() {
        return this.cells == null ? null : this.cells.getArray();
    }
}

