/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.db.AbstractColumnDb;
import com.simsilica.mworld.db.ParentIdFileFunction;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.io.ColumnDataProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedColumnDb
extends AbstractColumnDb {
    static Logger log = LoggerFactory.getLogger(GeneratedColumnDb.class);
    private Function<ColumnId, File> fileFunc;
    private ColumnDataProtocol protocol = new ColumnDataProtocol();
    private Function<ColumnId, ColumnData> generator;
    private LoadingCache<ColumnId, ColumnData> cache;
    private SpoolingObjectDb<ColumnId, ColumnData> storage;

    public GeneratedColumnDb(File root, Function<ColumnId, ColumnData> generator) {
        this(generator, new ParentIdFileFunction<ColumnId>(root, "col"));
    }

    public GeneratedColumnDb(Function<ColumnId, ColumnData> generator, Function<ColumnId, File> fileFunc) {
        this.generator = generator;
        this.fileFunc = fileFunc;
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new ColumnLoader());
        this.storage = new SpoolingObjectDb<ColumnId, ColumnData>("columns"){

            @Override
            protected ColumnData loadObject(ColumnId id) {
                return GeneratedColumnDb.this.loadColumn(id);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void storeObject(ColumnId id, ColumnData data) {
                ColumnData columnData = data;
                synchronized (columnData) {
                    GeneratedColumnDb.this.writeColumn(data);
                }
            }
        };
    }

    @Override
    public void initialize() {
        this.storage.initialize();
    }

    @Override
    public void terminate() {
        this.storage.terminate();
    }

    @Override
    public ColumnData getColumn(ColumnId columnId) {
        return (ColumnData)this.cache.getUnchecked((Object)columnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markChanged(ColumnData col) {
        DataVersion version;
        DataVersion dataVersion = version = col.getVersion();
        synchronized (dataVersion) {
            if (version.getLoadVersion() == -1L) {
                version.resetChanged(System.currentTimeMillis());
                version.markChanged();
            }
        }
        this.storage.update(col.getColumnId(), col);
    }

    protected ColumnData loadColumn(ColumnId columnId) {
        File f = this.fileFunc.apply(columnId);
        if (f.exists()) {
            return this.readColumn(f);
        }
        if (log.isDebugEnabled()) {
            log.debug("generate column(" + columnId + ")");
        }
        ColumnData result = this.generator.apply(columnId);
        this.columnGenerated(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ColumnData readColumn(File f) {
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(f)));){
            ColumnData columnData = this.protocol.read(in);
            return columnData;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading column:" + f, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeColumn(ColumnData col) {
        DataVersion version;
        File f = this.fileFunc.apply(col.getColumnId());
        DataVersion dataVersion = version = col.getVersion();
        synchronized (dataVersion) {
            this.writeColumn(f, col);
            col.resetChanged(System.currentTimeMillis());
        }
    }

    protected void writeColumn(File f, ColumnData col) {
        long start = System.nanoTime();
        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(f)));){
            this.protocol.write(col, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing column:" + f, e);
        }
        long end = System.nanoTime();
        log.info("Wrote column [" + col + "] in " + (double)(end - start) / 1000000.0 + " ms");
    }

    protected class ColumnLoader
    extends CacheLoader<ColumnId, ColumnData> {
        protected ColumnLoader() {
        }

        public ColumnData load(ColumnId id) {
            return (ColumnData)GeneratedColumnDb.this.storage.get(id);
        }
    }
}

