/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mythruna.client.GameSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundRetrieverState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(BackgroundRetrieverState.class);
    private String poolId;
    private JobState workers;
    private EntityData ed;
    private LoadingCache<ComponentKey, RetrievalQueue> componentQueues;
    private LoadingCache<Integer, RetrievalQueue> stringQueues;
    private LoadingCache<QueryKey, RetrievalQueue> queryQueues;

    public BackgroundRetrieverState(String poolId) {
        this.poolId = poolId;
        this.componentQueues = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<ComponentKey, RetrievalQueue>(){

            public RetrievalQueue load(ComponentKey key) {
                return new RetrievalQueue(() -> BackgroundRetrieverState.this.ed.getComponent(key.entityId, key.componentType));
            }
        });
        this.stringQueues = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Integer, RetrievalQueue>(){

            public RetrievalQueue load(Integer key) {
                return new RetrievalQueue(() -> BackgroundRetrieverState.this.ed.getStrings().getString(key.intValue()));
            }
        });
        this.queryQueues = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<QueryKey, RetrievalQueue>(){

            public RetrievalQueue load(QueryKey key) {
                return new RetrievalQueue(key.query);
            }
        });
    }

    public <T extends EntityComponent> void getComponent(EntityId entityId, Class<T> type, Consumer<T> callback) {
        RetrievalQueue queue = (RetrievalQueue)this.componentQueues.getUnchecked((Object)new ComponentKey(entityId, type));
        queue.addCallback(callback);
    }

    public void getString(Integer id, Consumer<String> callback) {
        RetrievalQueue queue = (RetrievalQueue)this.stringQueues.getUnchecked((Object)id);
        queue.pumpCallback(callback);
    }

    public <T> void query(Object key, Supplier<T> query, Consumer<T> callback) {
        RetrievalQueue queue = (RetrievalQueue)this.queryQueues.getUnchecked((Object)new QueryKey(key, query));
        queue.addCallback(callback);
    }

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.workers = this.poolId != null ? (JobState)this.getState(this.poolId, JobState.class, true) : (JobState)this.getState(JobState.class, true);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    private static class ComponentKey {
        private EntityId entityId;
        private Class<? extends EntityComponent> componentType;

        public ComponentKey(EntityId entityId, Class<? extends EntityComponent> componentType) {
            this.entityId = entityId;
            this.componentType = componentType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ComponentKey other = (ComponentKey)o;
            if (!Objects.equals(this.entityId, other.entityId)) {
                return false;
            }
            return this.componentType == other.componentType;
        }

        public int hashCode() {
            return Objects.hash(this.entityId, this.componentType);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("entityId", (Object)this.entityId).add("componentType", this.componentType).toString();
        }
    }

    private class RetrievalQueue
    implements Job {
        private Supplier supplier;
        private List<Consumer> callbacks = new ArrayList<Consumer>();
        private List<Consumer> respondTo = null;
        private volatile Object value;

        public RetrievalQueue(Supplier supplier) {
            this.supplier = supplier;
        }

        protected synchronized void enqueueIfNeeded() {
            if (this.callbacks.isEmpty()) {
                return;
            }
            BackgroundRetrieverState.this.workers.execute((Job)this, 0);
        }

        public synchronized void addCallback(Consumer callback) {
            this.callbacks.add(callback);
            this.enqueueIfNeeded();
        }

        public synchronized void pumpCallback(Consumer callback) {
            if (this.value != null) {
                callback.accept(this.value);
                return;
            }
            this.addCallback(callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOnWorker() {
            RetrievalQueue retrievalQueue = this;
            synchronized (retrievalQueue) {
                if (this.callbacks.isEmpty()) {
                    return;
                }
                this.respondTo = this.callbacks;
                this.callbacks = new ArrayList<Consumer>();
            }
            this.value = this.supplier.get();
        }

        public double runOnUpdate() {
            double work = 0.0;
            if (this.respondTo != null) {
                for (Consumer callback : this.respondTo) {
                    callback.accept(this.value);
                    work += 0.1;
                }
            }
            this.enqueueIfNeeded();
            return work;
        }
    }

    private static class QueryKey {
        private Object key;
        private Supplier query;

        public QueryKey(Object key, Supplier query) {
            this.key = key;
            this.query = query;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            QueryKey other = (QueryKey)o;
            if (!Objects.equals(this.key, other.key)) {
                return false;
            }
            return this.query == other.query;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.query);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("key", this.key).add("query", (Object)this.query).toString();
        }
    }
}

