/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.RigType;
import com.simsilica.crig.jme.AttachmentPointImpl;
import com.simsilica.crig.jme.ColliderShape;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.Part;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimComposerShape
extends RigShape {
    static Logger log = LoggerFactory.getLogger(AnimComposerShape.class);
    private RigType rigType;
    private CharacterRig delegate;
    private Runnable update;
    private ColliderShape[] shapes;
    private AttachmentPointImpl[] attachments;
    private Map<String, AttachmentPointImpl> attachmentIndex = new HashMap<String, AttachmentPointImpl>();

    public AnimComposerShape(RigType rigType, Group root, CharacterRig delegate, Runnable update, ColliderShape[] shapes, AttachmentPointImpl[] attachments) {
        super((Part)root);
        this.rigType = rigType;
        this.delegate = delegate;
        this.update = update;
        this.shapes = shapes;
        this.attachments = attachments;
        for (AttachmentPointImpl att : attachments) {
            this.attachmentIndex.put(att.getInfo().getName(), att);
        }
    }

    @Override
    public RigType getRigType() {
        return this.rigType;
    }

    public CharacterRig getDelegate() {
        return this.delegate;
    }

    @Override
    public void update() {
        this.update.run();
        for (ColliderShape shape : this.shapes) {
            shape.update();
        }
    }

    @Override
    public void setMix(String blendId, double value) {
        this.delegate.setMix(blendId, value);
        this.fireMixChanged(blendId, value);
    }

    @Override
    public double getMix(String blendId) {
        return this.delegate.getMix(blendId);
    }

    @Override
    public void setTime(String layerId, double time) {
        this.delegate.setTime(layerId, time);
    }

    @Override
    public double getTime(String layer) {
        return this.delegate.getTime(layer);
    }

    @Override
    public void setLayerAction(String layerId, String actionId) {
        this.delegate.setLayerAction(layerId, actionId);
        this.fireLayerActionChanged(layerId, actionId);
    }

    @Override
    public String getLayerAction(String layer) {
        return this.delegate.getLayerAction(layer);
    }

    @Override
    public double getLayerDuration(String layerId) {
        return this.delegate.getLayerDuration(layerId);
    }

    @Override
    public AttachmentPoint getAttachmentPoint(String name) {
        return this.attachmentIndex.get(name);
    }
}

