/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */

import java.util.function.Consumer;
import mythruna.sim.time.*;

// Get the time settings system to which we'll register
// time-based update events.
timeSettings = system(WorldTimeSettingsSystem.class);

worldTime = system(WorldTime.class);

// Keep track of the registered callbacks so that we can remove
// them again
registeredTimeSettings = []; 

addTimeSetting = { Consumer<WorldTime> callback ->
    timeSettings.addSetting(callback);
    registeredTimeSettings.add(callback);
    return callback;
}

removeTimeSetting = { Consumer<WorldTime> callback ->
    timeSettings.removeSetting(callback);
    registeredTimeSettings.remove(callback);
    return callback;
}

cleanupTimeSettings = {
    registeredTimeSettings.each { setting ->
        timeSettings.removeSetting(setting);
    }
    registeredTimeSettings.clear();
}

TweenSchedule.metaClass {
    interpolate() { Closure interp ->
log.info("interpolate:" + interp);    
        if( interp.getParameterTypes().length != 3 ) {
            throw new IllegalArgumentException("Interpolation closure must have three parameters.");
        }    
        delegate.tweenFactory = { length, start, end ->
            Tween result = new AbstractTween(length) {
                @Override
                protected void doInterpolate( double t ) {
                    interp(t, start, end);
                }
            }
        }
        return delegate;
    }
}

addSchedule = { String interval ->
    def sched = new TweenSchedule();
    sched.interval = TimeInterval.parseInterval(interval);
    addTimeSetting(sched);
    return sched;    
}

scheduledDouble = { String interval, Closure config ->
    def supplier = new ScheduledSupplier(worldTime, TimeInterval.parseInterval(interval));
    supplier.with config;
    return supplier; 
}


//def sched = new TweenSchedule();
//sched.interval = TimeInterval.parseInterval("0:30");
//sched.tweenFactory = { length, start, end ->
//    Tween result = new AbstractTween(length) {
//        @Override
//        protected void doInterpolate( double t ) {
//            def val = start + (end - start) * t;
//            //println "Test:" + val;
//            env.setMoonPhase((int)val);
//        } 
//    }
//    return result;
//}

//def sched = addSchedule("0:30").with {
//    interpolate = { t, start, end ->
//        log.into("t:" + t + " start:" + start + " end:" + end);
//    }
//    at("0:00", 0)
//    at("0:15", 24)
//}



// Cleanup any of the registered settings
mod.onTerminate {
    cleanupTimeSettings();
}


