/*
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */

createType("BuildWand").with {
    supertypes("BaseItem");

    setTypeVar("manipulator", "Digger");
    setTypeVar("description",
              "The Build Wand is used for placing and removing blocks.",
              "",
              "The right mouse button will place the current block type",
              "and the left mouse button will remove the block under the",
              "cursor (highlighted yellow).",
              "",
              "Press 'e' to open the block type selector menu.",
              "Press 'c' to select the block under the cursor as the",
              "current type.",
              "",
              "The selected block will appear in the bottom center of the",
              "screen.  If the block supports multiple rotations then the",
              "mouse wheel will change the block rotation."
            );
    setTypeVar("handleLocation", new Vec3d(1.5, 1.5, 3));

    setTypeVar("shape",
               ShapeInfo.create("/Models/items/wand1.blocks", standardItemScale * 0.5)); 
    setTypeVar("volume", new ObjectVolume(new Vec3d(3, 3, 13).multLocal(standardItemScale * 0.5)));

    addAction("startDigging") { Vec3i loc ->
        log.info("" + context + ".startDigging(" + loc + ")");
    }

    addAction("stopDigging") { Vec3i loc ->
        log.info("" + context + ".stopDigging(" + loc + ")");

        // Perform validation to make sure the player isn't cheating.
        // FIXME: add distance check
        // FIXME: add line of sight check

        // Are they allowed to edit here?
        if( !getPerms(activator, loc).canRemoveBlock() ) {
            echo("You do not have permission to remove blocks here.");
            return;
        }
        world.setWorldCell(loc.toVec3d(), 0);

        // 2022-11-09 - Puting this note here but it applies to the
        // whole digger tool.
        //
        // I originally thought to limit the client's ability to specify
        // specific blocks/types and resolve all of that on the server.
        // That way there would be no possibility for "cheating" or hacked
        // clients poking data all over the world as they see fit.
        // But, there is the possibility that they've turned a little before
        // their click is processed... and since that information comes in as UDP
        // there is a good chance we then point in the wrong place here.
        // This is especially apparent when the client starts predicting their
        // own block edits to avoid the round-trip delay.  It happens quite often
        // that the client thinks it placed a block in one place but the server
        // thinks another.
        //
        // So we fall back.  Now the client will tell us where it clicked
        // and what type was selected.  We have to do extra work to see if
        // they are allowed to do that or are cheating.
        //
        // Also, thinking about this today, maybe we want to allow certain
        // users to cheat by adding some perms... we can do that now.
        //
        //def hits = activator.pick();
        //
        //if( hits.hasNext() ) {
        //    def intersect = hits.next();
        //    if( !getPerms(activator, intersect.getBlock()).canRemoveBlock() ) {
        //        echo("You do not have permission to remove blocks here.");
        //        return;
        //    }
        //    world.setWorldCell(intersect.getBlock().toVec3d(), 0);
        //}
    }

    addAction("startFilling") { Vec3i loc, Integer selected ->
        log.info("" + context + ".startFilling()");
    }

    addAction("stopFilling") { Vec3i loc, Integer selected ->
        log.info("" + context + ".stopFilling()");

        // Perform validation to make sure the player isn't cheating.
        // FIXME: add distance check
        // FIXME: add line of sight check

        // Are they allowed to edit here?
        if( !getPerms(activator, loc).canAddBlock() ) {
            echo("You do not have permission to place blocks here.");
            return;
        }
        log.info("claim:" + getClaim(activator, loc));
        world.setWorldCell(loc.toVec3d(), selected);

        //def selected = env.getVar("selectedType", 1);
        //def hits = activator.pick();
        //if( hits.hasNext() ) {
        //    def intersect = hits.next();
        //    def pos = intersect.getBlock().toVec3d();
        //    pos.addLocal(intersect.getNormal());
        //    if( !getPerms(activator, pos).canAddBlock() ) {
        //        echo("You do not have permission to place blocks here.");
        //        return;
        //    }
        //    log.info("claim:" + getClaim(activator, pos));
        //    world.setWorldCell(pos, selected);
        //}
    }

    addAction("selectType") { Integer index ->
        log.info("" + context + ".selectType(" + index + ")");

        env.setVar("selectedType", index);
        context << ObjectFocus.blockType(index);
    }

    addAction("rotate") { Integer index ->
        log.info("" + context + ".rotate(" + index + ")");
        // Handled by the client right now
    }
}


