/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.simsilica.lemur.core.VersionedObject;

public class VersionedReference<T> {
    private VersionedObject<T> object;
    private long lastVersion = -1L;

    public VersionedReference(VersionedObject<T> object) {
        this.object = object;
        this.lastVersion = object.getVersion();
    }

    public long getLastVersion() {
        return this.lastVersion;
    }

    public long getObjectVersion() {
        return this.object.getVersion();
    }

    public boolean needsUpdate() {
        return this.lastVersion != this.object.getVersion();
    }

    public boolean update() {
        if (this.lastVersion == this.object.getVersion()) {
            return false;
        }
        this.lastVersion = this.object.getVersion();
        return true;
    }

    public T get() {
        return this.object.getObject();
    }
}

